/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.execution.complexity.ComplexityAnalysisInstrumentation;
import io.leangen.graphql.execution.complexity.JavaScriptEvaluator;
import io.leangen.graphql.util.ContextUtils;
import java.util.ArrayList;
import java.util.List;

public class GraphQLRuntime {
    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public static class ContextWrappingInstrumentation
    extends SimpleInstrumentation {
        public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters) {
            return ContextUtils.wrapContext(executionInput);
        }
    }

    public static class Builder
    extends GraphQL.Builder {
        private final List<Instrumentation> instrumentations;

        private Builder(GraphQLSchema graphQLSchema) {
            super(graphQLSchema);
            ArrayList<Instrumentation> defaultInstrumentations = new ArrayList<Instrumentation>();
            defaultInstrumentations.add((Instrumentation)new ContextWrappingInstrumentation());
            this.instrumentations = defaultInstrumentations;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentations.add(instrumentation);
            return this;
        }

        public Builder maximumQueryComplexity(int limit) {
            this.instrumentations.add((Instrumentation)new ComplexityAnalysisInstrumentation(new JavaScriptEvaluator(), limit));
            return this;
        }

        public GraphQL build() {
            if (this.instrumentations.size() == 1) {
                super.instrumentation(this.instrumentations.get(0));
            } else if (!this.instrumentations.isEmpty()) {
                super.instrumentation((Instrumentation)new ChainedInstrumentation(this.instrumentations));
            }
            return super.build();
        }
    }
}

