/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import java.lang.reflect.AnnotatedType;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OperationSource {
    private final Supplier<Object> serviceBeanSupplier;
    private final AnnotatedType javaType;
    private final Collection<ResolverBuilder> resolverBuilders;

    OperationSource(Supplier<Object> serviceBeanSupplier, AnnotatedType javaType, Collection<ResolverBuilder> resolverBuilders) {
        this.serviceBeanSupplier = serviceBeanSupplier;
        this.javaType = javaType;
        this.resolverBuilders = resolverBuilders;
    }

    OperationSource(AnnotatedType javaType, Collection<ResolverBuilder> resolverBuilders) {
        this(null, javaType, resolverBuilders);
    }

    Supplier<Object> getServiceBeanSupplier() {
        return this.serviceBeanSupplier;
    }

    AnnotatedType getJavaType() {
        return this.javaType;
    }

    Collection<ResolverBuilder> getResolverBuilders() {
        return this.resolverBuilders.stream().filter(builder -> builder.supports(this.javaType)).collect(Collectors.toList());
    }
}

