/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import io.leangen.graphql.generator.OperationSource;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import java.lang.reflect.AnnotatedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Supplier;

public class OperationSourceRegistry {
    private final Collection<ResolverBuilder> topLevelResolverBuilders = new LinkedHashSet<ResolverBuilder>();
    private final Collection<ResolverBuilder> nestedResolverBuilders = new LinkedHashSet<ResolverBuilder>();
    private final Collection<OperationSource> operationSources = new HashSet<OperationSource>();

    public void registerOperationSource(Supplier<Object> querySourceBeanSupplier, AnnotatedType beanType) {
        this.operationSources.add(new OperationSource(querySourceBeanSupplier, beanType, this.topLevelResolverBuilders));
    }

    public void registerOperationSource(Supplier<Object> querySourceBeanSupplier, AnnotatedType beanType, Collection<ResolverBuilder> extractors) {
        this.operationSources.add(new OperationSource(querySourceBeanSupplier, beanType, extractors.isEmpty() ? this.topLevelResolverBuilders : extractors));
    }

    public void registerOperationSource(AnnotatedType serviceType) {
        this.operationSources.add(new OperationSource(serviceType, this.topLevelResolverBuilders));
    }

    public void registerOperationSource(AnnotatedType serviceType, Collection<ResolverBuilder> strategies) {
        this.operationSources.add(new OperationSource(serviceType, strategies));
    }

    public void registerGlobalResolverBuilders(Collection<ResolverBuilder> resolverDetectionStrategies) {
        this.topLevelResolverBuilders.addAll(resolverDetectionStrategies);
    }

    public void registerGlobalNestedResolverBuilders(Collection<ResolverBuilder> resolverDetectionStrategies) {
        this.nestedResolverBuilders.addAll(resolverDetectionStrategies);
    }

    public OperationSource nestedSourceForType(AnnotatedType domainType) {
        return new OperationSource(domainType, this.nestedResolverBuilders);
    }

    public Collection<OperationSource> getOperationSources() {
        return this.operationSources;
    }

    public boolean isEmpty() {
        return this.operationSources.isEmpty();
    }
}

