/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import graphql.ExecutionInput;
import graphql.GraphQLContext;
import io.leangen.graphql.util.Utils;

public class ContextUtils {
    public static ExecutionInput wrapContext(ExecutionInput executionInput) {
        return ContextUtils.isDefault(executionInput.getContext()) ? executionInput : executionInput.transform(input -> input.context(ctx -> ctx.of(ContextKey.class, executionInput.getContext())));
    }

    public static Object unwrapContext(Object context) {
        GraphQLContext ctx;
        if (ContextUtils.isDefault(context) && (ctx = (GraphQLContext)context).hasKey(ContextKey.class)) {
            return ctx.get(ContextKey.class);
        }
        return context;
    }

    public static boolean isDefault(Object context) {
        return context != null && GraphQLContext.class.equals(context.getClass());
    }

    public static String getClientMutationId(Object context) {
        if (ContextUtils.isDefault(context)) {
            return (String)((GraphQLContext)context).get((Object)"clientMutationId");
        }
        return null;
    }

    public static void setClientMutationId(Object context, String clientMutationId) {
        if (Utils.isNotEmpty(clientMutationId) && ContextUtils.isDefault(context)) {
            ((GraphQLContext)context).put((Object)"clientMutationId", (Object)clientMutationId);
        }
    }

    private static class ContextKey {
        private ContextKey() {
        }
    }
}

