/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution;

import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFragmentSpreadEnvironment;
import graphql.analysis.QueryVisitorInlineFragmentEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import io.leangen.graphql.util.GraphQLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Directives {
    private Map<Introspection.DirectiveLocation, Map<String, List<Map<String, Object>>>> directives = new HashMap<Introspection.DirectiveLocation, Map<String, List<Map<String, Object>>>>();
    private static final ValuesResolver valuesResolver = new ValuesResolver();

    Directives(DataFetchingEnvironment env, ExecutionStepInfo step) {
        List fields = env.getMergedField().getFields();
        if (step != null) {
            fields = step.getField() != null ? step.getField().getFields() : Collections.emptyList();
        }
        step = step != null ? step : env.getExecutionStepInfo();
        fields.forEach(field -> this.directives.merge(Introspection.DirectiveLocation.FIELD, this.parseDirectives(field.getDirectives(), env), (directiveMap1, directiveMap2) -> {
            directiveMap2.forEach((directiveName, directiveValues) -> directiveMap1.merge(directiveName, directiveValues, (valueList1, valueList2) -> Stream.concat(valueList1.stream(), valueList2.stream()).collect(Collectors.toList())));
            return directiveMap1;
        }));
        Map<String, List<Map<String, Object>>> operationDirectives = this.parseDirectives(env.getOperationDefinition().getDirectives(), env);
        switch (env.getOperationDefinition().getOperation()) {
            case QUERY: {
                this.directives.put(Introspection.DirectiveLocation.QUERY, operationDirectives);
                this.directives.put(Introspection.DirectiveLocation.MUTATION, Collections.emptyMap());
                this.directives.put(Introspection.DirectiveLocation.SUBSCRIPTION, Collections.emptyMap());
                break;
            }
            case MUTATION: {
                this.directives.put(Introspection.DirectiveLocation.MUTATION, operationDirectives);
                this.directives.put(Introspection.DirectiveLocation.QUERY, Collections.emptyMap());
                this.directives.put(Introspection.DirectiveLocation.SUBSCRIPTION, Collections.emptyMap());
                break;
            }
            case SUBSCRIPTION: {
                this.directives.put(Introspection.DirectiveLocation.SUBSCRIPTION, operationDirectives);
                this.directives.put(Introspection.DirectiveLocation.QUERY, Collections.emptyMap());
                this.directives.put(Introspection.DirectiveLocation.MUTATION, Collections.emptyMap());
            }
        }
        if (OperationDefinition.Operation.MUTATION.equals((Object)env.getOperationDefinition().getOperation())) {
            this.directives.put(Introspection.DirectiveLocation.MUTATION, operationDirectives);
            this.directives.put(Introspection.DirectiveLocation.QUERY, Collections.emptyMap());
        } else {
            this.directives.put(Introspection.DirectiveLocation.QUERY, operationDirectives);
            this.directives.put(Introspection.DirectiveLocation.MUTATION, Collections.emptyMap());
        }
        if (step.hasParent() && step.getParent().getField() != null) {
            FragmentDirectiveCollector fragmentDirectiveCollector = FragmentDirectiveCollector.collect(env, step);
            this.directives.put(Introspection.DirectiveLocation.INLINE_FRAGMENT, this.parseDirectives(fragmentDirectiveCollector.getInlineFragmentDirs(), env));
            this.directives.put(Introspection.DirectiveLocation.FRAGMENT_SPREAD, this.parseDirectives(fragmentDirectiveCollector.getFragmentDirs(), env));
            this.directives.put(Introspection.DirectiveLocation.FRAGMENT_DEFINITION, this.parseDirectives(fragmentDirectiveCollector.getFragmentDefDirs(), env));
        } else {
            this.directives.put(Introspection.DirectiveLocation.INLINE_FRAGMENT, Collections.emptyMap());
            this.directives.put(Introspection.DirectiveLocation.FRAGMENT_SPREAD, Collections.emptyMap());
            this.directives.put(Introspection.DirectiveLocation.FRAGMENT_DEFINITION, Collections.emptyMap());
        }
    }

    private Map<String, List<Map<String, Object>>> parseDirectives(List<Directive> directives, DataFetchingEnvironment env) {
        return directives.stream().collect(Collectors.groupingBy(Directive::getName, Collectors.mapping(dir -> this.parseDirective((Directive)dir, env), Collectors.toList())));
    }

    private Map<String, Object> parseDirective(Directive dir, DataFetchingEnvironment env) {
        GraphQLDirective directive = env.getGraphQLSchema().getDirective(dir.getName());
        if (directive == null) {
            return null;
        }
        return Collections.unmodifiableMap(valuesResolver.getArgumentValues(env.getGraphQLSchema().getCodeRegistry(), directive.getArguments(), dir.getArguments(), env.getVariables()));
    }

    Map<Introspection.DirectiveLocation, Map<String, List<Map<String, Object>>>> getDirectives() {
        return this.directives;
    }

    public List<Map<String, Object>> find(Introspection.DirectiveLocation location, String directiveName) {
        return this.getDirectives().get(location).get(directiveName);
    }

    private static class FragmentDirectiveCollector
    extends QueryVisitorStub {
        private final List<Directive> inlineFragmentDirs = new ArrayList<Directive>();
        private final List<Directive> fragmentDirs = new ArrayList<Directive>();
        private final List<Directive> fragmentDefDirs = new ArrayList<Directive>();
        private final List<Field> fieldsToFind;
        private final Set<Node> relevantFragments;

        private FragmentDirectiveCollector(DataFetchingEnvironment env) {
            this.fieldsToFind = env.getMergedField().getFields();
            this.relevantFragments = new HashSet<Node>();
        }

        public static FragmentDirectiveCollector collect(DataFetchingEnvironment env, ExecutionStepInfo step) {
            FragmentDirectiveCollector fragmentDirectiveCollector = new FragmentDirectiveCollector(env);
            ExecutionStepInfo rootStep = step.getParent().getParent();
            if (rootStep == null) {
                return fragmentDirectiveCollector;
            }
            GraphQLType rootParentType = GraphQLUtils.unwrapNonNull((GraphQLType)rootStep.getType());
            while (!(rootParentType instanceof GraphQLObjectType)) {
                rootStep = rootStep.getParent();
                rootParentType = GraphQLUtils.unwrapNonNull((GraphQLType)rootStep.getType());
            }
            QueryTraverser traversal = QueryTraverser.newQueryTraverser().fragmentsByName(env.getFragmentsByName()).schema(env.getGraphQLSchema()).variables(env.getVariables()).root((Node)env.getExecutionStepInfo().getParent().getField().getSingleField()).rootParentType((GraphQLCompositeType)((GraphQLObjectType)rootParentType)).build();
            traversal.visitPostOrder((QueryVisitor)fragmentDirectiveCollector);
            return fragmentDirectiveCollector;
        }

        public void visitInlineFragment(QueryVisitorInlineFragmentEnvironment env) {
            boolean isRelevant;
            InlineFragment fragment = env.getInlineFragment();
            boolean containsField = this.fieldsToFind.stream().anyMatch(field -> fragment.getSelectionSet().getSelections().contains(field));
            boolean bl = isRelevant = containsField || this.relevantFragments.stream().anyMatch(frag -> fragment.getSelectionSet().getSelections().contains(frag));
            if (isRelevant) {
                this.relevantFragments.add((Node)fragment);
                this.inlineFragmentDirs.addAll(fragment.getDirectives());
            }
        }

        public void visitFragmentSpread(QueryVisitorFragmentSpreadEnvironment env) {
            boolean isRelevant;
            boolean containsField = this.fieldsToFind.stream().anyMatch(field -> env.getFragmentDefinition().getSelectionSet().getSelections().contains(field));
            boolean bl = isRelevant = containsField || this.relevantFragments.stream().anyMatch(frag -> env.getFragmentDefinition().getSelectionSet().getSelections().contains(frag));
            if (isRelevant) {
                this.relevantFragments.add((Node)env.getFragmentSpread());
                this.fragmentDirs.addAll(env.getFragmentSpread().getDirectives());
                this.fragmentDefDirs.addAll(env.getFragmentDefinition().getDirectives());
            }
        }

        List<Directive> getInlineFragmentDirs() {
            return this.inlineFragmentDirs;
        }

        List<Directive> getFragmentDirs() {
            return this.fragmentDirs;
        }

        List<Directive> getFragmentDefDirs() {
            return this.fragmentDefDirs;
        }
    }
}

