/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.generator.OperationSource;
import io.leangen.graphql.generator.OperationSourceRegistry;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilderParams;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OperationRegistry {
    private final Set<Operation> queries;
    private final Set<Operation> mutations;
    private final Set<Operation> subscriptions;
    private final OperationSourceRegistry operationSourceRegistry;
    private final OperationBuilder operationBuilder;
    private final InclusionStrategy inclusionStrategy;
    private final TypeTransformer typeTransformer;
    private final String[] basePackages;
    private final GlobalEnvironment environment;

    public OperationRegistry(OperationSourceRegistry operationSourceRegistry, OperationBuilder operationBuilder, InclusionStrategy inclusionStrategy, TypeTransformer typeTransformer, String[] basePackages, GlobalEnvironment environment) {
        this.operationSourceRegistry = operationSourceRegistry;
        this.operationBuilder = operationBuilder;
        this.inclusionStrategy = inclusionStrategy;
        this.typeTransformer = typeTransformer;
        this.basePackages = basePackages;
        this.environment = environment;
        List<Resolver> resolvers = this.buildQueryResolvers(operationSourceRegistry.getOperationSources());
        List<Resolver> mutationResolvers = this.buildMutationResolvers(operationSourceRegistry.getOperationSources());
        List<Resolver> subscriptionResolvers = this.buildSubscriptionResolvers(operationSourceRegistry.getOperationSources());
        this.queries = this.buildQueries(resolvers);
        this.mutations = this.buildMutations(mutationResolvers);
        this.subscriptions = this.buildSubscriptions(subscriptionResolvers);
    }

    private Set<Operation> buildQueries(List<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).values().stream().flatMap(r -> this.collectContextTypes((Collection<Resolver>)r).stream().map(contextType -> this.resolversPerContext((Type)contextType, (List<Resolver>)r)).filter(contextual -> !((List)contextual.getValue()).isEmpty()).map(contextual -> this.operationBuilder.buildQuery((Type)contextual.getKey(), (List)contextual.getValue(), this.environment))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<Operation> buildMutations(List<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).values().stream().flatMap(r -> this.collectContextTypes((Collection<Resolver>)r).stream().map(contextType -> this.resolversPerContext((Type)contextType, (List<Resolver>)r)).filter(contextual -> !((List)contextual.getValue()).isEmpty()).map(contextual -> this.operationBuilder.buildMutation((Type)contextual.getKey(), (List)contextual.getValue(), this.environment))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<Operation> buildSubscriptions(List<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).values().stream().flatMap(r -> this.collectContextTypes((Collection<Resolver>)r).stream().map(contextType -> this.resolversPerContext((Type)contextType, (List<Resolver>)r)).filter(contextual -> !((List)contextual.getValue()).isEmpty()).map(contextual -> this.operationBuilder.buildSubscription((Type)contextual.getKey(), (List)contextual.getValue(), this.environment))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map.Entry<Type, List<Resolver>> resolversPerContext(Type context, List<Resolver> resolvers) {
        List contextual = context == null ? resolvers.stream().filter(r -> r.getSourceTypes().isEmpty()).collect(Collectors.toList()) : resolvers.stream().filter(r -> r.getSourceTypes().contains(context)).collect(Collectors.toList());
        return new AbstractMap.SimpleEntry<Type, List<Resolver>>(context, contextual);
    }

    private List<Type> collectContextTypes(Collection<Resolver> resolvers) {
        List<Type> contextTypes = resolvers.stream().flatMap(r -> r.getSourceTypes().stream()).distinct().collect(Collectors.toList());
        contextTypes.add(null);
        return contextTypes;
    }

    private Collection<Operation> getAllQueries() {
        return this.queries;
    }

    Collection<Operation> getRootQueries() {
        return this.queries.stream().filter(Operation::isRoot).collect(Collectors.toList());
    }

    Collection<Operation> getMutations() {
        return this.mutations;
    }

    Collection<Operation> getSubscriptions() {
        return this.subscriptions;
    }

    private Set<Operation> getNestedQueries(AnnotatedType domainType) {
        OperationSource domainSource = this.operationSourceRegistry.nestedSourceForType(domainType);
        return this.buildNestedQueries(domainSource);
    }

    public Collection<Operation> getChildQueries(AnnotatedType domainType) {
        HashMap children = new HashMap();
        Map nestedQueries = this.getNestedQueries(domainType).stream().collect(Collectors.toMap(Operation::getName, Function.identity()));
        Map embeddableQueries = this.getEmbeddableQueries(domainType.getType()).stream().collect(Collectors.toMap(Operation::getName, Function.identity()));
        children.putAll(nestedQueries);
        children.putAll(embeddableQueries);
        return children.values();
    }

    private Set<Operation> getEmbeddableQueries(Type domainType) {
        return this.getAllQueries().stream().map(Operation::unbatch).filter(query -> query.isEmbeddableForType(domainType)).collect(Collectors.toSet());
    }

    private Set<Operation> buildNestedQueries(OperationSource operationSource) {
        return this.buildQueries(this.buildQueryResolvers(Collections.singleton(operationSource)));
    }

    private List<Resolver> buildQueryResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildQueryResolvers(new ResolverBuilderParams(operationSource.getServiceBeanSupplier(), operationSource.getJavaType(), operationSource.getExposedType(), this.inclusionStrategy, this.typeTransformer, this.basePackages, this.environment)));
    }

    private List<Resolver> buildMutationResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildMutationResolvers(new ResolverBuilderParams(operationSource.getServiceBeanSupplier(), operationSource.getJavaType(), operationSource.getExposedType(), this.inclusionStrategy, this.typeTransformer, this.basePackages, this.environment)));
    }

    private List<Resolver> buildSubscriptionResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildSubscriptionResolvers(new ResolverBuilderParams(operationSource.getServiceBeanSupplier(), operationSource.getJavaType(), operationSource.getExposedType(), this.inclusionStrategy, this.typeTransformer, this.basePackages, this.environment)));
    }

    private List<Resolver> buildResolvers(Collection<OperationSource> operationSources, BiFunction<OperationSource, ResolverBuilder, Collection<Resolver>> building) {
        return operationSources.stream().flatMap(operationSource -> operationSource.getResolverBuilders().stream().flatMap(builder -> ((Collection)building.apply((OperationSource)operationSource, (ResolverBuilder)builder)).stream()).distinct()).collect(Collectors.toList());
    }
}

