/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import java.util.Objects;
import java.util.function.Function;

public class DefaultValue {
    private final Object value;
    private final boolean set;
    public static final DefaultValue EMPTY = new DefaultValue(null, false);
    public static final DefaultValue NULL = new DefaultValue(null, true);

    private DefaultValue(Object value, boolean set) {
        this.value = value;
        this.set = set;
    }

    public DefaultValue(Object value) {
        this(value, true);
    }

    public static DefaultValue ofNullable(Object value) {
        return new DefaultValue(value, value != null);
    }

    public DefaultValue map(Function<Object, Object> mapper) {
        if (!this.isSet() || this.value == null) {
            return this;
        }
        return new DefaultValue(mapper.apply(this.value));
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultValue)) {
            return false;
        }
        DefaultValue that = (DefaultValue)o;
        return this.set == that.set && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.set);
    }
}

