/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import io.leangen.graphql.metadata.DefaultValue;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.util.Objects;
import java.util.stream.Collectors;

public class InputField {
    private final String name;
    private final String description;
    private final TypedElement typedElement;
    private final AnnotatedType deserializableType;
    private final DefaultValue defaultValue;

    public InputField(String name, String description, TypedElement element, AnnotatedType deserializableType, DefaultValue defaultValue) {
        this.name = Utils.requireNonEmpty(name);
        this.description = description;
        this.typedElement = Objects.requireNonNull(element);
        this.deserializableType = deserializableType != null ? deserializableType : element.getJavaType();
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AnnotatedType getJavaType() {
        return this.typedElement.getJavaType();
    }

    public AnnotatedType getDeserializableType() {
        return this.deserializableType;
    }

    public DefaultValue getDefaultValue() {
        return this.defaultValue;
    }

    public TypedElement getTypedElement() {
        return this.typedElement;
    }

    public String toString() {
        return String.format("Input field '%s' of type %s bound to [%s]", this.name, ClassUtils.toString(this.getJavaType()), this.typedElement.getElements().stream().map(ClassUtils::toString).collect(Collectors.joining()));
    }
}

