/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.ConfigurationException;
import io.leangen.graphql.ExecutableSchema;
import io.leangen.graphql.execution.complexity.ComplexityAnalysisInstrumentation;
import io.leangen.graphql.execution.complexity.JavaScriptEvaluator;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.util.ContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;

public class GraphQLRuntime {
    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public static Builder newGraphQL(ExecutableSchema graphQLSchema) {
        return new Builder(graphQLSchema.getSchema()).typeRegistry(graphQLSchema.getTypeRegistry()).batchLoaders(graphQLSchema.getBatchLoaders());
    }

    static class InputTransformer
    extends SimpleInstrumentation {
        private final Map<String, BatchLoaderWithContext<?, ?>> batchLoaders;
        private final Map<String, DataLoaderOptions> dataLoaderOptions;

        InputTransformer(Map<String, BatchLoaderWithContext<?, ?>> batchLoaders, Map<String, DataLoaderOptions> dataLoaderOptions) {
            this.batchLoaders = batchLoaders;
            this.dataLoaderOptions = dataLoaderOptions;
        }

        public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters, InstrumentationState state) {
            DataLoaderRegistry registry;
            ExecutionInput input = ContextUtils.wrapContext(executionInput);
            DataLoaderOptions defaultOptions = this.dataLoaderOptions.getOrDefault(null, DataLoaderOptions.newOptions().setBatchLoaderContextProvider(() -> ((ExecutionInput)input).getContext()));
            DataLoaderRegistry dataLoaderRegistry = registry = input.getDataLoaderRegistry() != DataLoaderDispatcherInstrumentationState.EMPTY_DATALOADER_REGISTRY ? input.getDataLoaderRegistry() : new DataLoaderRegistry();
            if (!this.batchLoaders.isEmpty()) {
                this.batchLoaders.forEach((loaderName, batchLoader) -> {
                    if (registry.getKeys().contains(loaderName)) {
                        throw new ConfigurationException("DataLoader name collision: " + loaderName + " is registered both manually and automatically.");
                    }
                    DataLoaderOptions options = this.dataLoaderOptions.getOrDefault(loaderName, defaultOptions);
                    DataLoader dataLoader = DataLoaderFactory.newDataLoader((BatchLoaderWithContext)batchLoader, (DataLoaderOptions)options);
                    registry.register(loaderName, dataLoader);
                });
            }
            return input.transform(in -> in.dataLoaderRegistry(registry));
        }
    }

    public static class Builder
    extends GraphQL.Builder {
        private final List<Instrumentation> instrumentations = new ArrayList<Instrumentation>();
        private final Map<String, BatchLoaderWithContext<?, ?>> batchLoaders = new HashMap();
        private final Map<String, DataLoaderOptions> dataLoaderOptions = new HashMap<String, DataLoaderOptions>();
        private TypeRegistry typeRegistry = new TypeRegistry(Collections.emptyMap());

        private Builder(GraphQLSchema graphQLSchema) {
            super(graphQLSchema);
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentations.add(instrumentation);
            return this;
        }

        public Builder maximumQueryComplexity(int limit) {
            this.instrumentations.add((Instrumentation)new ComplexityAnalysisInstrumentation(new JavaScriptEvaluator(), limit, this.typeRegistry));
            return this;
        }

        public Builder batchLoader(String loaderName, BatchLoaderWithContext<?, ?> loader) {
            this.batchLoaders.put(loaderName, loader);
            return this;
        }

        public Builder batchLoaders(Map<String, BatchLoaderWithContext<?, ?>> loaders) {
            this.batchLoaders.putAll(loaders);
            return this;
        }

        public Builder dataLoaderOptions(DataLoaderOptions options) {
            return this.dataLoaderOptions(null, options);
        }

        public Builder dataLoaderOptions(String loaderName, DataLoaderOptions options) {
            this.dataLoaderOptions.put(loaderName, options);
            return this;
        }

        public Builder typeRegistry(TypeRegistry typeRegistry) {
            this.typeRegistry = Objects.requireNonNull(typeRegistry);
            return this;
        }

        public GraphQL build() {
            ArrayList<InputTransformer> instrumentations = new ArrayList<InputTransformer>();
            instrumentations.add(new InputTransformer(this.batchLoaders, this.dataLoaderOptions));
            if (!this.batchLoaders.isEmpty() && this.instrumentations.stream().noneMatch(inst -> inst instanceof DataLoaderDispatcherInstrumentation)) {
                instrumentations.add((InputTransformer)new DataLoaderDispatcherInstrumentation());
            }
            instrumentations.addAll(this.instrumentations);
            if (instrumentations.size() == 1) {
                super.instrumentation((Instrumentation)instrumentations.get(0));
            } else {
                super.instrumentation((Instrumentation)new ChainedInstrumentation(instrumentations));
            }
            return super.build();
        }
    }
}

