/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.language.AstPrinter;
import graphql.language.Node;
import io.leangen.graphql.execution.complexity.ComplexityAnalyzer;
import io.leangen.graphql.execution.complexity.ComplexityFunction;
import io.leangen.graphql.execution.complexity.ResolvedField;
import io.leangen.graphql.generator.TypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexityAnalysisInstrumentation
extends SimpleInstrumentation {
    private final ComplexityFunction complexityFunction;
    private final int maximumComplexity;
    private final TypeRegistry typeRegistry;
    private static final Logger log = LoggerFactory.getLogger(ComplexityAnalysisInstrumentation.class);

    public ComplexityAnalysisInstrumentation(ComplexityFunction complexityFunction, int maximumComplexity, TypeRegistry typeRegistry) {
        this.complexityFunction = complexityFunction;
        this.maximumComplexity = maximumComplexity;
        this.typeRegistry = typeRegistry;
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        ResolvedField root = new ComplexityAnalyzer(this.complexityFunction, this.maximumComplexity, this.typeRegistry).collectFields(parameters.getExecutionContext());
        if (log.isDebugEnabled()) {
            log.debug("Operation {} has total complexity of {}", (Object)AstPrinter.printAst((Node)((Node)parameters.getExecutionContext().getOperationDefinition().getSelectionSet().getSelections().get(0))), (Object)root.getComplexityScore());
        }
        log.info("Total operation complexity: {}", (Object)root.getComplexityScore());
        return super.beginExecuteOperation(parameters);
    }
}

