/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import graphql.GraphQLContext;
import graphql.execution.CoercedVariables;
import graphql.execution.ConditionalNodes;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.TypeFromAST;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import io.leangen.graphql.execution.complexity.ComplexityFunction;
import io.leangen.graphql.execution.complexity.ComplexityLimitExceededException;
import io.leangen.graphql.execution.complexity.ResolvedField;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.util.GraphQLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ComplexityAnalyzer {
    private final ConditionalNodes conditionalNodes;
    private final ComplexityFunction complexityFunction;
    private final int maximumComplexity;
    private final TypeRegistry typeRegistry;

    ComplexityAnalyzer(ComplexityFunction complexityFunction, int maximumComplexity, TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
        this.conditionalNodes = new ConditionalNodes();
        this.complexityFunction = complexityFunction;
        this.maximumComplexity = maximumComplexity;
    }

    ResolvedField collectFields(ExecutionContext context) {
        FieldCollectorParameters parameters = FieldCollectorParameters.newParameters().schema(context.getGraphQLSchema()).objectType(context.getGraphQLSchema().getQueryType()).fragments(context.getFragmentsByName()).variables(context.getCoercedVariables().toMap()).build();
        List fields = context.getOperationDefinition().getSelectionSet().getSelections().stream().map(selection -> (Field)selection).collect(Collectors.toList());
        Map<String, ResolvedField> roots = fields.stream().map(field -> {
            FieldCoordinates fieldCoordinates;
            GraphQLFieldDefinition fieldDefinition;
            if (GraphQLUtils.isIntrospectionField(field)) {
                fieldDefinition = Introspection.SchemaMetaFieldDef;
                fieldCoordinates = FieldCoordinates.systemCoordinates((String)field.getName());
            } else {
                GraphQLObjectType rootType = this.getRootType(context.getGraphQLSchema(), context.getOperationDefinition());
                fieldDefinition = Objects.requireNonNull(rootType.getFieldDefinition(field.getName()));
                fieldCoordinates = FieldCoordinates.coordinates((GraphQLFieldsContainer)rootType, (GraphQLFieldDefinition)fieldDefinition);
            }
            Map argumentValues = ValuesResolver.getArgumentValues((List)fieldDefinition.getArguments(), (List)field.getArguments(), (CoercedVariables)context.getCoercedVariables(), (GraphQLContext)context.getGraphQLContext(), (Locale)context.getLocale());
            return this.collectFields(parameters, Collections.singletonList(new ResolvedField(fieldCoordinates, (Field)field, fieldDefinition, argumentValues, this.findResolver(fieldCoordinates, argumentValues))), context);
        }).collect(Collectors.toMap(ResolvedField::getName, Function.identity()));
        ResolvedField root = new ResolvedField(roots);
        if (root.getComplexityScore() > this.maximumComplexity) {
            throw new ComplexityLimitExceededException(root.getComplexityScore(), this.maximumComplexity);
        }
        return root;
    }

    private Map<String, ResolvedField> collectFields(FieldCollectorParameters parameters, List<Field> fields, GraphQLFieldsContainer parent, ExecutionContext ctx) {
        ArrayList visitedFragments = new ArrayList();
        LinkedHashMap<String, List<ResolvedField>> unconditionalSubFields = new LinkedHashMap<String, List<ResolvedField>>();
        LinkedHashMap<String, Map<String, List<ResolvedField>>> conditionalSubFields = new LinkedHashMap<String, Map<String, List<ResolvedField>>>();
        fields.stream().filter(field -> field.getSelectionSet() != null).forEach(field -> this.collectFields(parameters, unconditionalSubFields, this.getUnconditionalSelections(field.getSelectionSet(), parameters), visitedFragments, parent, ctx));
        fields.stream().filter(field -> field.getSelectionSet() != null).forEach(field -> this.getConditionalSelections(field.getSelectionSet(), parameters).forEach((condition, selections) -> {
            LinkedHashMap<String, List<ResolvedField>> subFields = new LinkedHashMap<String, List<ResolvedField>>();
            this.collectFields(parameters, (Map<String, List<ResolvedField>>)subFields, (List<Selection>)selections, visitedFragments, parent, ctx);
            conditionalSubFields.put((String)condition, (Map<String, List<ResolvedField>>)subFields);
        }));
        if (conditionalSubFields.isEmpty()) {
            return unconditionalSubFields.values().stream().map(nodes -> this.collectFields(parameters, (List<ResolvedField>)nodes, ctx)).collect(Collectors.toMap(ResolvedField::getName, Function.identity()));
        }
        return this.reduceAlternatives(parameters, ctx, unconditionalSubFields, conditionalSubFields);
    }

    private ResolvedField collectFields(FieldCollectorParameters parameters, List<ResolvedField> fields, ExecutionContext ctx) {
        int childScore;
        ResolvedField field = fields.get(0);
        if (!fields.stream().allMatch(f -> f.getFieldType() instanceof GraphQLFieldsContainer)) {
            field.setComplexityScore(this.complexityFunction.getComplexity(field, 0));
            return field;
        }
        List<Field> rawFields = fields.stream().map(ResolvedField::getField).collect(Collectors.toList());
        Map<String, ResolvedField> children = this.collectFields(parameters, rawFields, (GraphQLFieldsContainer)field.getFieldType(), ctx);
        Resolver resolver = this.findResolver(field.getCoordinates(), field.getArguments());
        ResolvedField node = new ResolvedField(field.getCoordinates(), field.getField(), field.getFieldDefinition(), field.getArguments(), children, resolver);
        int complexityScore = this.complexityFunction.getComplexity(node, childScore = children.values().stream().mapToInt(ResolvedField::getComplexityScore).sum());
        if (complexityScore > this.maximumComplexity) {
            throw new ComplexityLimitExceededException(complexityScore, this.maximumComplexity);
        }
        node.setComplexityScore(complexityScore);
        return node;
    }

    private void collectFields(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> fields, List<Selection> selectionSet, List<String> visitedFragments, GraphQLFieldsContainer parent, ExecutionContext ctx) {
        for (Selection selection : selectionSet) {
            if (selection instanceof Field) {
                this.collectField(parameters, fields, (Field)selection, parent, ctx);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectInlineFragment(parameters, ctx, fields, visitedFragments, (InlineFragment)selection, parent);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFragmentSpread(parameters, ctx, fields, visitedFragments, (FragmentSpread)selection, parent);
        }
    }

    private void collectFragmentSpread(FieldCollectorParameters parameters, ExecutionContext ctx, Map<String, List<ResolvedField>> fields, List<String> visitedFragments, FragmentSpread fragmentSpread, GraphQLFieldsContainer parent) {
        if (visitedFragments.contains(fragmentSpread.getName())) {
            return;
        }
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), fragmentSpread.getDirectives())) {
            return;
        }
        visitedFragments.add(fragmentSpread.getName());
        FragmentDefinition fragmentDefinition = this.definition((Selection)fragmentSpread, parameters);
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), fragmentDefinition.getDirectives())) {
            return;
        }
        if (fragmentDefinition.getTypeCondition() != null) {
            parent = (GraphQLFieldsContainer)TypeFromAST.getTypeFromAST((GraphQLSchema)parameters.getGraphQLSchema(), (Type)fragmentDefinition.getTypeCondition());
        }
        this.collectFields(parameters, fields, fragmentDefinition.getSelectionSet().getSelections(), visitedFragments, parent, ctx);
    }

    private void collectInlineFragment(FieldCollectorParameters parameters, ExecutionContext ctx, Map<String, List<ResolvedField>> fields, List<String> visitedFragments, InlineFragment inlineFragment, GraphQLFieldsContainer parent) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), inlineFragment.getDirectives())) {
            return;
        }
        if (inlineFragment.getTypeCondition() != null) {
            parent = (GraphQLFieldsContainer)TypeFromAST.getTypeFromAST((GraphQLSchema)parameters.getGraphQLSchema(), (Type)inlineFragment.getTypeCondition());
        }
        this.collectFields(parameters, fields, inlineFragment.getSelectionSet().getSelections(), visitedFragments, parent, ctx);
    }

    private void collectField(FieldCollectorParameters parameters, Map<String, List<ResolvedField>> fields, Field field, GraphQLFieldsContainer parent, ExecutionContext ctx) {
        if (!this.conditionalNodes.shouldInclude(parameters.getVariables(), field.getDirectives())) {
            return;
        }
        GraphQLFieldDefinition fieldDefinition = parent.getFieldDefinition(field.getName());
        FieldCoordinates fieldCoordinates = FieldCoordinates.coordinates((GraphQLFieldsContainer)parent, (GraphQLFieldDefinition)fieldDefinition);
        Map argumentValues = ValuesResolver.getArgumentValues((List)fieldDefinition.getArguments(), (List)field.getArguments(), (CoercedVariables)new CoercedVariables(parameters.getVariables()), (GraphQLContext)ctx.getGraphQLContext(), (Locale)ctx.getLocale());
        ResolvedField node = new ResolvedField(fieldCoordinates, field, fieldDefinition, argumentValues, this.findResolver(fieldCoordinates, argumentValues));
        fields.putIfAbsent(node.getName(), new ArrayList());
        fields.get(node.getName()).add(node);
    }

    protected Map<String, ResolvedField> reduceAlternatives(FieldCollectorParameters parameters, ExecutionContext ctx, Map<String, List<ResolvedField>> unconditionalSubFields, Map<String, Map<String, List<ResolvedField>>> conditionalSubFields) {
        Map reduced = null;
        for (Map.Entry<String, Map<String, List<ResolvedField>>> conditional : conditionalSubFields.entrySet()) {
            int maxScore;
            HashMap<String, List<ResolvedField>> merged = new HashMap<String, List<ResolvedField>>(conditional.getValue());
            for (Map.Entry<String, List<ResolvedField>> unconditional : unconditionalSubFields.entrySet()) {
                merged.merge(unconditional.getKey(), unconditional.getValue(), (condNodes, uncondNodes) -> Stream.concat(condNodes.stream(), uncondNodes.stream()).collect(Collectors.toList()));
            }
            Map flat = merged.values().stream().map(nodes -> this.collectFields(parameters, (List<ResolvedField>)nodes, ctx)).collect(Collectors.toMap(ResolvedField::getName, Function.identity()));
            if (reduced == null) {
                reduced = flat;
                continue;
            }
            int currentScore = flat.values().stream().mapToInt(ResolvedField::getComplexityScore).sum();
            if (currentScore <= (maxScore = reduced.values().stream().mapToInt(ResolvedField::getComplexityScore).sum())) continue;
            reduced = flat;
        }
        return reduced;
    }

    private List<Selection> getUnconditionalSelections(SelectionSet selectionSet, FieldCollectorParameters parameters) {
        return selectionSet.getSelections().stream().filter(selection -> !this.isConditional((Selection)selection, parameters)).collect(Collectors.toList());
    }

    private Map<String, List<Selection>> getConditionalSelections(SelectionSet selectionSet, FieldCollectorParameters parameters) {
        return selectionSet.getSelections().stream().filter(selection -> this.isConditional((Selection)selection, parameters)).collect(Collectors.groupingBy(s -> s instanceof FragmentSpread ? this.definition((Selection)s, parameters).getTypeCondition().getName() : ((InlineFragment)s).getTypeCondition().getName()));
    }

    private boolean isConditional(Selection selection, FieldCollectorParameters parameters) {
        return selection instanceof FragmentSpread && this.definition(selection, parameters).getTypeCondition() != null || selection instanceof InlineFragment && ((InlineFragment)selection).getTypeCondition() != null;
    }

    private GraphQLObjectType getRootType(GraphQLSchema schema, OperationDefinition operationDefinition) {
        if (operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            return Objects.requireNonNull(schema.getMutationType());
        }
        if (operationDefinition.getOperation() == OperationDefinition.Operation.QUERY) {
            return Objects.requireNonNull(schema.getQueryType());
        }
        if (operationDefinition.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
            return Objects.requireNonNull(schema.getSubscriptionType());
        }
        throw new IllegalStateException("Unknown operation type encountered. Incompatible graphql-java version?");
    }

    private FragmentDefinition definition(Selection fragmentSpread, FieldCollectorParameters parameters) {
        return (FragmentDefinition)parameters.getFragmentsByName().get(((FragmentSpread)fragmentSpread).getName());
    }

    private Resolver findResolver(FieldCoordinates coordinates, Map<String, Object> arguments) {
        Operation mappedOperation = this.typeRegistry.getMappedOperation(coordinates);
        return mappedOperation != null ? mappedOperation.getApplicableResolver(arguments.keySet()) : null;
    }
}

