/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.relay.generic;

import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import io.leangen.graphql.execution.relay.Connection;
import io.leangen.graphql.execution.relay.CursorProvider;
import io.leangen.graphql.execution.relay.Page;
import io.leangen.graphql.execution.relay.generic.GenericPage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class PageFactory {
    public static <N> Page<N> createOffsetBasedPage(List<N> nodes, long count, long offset) {
        return PageFactory.createOffsetBasedPage(nodes, offset, PageFactory.hasNextPage(nodes.size(), count, offset), PageFactory.hasPreviousPage(count, offset));
    }

    public static <N> Page<N> createOffsetBasedPage(List<N> nodes, long offset, boolean hasNextPage, boolean hasPreviousPage) {
        return PageFactory.createPage(nodes, PageFactory.offsetBasedCursorProvider(offset), hasNextPage, hasPreviousPage);
    }

    public static <N, P extends Page<N>> P createOffsetBasedPage(List<N> nodes, long count, long offset, BiFunction<List<Edge<N>>, PageInfo, P> pageCreator) {
        BiFunction<Object, ConnectionCursor, Edge> edgeCreator = DefaultEdge::new;
        return (P)((Page)PageFactory.createOffsetBasedConnection(nodes, count, offset, edgeCreator, pageCreator));
    }

    public static <N, E extends Edge<N>, C extends Connection<E>> C createOffsetBasedConnection(List<N> nodes, long count, long offset, BiFunction<N, ConnectionCursor, E> edgeCreator, BiFunction<List<E>, PageInfo, C> connectionCreator) {
        List<E> edges = PageFactory.createEdges(nodes, PageFactory.offsetBasedCursorProvider(offset), edgeCreator);
        return (C)((Connection)connectionCreator.apply(edges, PageFactory.createPageInfo(edges, PageFactory.hasNextPage(nodes.size(), count, offset), PageFactory.hasPreviousPage(count, offset))));
    }

    public static <N> Page<N> createPage(List<N> nodes, CursorProvider<N> cursorProvider, boolean hasNextPage, boolean hasPreviousPage) {
        List<Edge<N>> edges = PageFactory.createEdges(nodes, cursorProvider);
        return new GenericPage<N>(edges, PageFactory.createPageInfo(edges, hasNextPage, hasPreviousPage));
    }

    public static <N> List<Edge<N>> createEdges(List<N> nodes, CursorProvider<N> cursorProvider) {
        BiFunction<Object, ConnectionCursor, Edge> edgeCreator = DefaultEdge::new;
        return PageFactory.createEdges(nodes, cursorProvider, edgeCreator);
    }

    public static <N, E extends Edge<N>> List<E> createEdges(List<N> nodes, CursorProvider<N> cursorProvider, BiFunction<N, ConnectionCursor, E> edgeCreator) {
        ArrayList<Edge> edges = new ArrayList<Edge>(nodes.size());
        int index = 0;
        for (N node : nodes) {
            edges.add((Edge)edgeCreator.apply(node, cursorProvider.createCursor(node, index++)));
        }
        return edges;
    }

    public static <N, E extends Edge<N>> PageInfo createOffsetBasedPageInfo(List<E> edges, long count, long offset) {
        return PageFactory.createPageInfo(edges, PageFactory.hasNextPage(edges.size(), count, offset), PageFactory.hasPreviousPage(count, offset));
    }

    public static <N, E extends Edge<N>> PageInfo createPageInfo(List<E> edges, boolean hasNextPage, boolean hasPreviousPage) {
        ConnectionCursor firstCursor = null;
        ConnectionCursor lastCursor = null;
        if (!edges.isEmpty()) {
            firstCursor = ((Edge)edges.get(0)).getCursor();
            lastCursor = ((Edge)edges.get(edges.size() - 1)).getCursor();
        }
        return new DefaultPageInfo(firstCursor, lastCursor, hasPreviousPage, hasNextPage);
    }

    public static <N> CursorProvider<N> offsetBasedCursorProvider(long offset) {
        return (node, index) -> new DefaultConnectionCursor(Long.toString(offset + (long)index + 1L));
    }

    public static boolean hasNextPage(long nodes, long count, long offset) {
        return offset + nodes < count;
    }

    public static boolean hasPreviousPage(long count, long offset) {
        return offset > 0L && count > 0L;
    }
}

