/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLSubscription;
import io.leangen.graphql.metadata.strategy.query.OperationInfoGenerator;
import io.leangen.graphql.metadata.strategy.query.OperationInfoGeneratorParams;
import java.util.Optional;
import java.util.function.Function;

public class AnnotatedOperationInfoGenerator
implements OperationInfoGenerator {
    @Override
    public String name(OperationInfoGeneratorParams params) {
        return this.map(params, GraphQLQuery::name, GraphQLMutation::name, GraphQLSubscription::name);
    }

    @Override
    public String description(OperationInfoGeneratorParams params) {
        return this.map(params, GraphQLQuery::description, GraphQLMutation::description, GraphQLSubscription::description);
    }

    @Override
    public String deprecationReason(OperationInfoGeneratorParams params) {
        return this.map(params, GraphQLQuery::deprecationReason, GraphQLMutation::deprecationReason, GraphQLSubscription::deprecationReason);
    }

    private String map(OperationInfoGeneratorParams params, Function<GraphQLQuery, String> queryMapper, Function<GraphQLMutation, String> mutationMapper, Function<GraphQLSubscription, String> subscriptionMapper) {
        switch (params.getOperationType()) {
            case QUERY: {
                return Optional.ofNullable(params.getElement().getAnnotation(GraphQLQuery.class)).map(queryMapper).orElse(null);
            }
            case MUTATION: {
                return Optional.ofNullable(params.getElement().getAnnotation(GraphQLMutation.class)).map(mutationMapper).orElse(null);
            }
            case SUBSCRIPTION: {
                return Optional.ofNullable(params.getElement().getAnnotation(GraphQLSubscription.class)).map(subscriptionMapper).orElse(null);
            }
        }
        return null;
    }
}

