/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.GraphQLInputField;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.metadata.DefaultValue;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.TypeDiscriminatorField;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.InputFieldInclusionParams;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilderParams;
import io.leangen.graphql.metadata.strategy.value.InputFieldInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.InputParsingException;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.jackson.TypeUtils;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Scalars;
import io.leangen.graphql.util.Utils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonValueMapper
implements ValueMapper,
InputFieldBuilder {
    private final ObjectMapper objectMapper;
    private final InputFieldInfoGenerator inputInfoGen = new InputFieldInfoGenerator();
    private boolean mapDeserializableType = false;
    private static final Logger log = LoggerFactory.getLogger(JacksonValueMapper.class);

    JacksonValueMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T fromInput(Object graphQLInput, Type sourceType, AnnotatedType outputType) {
        try {
            return (T)this.objectMapper.convertValue(graphQLInput, this.objectMapper.getTypeFactory().constructType(outputType.getType()));
        }
        catch (IllegalArgumentException e) {
            throw new InputParsingException(graphQLInput, outputType.getType(), e);
        }
    }

    @Override
    public <T> T fromString(String json, AnnotatedType type) {
        if (json == null || String.class.equals((Object)type.getType())) {
            return (T)json;
        }
        try {
            if (Scalars.isScalar(type.getType()) && !ClassUtils.isPrimitive(type)) {
                return (T)Scalars.toGraphQLScalarType(type.getType()).getCoercing().parseValue((Object)json);
            }
            return (T)this.objectMapper.readValue(json, this.objectMapper.getTypeFactory().constructType(type.getType()));
        }
        catch (IOException e) {
            throw new InputParsingException(json, type.getType(), e);
        }
    }

    @Override
    public String toString(Object output, AnnotatedType type) {
        if (output != null && Scalars.isScalar(type.getType())) {
            output = Scalars.toGraphQLScalarType(type.getType()).getCoercing().serialize(output);
        }
        if (output == null || output instanceof String) {
            return (String)output;
        }
        try {
            return this.objectMapper.writeValueAsString(output);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Override
    public Set<InputField> getInputFields(InputFieldBuilderParams params) {
        BeanDescription delegateDesc;
        BeanDescription originalDesc;
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(params.getType().getType());
        BeanDescription desc = originalDesc = this.objectMapper.getDeserializationConfig().introspect(javaType);
        JavaType refined = this.objectMapper.getTypeFactory().constructType(this.resolveDeserializableType((Annotated)desc.getClassInfo(), params.getType(), javaType, this.objectMapper).getType());
        if (this.mapDeserializableType) {
            desc = this.objectMapper.getDeserializationConfig().introspect(refined);
        }
        AnnotatedType type = (delegateDesc = this.findDelegate(desc)) == originalDesc ? params.getType() : TypeUtils.toJavaType(delegateDesc.getType());
        return delegateDesc.findProperties().stream().filter(prop -> this.isIncluded(type, (BeanPropertyDefinition)prop, this.isPropertyDeserializableInSubType((BeanPropertyDefinition)prop, TypeUtils.toJavaType(refined), params.getConcreteSubTypes()), params.getEnvironment().inclusionStrategy)).map(prop -> this.toInputField(type, (BeanPropertyDefinition)prop, params.getEnvironment())).collect(Collectors.toSet());
    }

    private InputField toInputField(AnnotatedType type, BeanPropertyDefinition prop, GlobalEnvironment environment) {
        ElementFactory elementFactory = new ElementFactory(type, environment.typeTransformer);
        return this.toInputField(elementFactory.fromProperty(prop), prop, this.objectMapper, environment);
    }

    private InputField toInputField(TypedElement element, BeanPropertyDefinition prop, ObjectMapper objectMapper, GlobalEnvironment environment) {
        AnnotatedType deserializableType = this.resolveDeserializableType((Annotated)prop.getPrimaryMember(), element.getJavaType(), prop.getPrimaryType(), objectMapper);
        DefaultValue defaultValue = this.inputInfoGen.defaultValue(element.getElements(), element.getJavaType(), environment);
        return new InputField(prop.getName(), prop.getMetadata().getDescription(), element, deserializableType, defaultValue);
    }

    @Override
    public TypeDiscriminatorField getTypeDiscriminatorField(InputFieldBuilderParams params) {
        JavaType javaType = this.objectMapper.constructType(params.getType().getType());
        DeserializationConfig deserializationConfig = this.objectMapper.getDeserializationConfig();
        AnnotatedClass clazz = AnnotatedClassResolver.resolve((MapperConfig)deserializationConfig, (JavaType)javaType, (ClassIntrospector.MixInResolver)deserializationConfig);
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder typeResolver = annotationIntrospector.findTypeResolver((MapperConfig)deserializationConfig, clazz, javaType);
        String discriminatorFieldName = typeResolver instanceof StdTypeResolverBuilder ? ((StdTypeResolverBuilder)typeResolver).getTypeProperty() : "_type_";
        String[] explicitSubTypes = (String[])Utils.stream(this.objectMapper.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)deserializationConfig, clazz)).map(NamedType::getName).filter(Utils::isNotEmpty).toArray(String[]::new);
        if (Utils.isNotEmpty(explicitSubTypes)) {
            return new TypeDiscriminatorField(discriminatorFieldName, "Input type discriminator", explicitSubTypes);
        }
        String[] discoveredSubTypes = (String[])params.getConcreteSubTypes().stream().map(GenericTypeReflector::annotate).map(impl -> params.getEnvironment().typeInfoGenerator.generateTypeName((AnnotatedType)impl, params.getEnvironment().messageBundle)).toArray(String[]::new);
        if (discoveredSubTypes.length > 1) {
            return new TypeDiscriminatorField(discriminatorFieldName, "Input type discriminator", discoveredSubTypes);
        }
        return null;
    }

    private AnnotatedType resolveDeserializableType(Annotated accessor, AnnotatedType realType, JavaType baseType, ObjectMapper objectMapper) {
        AnnotationIntrospector introspector = objectMapper.getDeserializationConfig().getAnnotationIntrospector();
        try {
            JavaType mapped = objectMapper.getDeserializationContext().getFactory().mapAbstractType(objectMapper.getDeserializationConfig(), baseType);
            JavaType refined = introspector.refineDeserializationType((MapperConfig)objectMapper.getDeserializationConfig(), accessor, mapped);
            Class raw = ClassUtils.getRawType(realType.getType());
            if (!refined.getRawClass().equals(raw)) {
                AnnotatedType candidate;
                if (ClassUtils.isSuperClass(realType, refined.getRawClass()) && !ClassUtils.isMissingTypeParameters((candidate = GenericTypeReflector.getExactSubType((AnnotatedType)realType, (Class)refined.getRawClass())).getType())) {
                    return candidate;
                }
                return GenericTypeReflector.updateAnnotations((AnnotatedType)TypeUtils.toJavaType(refined), (Annotation[])realType.getAnnotations());
            }
        }
        catch (JsonMappingException mapped) {
        }
        catch (Exception e) {
            log.warn("Failed to determine the deserializable type for " + GenericTypeReflector.getTypeName((Type)realType.getType()) + " due to an exception", (Throwable)e);
        }
        return realType;
    }

    private boolean isIncluded(AnnotatedType declaringType, BeanPropertyDefinition prop, boolean deserializableInSubType, InclusionStrategy inclusionStrategy) {
        List<AnnotatedElement> elements = Utils.flatten(Optional.ofNullable(prop.getConstructorParameter()).map(ElementFactory::getParameter), Optional.ofNullable(prop.getSetter()).map(Annotated::getAnnotated), Optional.ofNullable(prop.getGetter()).map(Annotated::getAnnotated), Optional.ofNullable(prop.getField()).map(Annotated::getAnnotated)).collect(Collectors.toList());
        InputFieldInclusionParams params = InputFieldInclusionParams.builder().withType(declaringType).withElementDeclaringClass(prop.getPrimaryMember().getDeclaringClass()).withElements(elements).withDeserializationInfo(prop.couldDeserialize(), deserializableInSubType).build();
        return inclusionStrategy.includeInputField(params);
    }

    private BeanDescription findDelegate(BeanDescription beanDesc) {
        JsonCreator.Mode creatorMode;
        AnnotationIntrospector introspector = this.objectMapper.getDeserializationConfig().getAnnotationIntrospector();
        for (AnnotatedMethod ctor : beanDesc.getFactoryMethods()) {
            creatorMode = introspector.findCreatorAnnotation((MapperConfig)this.objectMapper.getDeserializationConfig(), (Annotated)ctor);
            if (creatorMode != JsonCreator.Mode.DELEGATING) continue;
            return this.objectMapper.getDeserializationConfig().introspect(ctor.getParameterType(0));
        }
        for (AnnotatedMethod ctor : beanDesc.getConstructors()) {
            creatorMode = introspector.findCreatorAnnotation((MapperConfig)this.objectMapper.getDeserializationConfig(), (Annotated)ctor);
            if (creatorMode != JsonCreator.Mode.DELEGATING) continue;
            return this.objectMapper.getDeserializationConfig().introspect(ctor.getParameterType(0));
        }
        return beanDesc;
    }

    private boolean isPropertyDeserializableInSubType(BeanPropertyDefinition prop, AnnotatedType deserializableType, List<Class<?>> concreteSubTypes) {
        return this.isPropertyDeserializable(prop, ClassUtils.getRawType(deserializableType.getType())) || concreteSubTypes.stream().anyMatch(impl -> this.isPropertyDeserializable(prop, (Class<?>)impl));
    }

    private boolean isPropertyDeserializable(BeanPropertyDefinition prop, Class<?> type) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
        BeanDescription desc = this.objectMapper.getDeserializationConfig().introspect(javaType);
        return desc.findProperties().stream().anyMatch(p -> p.getName().equals(prop.getName()) && p.couldDeserialize());
    }

    public JacksonValueMapper withDeserializableTypeAsPrimary() {
        this.mapDeserializableType = true;
        return this;
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return true;
    }

    private static class ElementFactory {
        private final AnnotatedType type;
        private final TypeTransformer transformer;

        ElementFactory(AnnotatedType type, TypeTransformer typeTransformer) {
            this.type = type;
            this.transformer = typeTransformer;
        }

        TypedElement fromConstructorParameter(AnnotatedParameter ctorParam) {
            Executable constructor = (Executable)ctorParam.getOwner().getMember();
            Parameter parameter = constructor.getParameters()[ctorParam.getIndex()];
            AnnotatedType fieldType = this.transform(ClassUtils.getParameterTypes(constructor, this.type)[ctorParam.getIndex()], parameter);
            return new TypedElement(fieldType, parameter);
        }

        TypedElement fromSetter(AnnotatedMethod setterMethod) {
            Method setter = setterMethod.getAnnotated();
            AnnotatedType fieldType = this.transform(ClassUtils.getParameterTypes(setter, this.type)[0], setter, this.type);
            return new TypedElement(fieldType, setter);
        }

        TypedElement fromGetter(AnnotatedMethod getterMethod) {
            Method getter = getterMethod.getAnnotated();
            AnnotatedType fieldType = this.transform(ClassUtils.getReturnType(getter, this.type), getter, this.type);
            return new TypedElement(fieldType, getter);
        }

        TypedElement fromField(AnnotatedField fld) {
            Field field = fld.getAnnotated();
            AnnotatedType fieldType = this.transform(ClassUtils.getFieldType(field, this.type), field, this.type);
            return new TypedElement(fieldType, field);
        }

        TypedElement fromProperty(BeanPropertyDefinition prop) {
            Optional<TypedElement> constParam = Optional.ofNullable(prop.getConstructorParameter()).map(this::fromConstructorParameter);
            Optional<TypedElement> setter = Optional.ofNullable(prop.getSetter()).map(this::fromSetter);
            Optional<TypedElement> getter = Optional.ofNullable(prop.getGetter()).map(this::fromGetter);
            Optional<TypedElement> field = Optional.ofNullable(prop.getField()).map(this::fromField);
            Optional mutator = Utils.flatten(constParam, setter, field).findFirst();
            Optional<TypedElement> explicit = Utils.flatten(constParam, setter, getter, field).filter(e -> e.isAnnotationPresent(GraphQLInputField.class)).findFirst();
            List<TypedElement> elements = Utils.flatten(explicit, mutator, field).collect(Collectors.toList());
            if (elements.isEmpty()) {
                elements = getter.map(Collections::singletonList).orElse(Collections.emptyList());
            }
            return new TypedElement(elements);
        }

        AnnotatedType transform(AnnotatedType type, Member member, AnnotatedType declaringType) {
            try {
                return this.transformer.transform(type);
            }
            catch (TypeMappingException e) {
                throw TypeMappingException.ambiguousMemberType(member, declaringType, e);
            }
        }

        AnnotatedType transform(AnnotatedType type, Parameter parameter) {
            try {
                return this.transformer.transform(type);
            }
            catch (TypeMappingException e) {
                throw TypeMappingException.ambiguousParameterType(parameter.getDeclaringExecutable(), parameter, e);
            }
        }

        static Parameter getParameter(AnnotatedParameter ctorParam) {
            Executable constructor = (Executable)ctorParam.getOwner().getMember();
            return constructor.getParameters()[ctorParam.getIndex()];
        }
    }
}

