/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.annotations.GraphQLUnion;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.value.Property;
import io.leangen.graphql.util.ClassFinder;
import io.leangen.graphql.util.Utils;
import java.beans.Introspector;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassUtils {
    private static final Class<?> javassistProxyClass;
    private static final List<String> KNOWN_PROXY_CLASS_SEPARATORS;
    private static final List<Class<?>> ROOT_TYPES;
    private static final Map<Class<?>, Object> DEFAULT_PRIMITIVE_VALUES;

    public static Set<Method> getAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        ClassUtils.collectPublicAbstractMethods(type, methods);
        Collections.addAll(methods, type.getMethods());
        return methods.stream().filter(element -> element.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    public static Set<Field> getAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        return Arrays.stream(type.getFields()).filter(element -> element.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    public static Set<Property> getProperties(Class<?> type) {
        return Arrays.stream(type.getMethods()).filter(ClassUtils::isGetter).map(getter -> ClassUtils.findFieldByGetter(getter).map(field -> new Property((Field)field, (Method)getter)).filter(prop -> prop.getField().getType().equals(prop.getGetter().getReturnType())).filter(prop -> !Modifier.isPublic(prop.getField().getModifiers())).filter(prop -> !Modifier.isAbstract(prop.getGetter().getModifiers()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static void collectPublicAbstractMethods(Class<?> type, Set<Method> methods) {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        if (ClassUtils.isAbstract(type)) {
            Arrays.stream(type.getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> Modifier.isAbstract(method.getModifiers())).forEach(methods::add);
        }
        ClassUtils.collectPublicAbstractMethods(type.getSuperclass(), methods);
    }

    public static AnnotatedType getReturnType(Method method, AnnotatedType declaringType) {
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType((AnnotatedType)GenericTypeReflector.capture((AnnotatedType)declaringType), method.getDeclaringClass());
        if (ClassUtils.isMissingTypeParameters(exactDeclaringType.getType())) {
            return method.getAnnotatedReturnType();
        }
        return GenericTypeReflector.getReturnType((Method)method, (AnnotatedType)declaringType);
    }

    public static AnnotatedType getFieldType(Field field, AnnotatedType declaringType) {
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType((AnnotatedType)GenericTypeReflector.capture((AnnotatedType)declaringType), field.getDeclaringClass());
        if (ClassUtils.isMissingTypeParameters(exactDeclaringType.getType())) {
            return field.getAnnotatedType();
        }
        return GenericTypeReflector.getFieldType((Field)field, (AnnotatedType)declaringType);
    }

    public static Field getEnumConstantField(Enum<?> constant) {
        try {
            return constant.getClass().getField(constant.name());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static AnnotatedType[] getParameterTypes(Executable executable, AnnotatedType declaringType) {
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType((AnnotatedType)GenericTypeReflector.capture((AnnotatedType)declaringType), executable.getDeclaringClass());
        if (ClassUtils.isMissingTypeParameters(exactDeclaringType.getType())) {
            return executable.getAnnotatedParameterTypes();
        }
        return GenericTypeReflector.getParameterTypes((Executable)executable, (AnnotatedType)declaringType);
    }

    public static <T> Class<T> getRawType(Type type) {
        Class erased = GenericTypeReflector.erase((Type)type);
        if (erased == Object.class && type != Object.class) {
            throw new TypeMappingException("Type of " + type.getTypeName() + " is lost to erasure. Consider explicitly providing the type to GraphQLSchemaGenerator#withOperationsFrom... methods, or customizing the mapping process.");
        }
        return erased;
    }

    public static boolean isMissingTypeParameters(Type type) {
        return GenericTypeReflector.isMissingTypeParameters((Type)type);
    }

    public static <T extends AnnotatedType> T normalize(T type) {
        if (Arrays.stream((type = GenericTypeReflector.toCanonicalBoxed(type)).getAnnotations()).anyMatch(ann -> ann.annotationType().equals(GraphQLUnion.class))) {
            type = ClassUtils.removeAnnotations(type, Collections.singleton(GraphQLUnion.class));
        }
        return (T)type;
    }

    public static <T> T instance(AnnotatedType type) {
        return ClassUtils.instance(ClassUtils.getRawType(type.getType()));
    }

    public static <T> T instance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T instanceWithOptionalInjection(Class<T> clazz, Object ... arguments) {
        Class[] parameterTypes = (Class[])Arrays.stream(arguments).map(Object::getClass).toArray(Class[]::new);
        return ClassUtils.instanceWithOptionalInjection(clazz, parameterTypes, arguments);
    }

    public static <T> T instanceWithOptionalInjection(Class<T> clazz, Class<?> parameterType, Object argument) {
        return ClassUtils.instanceWithOptionalInjection(clazz, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> T instanceWithOptionalInjection(Class<T> clazz, Class<?>[] parameterTypes, Object[] arguments) {
        try {
            try {
                return clazz.getDeclaredConstructor(parameterTypes).newInstance(arguments);
            }
            catch (NoSuchMethodException e) {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            String argumentTypes = Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(","));
            throw new IllegalArgumentException(clazz.getName() + " must expose a public default constructor, or a constructor accepting " + argumentTypes, e);
        }
    }

    public static boolean isGetter(Method getter) {
        return ClassUtils.isReal(getter) && getter.getParameterCount() == 0 && getter.getReturnType() != Void.TYPE && getter.getReturnType() != Void.class && getter.getName().startsWith("get") || (getter.getReturnType() == Boolean.class || getter.getReturnType() == Boolean.TYPE) && getter.getName().startsWith("is");
    }

    public static boolean isSetter(Method setter) {
        return ClassUtils.isReal(setter) && setter.getName().startsWith("set") && setter.getParameterCount() == 1;
    }

    public static boolean isReal(Method method) {
        return !method.isBridge() && !method.isSynthetic();
    }

    public static boolean isReal(Field field) {
        return !field.isSynthetic();
    }

    public static boolean isReal(Parameter parameter) {
        return !parameter.isImplicit() && !parameter.isSynthetic();
    }

    public static boolean isReal(Member member) {
        Objects.requireNonNull(member, "Member must not be null");
        if (member instanceof Method) {
            return ClassUtils.isReal((Method)member);
        }
        if (member instanceof Field) {
            return ClassUtils.isReal((Field)member);
        }
        return member.isSynthetic();
    }

    public static boolean isReal(AnnotatedElement element) {
        Objects.requireNonNull(element, "Element must not be null");
        if (element instanceof Member) {
            return ClassUtils.isReal((Member)((Object)element));
        }
        if (element instanceof Parameter) {
            return ClassUtils.isReal((Parameter)element);
        }
        throw new IllegalArgumentException("Can not determine if an element of type " + element.getClass().getName() + " is real");
    }

    public static String getFieldNameFromGetter(Method getter) {
        String name = getter.getName();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            name = getter.getName().replaceAll("^get", "");
        } else if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
            name = getter.getName().replaceAll("^is", "");
        }
        return Introspector.decapitalize(name);
    }

    public static String getFieldNameFromSetter(Method setter) {
        return Introspector.decapitalize(setter.getName().replaceAll("^set", ""));
    }

    public static <T extends Member & AnnotatedElement> List<AnnotatedElement> getPropertyMembers(T member) {
        ArrayList<AnnotatedElement> propertyElements = new ArrayList<AnnotatedElement>(3);
        if (member instanceof Field) {
            ClassUtils.findSetter(member.getDeclaringClass(), member.getName(), ((Field)member).getType()).ifPresent(propertyElements::add);
            ClassUtils.findGetter(member.getDeclaringClass(), member.getName()).ifPresent(propertyElements::add);
            propertyElements.add(member);
        }
        if (member instanceof Method && ClassUtils.isGetter((Method)member)) {
            Method getter = (Method)member;
            ClassUtils.findSetter(getter.getDeclaringClass(), ClassUtils.getFieldNameFromGetter(getter), getter.getReturnType()).ifPresent(propertyElements::add);
            propertyElements.add(getter);
            ClassUtils.findFieldByGetter(getter).ifPresent(propertyElements::add);
        }
        if (member instanceof Method && ClassUtils.isSetter((Method)member)) {
            Method setter = (Method)member;
            propertyElements.add(setter);
            ClassUtils.findGetter(setter.getDeclaringClass(), ClassUtils.getFieldNameFromSetter(setter)).ifPresent(propertyElements::add);
            ClassUtils.findFieldBySetter(setter).ifPresent(propertyElements::add);
        }
        return propertyElements;
    }

    public static Optional<Method> findGetter(Class<?> type, String fieldName) {
        return Utils.or(ClassUtils.findMethod(type, "get" + Utils.capitalize(fieldName), new Class[0]), ClassUtils.findMethod(type, "is" + Utils.capitalize(fieldName), new Class[0]));
    }

    public static Optional<Method> findSetter(Class<?> type, String fieldName, Class<?> fieldType) {
        return ClassUtils.findMethod(type, "set" + Utils.capitalize(fieldName), fieldType);
    }

    public static Optional<Field> findFieldByGetter(Method getter) {
        return ClassUtils.findField(getter.getDeclaringClass(), ClassUtils.getFieldNameFromGetter(getter));
    }

    public static Optional<Field> findFieldBySetter(Method setter) {
        return ClassUtils.findField(setter.getDeclaringClass(), ClassUtils.getFieldNameFromSetter(setter));
    }

    public static Optional<Field> findField(Class<?> type, String fieldName) {
        return ClassUtils.findField(type, (Field field) -> field.getName().equals(fieldName));
    }

    public static Optional<Field> findField(Class<?> type, Predicate<Field> condition) {
        if (type.isInterface()) {
            return Optional.empty();
        }
        while (!type.equals(Object.class)) {
            Optional<Field> match = Arrays.stream(type.getDeclaredFields()).filter(condition).findFirst();
            if (match.isPresent()) {
                return match;
            }
            type = type.getSuperclass();
        }
        return Optional.empty();
    }

    public static Optional<Method> findMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return Optional.of(type.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public static <T> T getFieldValue(Object source, String fieldName) {
        try {
            Optional<Method> getter = ClassUtils.findGetter(source.getClass(), fieldName);
            if (getter.isPresent()) {
                return (T)getter.get().invoke(source, new Object[0]);
            }
            return (T)source.getClass().getField(fieldName).get(source);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to extract the value of field " + fieldName + " from the given instance of " + source.getClass(), e);
        }
    }

    @Deprecated
    public static List<AnnotatedType> findImplementations(AnnotatedType superType, String ... packages) {
        return new ClassFinder().findImplementations(superType, info -> true, false, packages);
    }

    public static boolean isAbstract(AnnotatedType type) {
        return ClassUtils.isAbstract(ClassUtils.getRawType(type.getType()));
    }

    public static boolean isAbstract(Class<?> type) {
        return (type.isInterface() || Modifier.isAbstract(type.getModifiers())) && !type.isPrimitive() && !type.isArray() && !type.isEnum();
    }

    public static boolean isAssignable(Type superType, Type subType) {
        return (superType instanceof ParameterizedType && Arrays.stream(((ParameterizedType)superType).getActualTypeArguments()).allMatch(arg -> arg instanceof TypeVariable) || superType instanceof GenericArrayType && ((GenericArrayType)superType).getGenericComponentType() instanceof TypeVariable) && ClassUtils.getRawType(superType).isAssignableFrom(ClassUtils.getRawType(subType)) || GenericTypeReflector.box((Type)subType) == superType || GenericTypeReflector.isSuperType((Type)superType, (Type)subType);
    }

    public static boolean isSuperClass(Class<?> superClass, AnnotatedType subType) {
        return superClass.isAssignableFrom(GenericTypeReflector.erase((Type)subType.getType()));
    }

    public static boolean isSuperClass(AnnotatedType superType, Class<?> subClass) {
        return GenericTypeReflector.erase((Type)superType.getType()).isAssignableFrom(subClass);
    }

    public static boolean isSubPackage(Package pkg, String prefix) {
        String packageName = pkg != null ? pkg.getName() : "";
        return packageName.startsWith(prefix);
    }

    public static String toString(AnnotatedType type) {
        return GenericTypeReflector.toCanonical((AnnotatedType)type).toString();
    }

    public static String toString(AnnotatedElement element) {
        if (element instanceof Parameter) {
            return ((Parameter)element).getDeclaringExecutable() + "#" + ((Parameter)element).getName();
        }
        if (element instanceof AnnotatedType) {
            return ClassUtils.toString((AnnotatedType)element);
        }
        return element.toString();
    }

    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotation) {
        return element.isAnnotationPresent(annotation) || Arrays.stream(element.getAnnotations()).anyMatch(ann -> ann.annotationType().isAnnotationPresent(annotation));
    }

    public static boolean hasMetaAnnotation(AnnotatedElement element, Class<? extends Annotation> annotation) {
        return ClassUtils.hasMetaAnnotation(element, annotation, new HashSet<AnnotatedElement>());
    }

    private static boolean hasMetaAnnotation(AnnotatedElement element, Class<? extends Annotation> annotation, Set<AnnotatedElement> seen) {
        if (seen.contains(element)) {
            return false;
        }
        seen.add(element);
        return element.isAnnotationPresent(annotation) || Arrays.stream(element.getAnnotations()).anyMatch(ann -> ClassUtils.hasMetaAnnotation(ann.annotationType(), annotation, seen));
    }

    public static <T extends Annotation> Optional<T> findApplicableAnnotation(AnnotatedElement element, Class<T> annotation) {
        if (element.isAnnotationPresent(annotation)) {
            return Optional.of(element.getAnnotation(annotation));
        }
        if (element instanceof Member) {
            Class<?> declaringClass = ((Member)((Object)element)).getDeclaringClass();
            if (declaringClass.isAnnotationPresent(annotation)) {
                return Optional.of(declaringClass.getAnnotation(annotation));
            }
            if (declaringClass.getPackage() != null && declaringClass.getPackage().isAnnotationPresent(annotation)) {
                return Optional.of(declaringClass.getPackage().getAnnotation(annotation));
            }
        }
        return Optional.empty();
    }

    public static List<Method> getAnnotationFields(Class<? extends Annotation> annotation) {
        return Arrays.stream(annotation.getMethods()).filter(method -> annotation.equals(method.getDeclaringClass())).collect(Collectors.toList());
    }

    public static boolean containsTypeAnnotation(AnnotatedType type, Class<? extends Annotation> annotation) {
        if (type.isAnnotationPresent(annotation)) {
            return true;
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            return Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).anyMatch(param -> ClassUtils.containsTypeAnnotation(param, annotation));
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable variable = (AnnotatedTypeVariable)type;
            return Arrays.stream(variable.getAnnotatedBounds()).anyMatch(bound -> ClassUtils.containsTypeAnnotation(bound, annotation));
        }
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType wildcard = (AnnotatedWildcardType)type;
            return Stream.concat(Arrays.stream(wildcard.getAnnotatedLowerBounds()), Arrays.stream(wildcard.getAnnotatedUpperBounds())).anyMatch(param -> ClassUtils.containsTypeAnnotation(param, annotation));
        }
        return type instanceof AnnotatedArrayType && ClassUtils.containsTypeAnnotation(((AnnotatedArrayType)type).getAnnotatedGenericComponentType(), annotation);
    }

    public static Annotation[] getAllAnnotations(Stream<AnnotatedType> types) {
        return (Annotation[])types.flatMap(type -> Arrays.stream(type.getAnnotations())).distinct().toArray(Annotation[]::new);
    }

    public static <T extends AnnotatedType> T addAnnotations(T type, Annotation ... annotations) {
        if (type == null || annotations == null || annotations.length == 0) {
            return type;
        }
        return (T)GenericTypeReflector.updateAnnotations(type, (Annotation[])GenericTypeReflector.merge((Annotation[][])new Annotation[][]{type.getAnnotations(), annotations}));
    }

    public static <T extends AnnotatedType> T removeAnnotations(T type, Set<Class<? extends Annotation>> toRemove) {
        if (type.getAnnotations().length == 0 || toRemove.size() == 0) {
            return type;
        }
        ArrayList<Annotation> keptAnnotations = new ArrayList<Annotation>(type.getAnnotations().length);
        for (Annotation annotation : type.getAnnotations()) {
            if (toRemove.contains(annotation.annotationType())) continue;
            keptAnnotations.add(annotation);
        }
        return (T)GenericTypeReflector.replaceAnnotations(type, (Annotation[])keptAnnotations.toArray(new Annotation[0]));
    }

    public static AnnotatedType eraseBounds(AnnotatedType type, AnnotatedType replacement) {
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedType bound;
            AnnotatedWildcardType wildcard = (AnnotatedWildcardType)type;
            AnnotatedType annotatedType = bound = wildcard.getAnnotatedLowerBounds().length > 0 ? ClassUtils.eraseBounds(wildcard.getAnnotatedLowerBounds()[0], replacement) : ClassUtils.eraseBounds(wildcard.getAnnotatedUpperBounds()[0], replacement);
            if (bound.getType().equals(Object.class)) {
                if (replacement != null) {
                    bound = replacement;
                } else {
                    throw TypeMappingException.ambiguousType(type.getType());
                }
            }
            return GenericTypeReflector.updateAnnotations((AnnotatedType)bound, (Annotation[])type.getAnnotations());
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedType bound = ((AnnotatedTypeVariable)type).getAnnotatedBounds()[0];
            if (bound.getType().equals(Object.class)) {
                if (replacement != null) {
                    bound = replacement;
                } else {
                    throw TypeMappingException.ambiguousType(type.getType());
                }
            }
            return GenericTypeReflector.updateAnnotations((AnnotatedType)bound, (Annotation[])type.getAnnotations());
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] typeArguments = (AnnotatedType[])Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).map(parameterType -> ClassUtils.eraseBounds(parameterType, replacement)).toArray(AnnotatedType[]::new);
            return GenericTypeReflector.replaceParameters((AnnotatedParameterizedType)parameterizedType, (AnnotatedType[])typeArguments);
        }
        if (type instanceof AnnotatedArrayType) {
            return TypeFactory.arrayOf((AnnotatedType)ClassUtils.eraseBounds(((AnnotatedArrayType)type).getAnnotatedGenericComponentType(), replacement), (Annotation[])type.getAnnotations());
        }
        return type;
    }

    public static AnnotatedType completeGenerics(AnnotatedType type, AnnotatedType replacement) {
        if (type.getType() instanceof Class) {
            Class clazz = (Class)type.getType();
            if (clazz.isArray()) {
                return TypeFactory.arrayOf((AnnotatedType)ClassUtils.completeGenerics(GenericTypeReflector.annotate(clazz.getComponentType()), replacement), (Annotation[])type.getAnnotations());
            }
            if (ClassUtils.isMissingTypeParameters(clazz)) {
                if (replacement == null) {
                    throw TypeMappingException.ambiguousType(clazz);
                }
                Object[] parameters = new AnnotatedType[clazz.getTypeParameters().length];
                Arrays.fill(parameters, replacement);
                return TypeFactory.parameterizedAnnotatedClass((Class)clazz, (Annotation[])type.getAnnotations(), (AnnotatedType[])parameters);
            }
        } else {
            if (type instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
                AnnotatedType[] parameters = (AnnotatedType[])Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).map(parameterType -> ClassUtils.completeGenerics(parameterType, replacement)).toArray(AnnotatedType[]::new);
                return GenericTypeReflector.replaceParameters((AnnotatedParameterizedType)parameterizedType, (AnnotatedType[])parameters);
            }
            if (type instanceof AnnotatedArrayType) {
                AnnotatedType componentType = ClassUtils.completeGenerics(((AnnotatedArrayType)type).getAnnotatedGenericComponentType(), replacement);
                return TypeFactory.arrayOf((AnnotatedType)componentType, (Annotation[])type.getAnnotations());
            }
            if (type instanceof AnnotatedWildcardType || type instanceof AnnotatedTypeVariable) {
                throw new TypeMappingException(type.getType().getTypeName() + " can not be completed. Call eraseBounds first?");
            }
        }
        return type;
    }

    public static <T extends AnnotatedType> T transformType(T type, UnaryOperator<T> transformer) {
        if (type instanceof AnnotatedArrayType) {
            return (T)TypeFactory.arrayOf((AnnotatedType)((AnnotatedType)transformer.apply(((AnnotatedArrayType)type).getAnnotatedGenericComponentType())), (Annotation[])type.getAnnotations());
        }
        if (type.getType() instanceof Class) {
            return type;
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] arguments = (AnnotatedType[])Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).map(param -> (AnnotatedType)transformer.apply((AnnotatedType)param)).toArray(AnnotatedType[]::new);
            return (T)TypeFactory.parameterizedAnnotatedClass((Class)GenericTypeReflector.erase((Type)type.getType()), (Annotation[])type.getAnnotations(), (AnnotatedType[])arguments);
        }
        throw new IllegalArgumentException("Can not find the mappable type for: " + type.getType().getTypeName());
    }

    public static AnnotatedType getCommonSuperType(List<AnnotatedType> types) {
        return ClassUtils.getCommonSuperType(types, new HashSet<String>(), null);
    }

    public static AnnotatedType getCommonSuperType(List<AnnotatedType> types, AnnotatedType fallback) {
        return ClassUtils.getCommonSuperType(types, new HashSet<String>(), fallback);
    }

    private static AnnotatedType getCommonSuperType(List<AnnotatedType> types, Set<String> seenTypeCombos, AnnotatedType fallback) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("At least one type must be provided");
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        Annotation[] mergedAnnotations = ClassUtils.getMergedAnnotations(types.toArray(new AnnotatedType[0]));
        if (types.stream().map(AnnotatedType::getType).allMatch(type -> type.equals(((AnnotatedType)types.get(0)).getType()))) {
            return GenericTypeReflector.replaceAnnotations((AnnotatedType)types.get(0), (Annotation[])mergedAnnotations);
        }
        List<Class<?>> classes = types.stream().map(AnnotatedType::getType).map(ClassUtils::getRawType).collect(Collectors.toList());
        String typeNames = types.stream().map(type -> type.getType().getTypeName()).sorted().collect(Collectors.joining(","));
        if (seenTypeCombos.contains(typeNames)) {
            return ClassUtils.fallbackOrException(fallback);
        }
        seenTypeCombos.add(typeNames);
        if (types.stream().allMatch(type -> type instanceof AnnotatedArrayType)) {
            List<AnnotatedType> componentTypes = types.stream().map(type -> ((AnnotatedArrayType)type).getAnnotatedGenericComponentType()).collect(Collectors.toList());
            AnnotatedType componentType = ClassUtils.getCommonSuperType(componentTypes, seenTypeCombos, fallback);
            return TypeFactory.arrayOf((AnnotatedType)componentType, (Annotation[])mergedAnnotations);
        }
        Class<?> commonRawSuperType = ClassUtils.getCommonSuperTypes(classes).get(0);
        if (classes.stream().noneMatch(ROOT_TYPES::contains) && ROOT_TYPES.contains(commonRawSuperType)) {
            return ClassUtils.fallbackOrException(fallback);
        }
        List normalizedTypes = types.stream().map(type -> GenericTypeReflector.getExactSuperType((AnnotatedType)type, (Class)commonRawSuperType)).collect(Collectors.toList());
        if (normalizedTypes.stream().anyMatch(type -> ClassUtils.isMissingTypeParameters(type.getType()))) {
            throw new TypeMappingException("Automatic type inference failed because some of the types are missing generic type parameter(s).");
        }
        if (normalizedTypes.stream().allMatch(type -> type.getType() instanceof Class)) {
            return GenericTypeReflector.annotate(commonRawSuperType, (Annotation[])mergedAnnotations);
        }
        if (normalizedTypes.stream().allMatch(type -> type instanceof AnnotatedParameterizedType)) {
            AnnotatedType[] parameters = (AnnotatedType[])Arrays.stream(commonRawSuperType.getTypeParameters()).map(param -> normalizedTypes.stream().map(type -> GenericTypeReflector.getTypeParameter((AnnotatedType)type, (TypeVariable)param)).collect(Collectors.toList())).map(paramTypes -> ClassUtils.getCommonSuperType(paramTypes, seenTypeCombos, fallback)).toArray(AnnotatedType[]::new);
            return TypeFactory.parameterizedAnnotatedClass(commonRawSuperType, (Annotation[])mergedAnnotations, (AnnotatedType[])parameters);
        }
        return ClassUtils.fallbackOrException(fallback);
    }

    public static List<Class<?>> getCommonSuperTypes(List<Class<?>> classes) {
        LinkedHashSet rollingIntersect = new LinkedHashSet(ClassUtils.getSuperTypes(classes.get(0)));
        for (int i = 1; i < classes.size(); ++i) {
            rollingIntersect.retainAll(ClassUtils.getSuperTypes(classes.get(i)));
        }
        if (rollingIntersect.isEmpty()) {
            return Collections.singletonList(Object.class);
        }
        LinkedList result = new LinkedList(rollingIntersect);
        result.sort(new TypeComparator());
        return result;
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        nextLevel.add(clazz);
        do {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                Collections.addAll(nextLevel, each.getInterfaces());
            }
        } while (!nextLevel.isEmpty());
        return classes;
    }

    private static AnnotatedType fallbackOrException(AnnotatedType fallback) {
        if (fallback != null) {
            return fallback;
        }
        throw new TypeMappingException("Automatic type inference failed because some of the types had no common ancestors except for Object class");
    }

    public static boolean isProxy(Class<?> clazz) {
        return Proxy.isProxyClass(clazz) || javassistProxyClass != null && javassistProxyClass.isAssignableFrom(clazz) || KNOWN_PROXY_CLASS_SEPARATORS.stream().anyMatch(separator -> clazz.getName().contains((CharSequence)separator));
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static Object getDefaultValueForType(Class<?> type) {
        return DEFAULT_PRIMITIVE_VALUES.get(type);
    }

    public static boolean isPrimitive(AnnotatedType type) {
        return type.getType().getClass() == Class.class && ((Class)type.getType()).isPrimitive();
    }

    private static Annotation[] getMergedAnnotations(AnnotatedType ... types) {
        return (Annotation[])Arrays.stream(types).flatMap(type -> Arrays.stream(type.getAnnotations())).distinct().toArray(Annotation[]::new);
    }

    static {
        Class<?> proxy;
        KNOWN_PROXY_CLASS_SEPARATORS = Arrays.asList("$$", "$ByteBuddy$", "$HibernateProxy$");
        ROOT_TYPES = Arrays.asList(Object.class, Annotation.class, Cloneable.class, Comparable.class, Externalizable.class, Serializable.class, Closeable.class, AutoCloseable.class);
        try {
            proxy = ClassUtils.forName("javassist.util.proxy.ProxyObject");
        }
        catch (ClassNotFoundException e) {
            proxy = null;
        }
        javassistProxyClass = proxy;
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> defaultPrimitives = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        defaultPrimitives.put(Boolean.TYPE, Boolean.valueOf(false));
        defaultPrimitives.put(Byte.TYPE, Integer.valueOf(0));
        defaultPrimitives.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultPrimitives.put(Double.TYPE, Double.valueOf(0.0));
        defaultPrimitives.put(Float.TYPE, Float.valueOf(0.0f));
        defaultPrimitives.put(Integer.TYPE, Integer.valueOf(0));
        defaultPrimitives.put(Long.TYPE, Long.valueOf(0L));
        defaultPrimitives.put(Short.TYPE, Integer.valueOf(0));
        DEFAULT_PRIMITIVE_VALUES = Collections.unmodifiableMap(defaultPrimitives);
    }

    private static class TypeComparator
    implements Comparator<Class<?>> {
        private TypeComparator() {
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            if (c2 == Cloneable.class || c2 == Serializable.class) {
                return -1;
            }
            if (!c1.isInterface() && c2.isInterface()) {
                return -1;
            }
            if (c2.isAssignableFrom(c1)) {
                return -1;
            }
            return 0;
        }
    }
}

