/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.ConfigurationException;
import io.leangen.graphql.ExecutableSchema;
import io.leangen.graphql.ExtendedGeneratorConfiguration;
import io.leangen.graphql.ExtensionList;
import io.leangen.graphql.ExtensionProvider;
import io.leangen.graphql.GeneratorConfiguration;
import io.leangen.graphql.GraphQLSchemaProcessor;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolverInterceptor;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.execution.ResolverInterceptorFactoryParams;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.DelegatingInputFieldBuilder;
import io.leangen.graphql.generator.JavaDeprecationMappingConfig;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.OperationRegistry;
import io.leangen.graphql.generator.OperationSourceRegistry;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.generator.mapping.ArgumentInjector;
import io.leangen.graphql.generator.mapping.ArgumentInjectorRegistry;
import io.leangen.graphql.generator.mapping.ConverterRegistry;
import io.leangen.graphql.generator.mapping.IgnoredAnnotationsTypeComparator;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.SchemaTransformerRegistry;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.TypeMapperRegistry;
import io.leangen.graphql.generator.mapping.common.AnnotationMapper;
import io.leangen.graphql.generator.mapping.common.ArrayAdapter;
import io.leangen.graphql.generator.mapping.common.BatchLoaderAdapterFactory;
import io.leangen.graphql.generator.mapping.common.CollectionOutputConverter;
import io.leangen.graphql.generator.mapping.common.ContextInjector;
import io.leangen.graphql.generator.mapping.common.DirectiveValueDeserializer;
import io.leangen.graphql.generator.mapping.common.EnumMapToObjectTypeAdapter;
import io.leangen.graphql.generator.mapping.common.EnumMapper;
import io.leangen.graphql.generator.mapping.common.EnvironmentInjector;
import io.leangen.graphql.generator.mapping.common.IdAdapter;
import io.leangen.graphql.generator.mapping.common.InputValueDeserializer;
import io.leangen.graphql.generator.mapping.common.InterfaceMapper;
import io.leangen.graphql.generator.mapping.common.IterableAdapter;
import io.leangen.graphql.generator.mapping.common.ListMapper;
import io.leangen.graphql.generator.mapping.common.NonNullMapper;
import io.leangen.graphql.generator.mapping.common.ObjectScalarMapper;
import io.leangen.graphql.generator.mapping.common.ObjectTypeMapper;
import io.leangen.graphql.generator.mapping.common.OptionalAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalDoubleAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalIntAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalLongAdapter;
import io.leangen.graphql.generator.mapping.common.PageMapper;
import io.leangen.graphql.generator.mapping.common.RootContextInjector;
import io.leangen.graphql.generator.mapping.common.ScalarMapper;
import io.leangen.graphql.generator.mapping.common.StreamToCollectionTypeAdapter;
import io.leangen.graphql.generator.mapping.common.UnionInlineMapper;
import io.leangen.graphql.generator.mapping.common.UnionTypeMapper;
import io.leangen.graphql.generator.mapping.common.VoidToBooleanTypeAdapter;
import io.leangen.graphql.generator.mapping.core.CompletableFutureAdapter;
import io.leangen.graphql.generator.mapping.core.DataFetcherResultAdapter;
import io.leangen.graphql.generator.mapping.core.PublisherAdapter;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.AnnotatedInterfaceStrategy;
import io.leangen.graphql.generator.mapping.strategy.AutoScanAbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.DefaultImplementationDiscoveryStrategy;
import io.leangen.graphql.generator.mapping.strategy.ImplementationDiscoveryStrategy;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.generator.mapping.strategy.NoOpAbstractInputHandler;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.messages.DelegatingMessageBundle;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.DefaultInclusionStrategy;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.AnnotatedDirectiveBuilder;
import io.leangen.graphql.metadata.strategy.query.AnnotatedResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.BeanResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.DefaultOperationBuilder;
import io.leangen.graphql.metadata.strategy.query.DirectiveBuilder;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.metadata.strategy.query.RecordResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeTransformer;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.AnnotationInputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Defaults;
import io.leangen.graphql.util.GraphQLUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GraphQLSchemaGenerator {
    private InterfaceMappingStrategy interfaceStrategy = new AnnotatedInterfaceStrategy();
    private ScalarDeserializationStrategy scalarStrategy;
    private AbstractInputHandler abstractInputHandler = new NoOpAbstractInputHandler();
    private OperationBuilder operationBuilder = new DefaultOperationBuilder(DefaultOperationBuilder.TypeInference.NONE);
    private DirectiveBuilder directiveBuilder = new AnnotatedDirectiveBuilder();
    private ValueMapperFactory<?> valueMapperFactory;
    private InclusionStrategy inclusionStrategy;
    private ImplementationDiscoveryStrategy implDiscoveryStrategy = new DefaultImplementationDiscoveryStrategy();
    private TypeInfoGenerator typeInfoGenerator = new DefaultTypeInfoGenerator();
    private TypeTransformer typeTransformer = new DefaultTypeTransformer(false, false);
    private GlobalEnvironment environment;
    private String[] basePackages = Utils.emptyArray();
    private final DelegatingMessageBundle messageBundle = new DelegatingMessageBundle();
    private Executor batchLoaderExecutor;
    private List<TypeMapper> typeMappers;
    private List<SchemaTransformer> transformers;
    private Comparator<AnnotatedType> typeComparator;
    private List<InputFieldBuilder> inputFieldBuilders;
    private ResolverInterceptorFactory interceptorFactory;
    private JavaDeprecationMappingConfig javaDeprecationConfig = new JavaDeprecationMappingConfig(true, "Deprecated");
    private final OperationSourceRegistry operationSourceRegistry = new OperationSourceRegistry();
    private final List<ExtensionProvider<GeneratorConfiguration, TypeMapper>> typeMapperProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, TypeMapper>>();
    private final List<ExtensionProvider<GeneratorConfiguration, SchemaTransformer>> schemaTransformerProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, SchemaTransformer>>();
    private final List<ExtensionProvider<GeneratorConfiguration, InputConverter>> inputConverterProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, InputConverter>>();
    private final List<ExtensionProvider<GeneratorConfiguration, OutputConverter>> outputConverterProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, OutputConverter>>();
    private final List<ExtensionProvider<GeneratorConfiguration, ArgumentInjector>> argumentInjectorProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, ArgumentInjector>>();
    private final List<ExtensionProvider<ExtendedGeneratorConfiguration, InputFieldBuilder>> inputFieldBuilderProviders = new ArrayList<ExtensionProvider<ExtendedGeneratorConfiguration, InputFieldBuilder>>();
    private final List<ExtensionProvider<GeneratorConfiguration, ResolverBuilder>> resolverBuilderProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, ResolverBuilder>>();
    private final List<ExtensionProvider<GeneratorConfiguration, ResolverBuilder>> nestedResolverBuilderProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, ResolverBuilder>>();
    private final List<ExtensionProvider<GeneratorConfiguration, Module>> moduleProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, Module>>();
    private final List<ExtensionProvider<GeneratorConfiguration, ResolverInterceptorFactory>> interceptorFactoryProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, ResolverInterceptorFactory>>();
    private final List<ExtensionProvider<GeneratorConfiguration, Comparator<AnnotatedType>>> typeComparatorProviders = new ArrayList<ExtensionProvider<GeneratorConfiguration, Comparator<AnnotatedType>>>();
    private final Collection<GraphQLSchemaProcessor> processors = new HashSet<GraphQLSchemaProcessor>();
    private final RelayMappingConfig relayMappingConfig = new RelayMappingConfig();
    private final Map<String, GraphQLDirective> additionalDirectives = new HashMap<String, GraphQLDirective>();
    private final List<AnnotatedType> additionalDirectiveTypes = new ArrayList<AnnotatedType>();
    private final GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry();
    private final Map<String, GraphQLNamedType> additionalTypes = new HashMap<String, GraphQLNamedType>();
    private final Map<String, AnnotatedType> additionalTypeMappings = new HashMap<String, AnnotatedType>();
    private final String queryRoot;
    private final String mutationRoot;
    private final String subscriptionRoot;
    private final String queryRootDescription;
    private final String mutationRootDescription;
    private final String subscriptionRootDescription;

    public GraphQLSchemaGenerator() {
        this("Query", "Mutation", "Subscription");
    }

    public GraphQLSchemaGenerator(String queryRoot, String mutationRoot, String subscriptionRoot) {
        this(queryRoot, "Query root", mutationRoot, "Mutation root", subscriptionRoot, "Subscription root");
    }

    public GraphQLSchemaGenerator(String queryRoot, String queryRootDescription, String mutationRoot, String mutationRootDescription, String subscriptionRoot, String subscriptionRootDescription) {
        this.queryRoot = queryRoot;
        this.mutationRoot = mutationRoot;
        this.subscriptionRoot = subscriptionRoot;
        this.queryRootDescription = queryRootDescription;
        this.mutationRootDescription = mutationRootDescription;
        this.subscriptionRootDescription = subscriptionRootDescription;
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, ResolverBuilder ... builders) {
        return this.withOperationsFromSingleton(serviceSingleton, serviceSingleton.getClass(), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, Type beanType, ResolverBuilder ... builders) {
        return this.withOperationsFromSingleton(serviceSingleton, GenericTypeReflector.annotate((Type)this.checkType(beanType)), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, AnnotatedType beanType, ResolverBuilder ... builders) {
        return this.withOperationsFromBean(() -> serviceSingleton, beanType, (Class<?>)null, builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingletons(Object ... serviceSingletons) {
        Arrays.stream(serviceSingletons).forEach(x$0 -> this.withOperationsFromSingleton(x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromBean(Supplier<Object> serviceSupplier, Type beanType, ResolverBuilder ... builders) {
        return this.withOperationsFromBean(serviceSupplier, GenericTypeReflector.annotate((Type)this.checkType(beanType)), ClassUtils.getRawType(beanType), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromBean(Supplier<Object> serviceSupplier, AnnotatedType beanType, ResolverBuilder ... builders) {
        return this.withOperationsFromBean(serviceSupplier, beanType, ClassUtils.getRawType(beanType.getType()), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromBean(Supplier<Object> serviceSupplier, Type beanType, Class<?> exposedType, ResolverBuilder ... builders) {
        return this.withOperationsFromBean(serviceSupplier, GenericTypeReflector.annotate((Type)this.checkType(beanType)), exposedType, builders);
    }

    public GraphQLSchemaGenerator withOperationsFromBean(Supplier<Object> serviceSupplier, AnnotatedType beanType, Class<?> exposedType, ResolverBuilder ... builders) {
        this.checkType(beanType);
        this.operationSourceRegistry.registerOperationSource(serviceSupplier, beanType, exposedType, Utils.asList(builders));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(Type serviceType, ResolverBuilder ... builders) {
        return this.withOperationsFromType(GenericTypeReflector.annotate((Type)serviceType), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromTypes(Type ... serviceType) {
        Arrays.stream(serviceType).forEach(x$0 -> this.withOperationsFromType((Type)x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(AnnotatedType serviceType, ResolverBuilder ... builders) {
        this.checkType(serviceType);
        this.operationSourceRegistry.registerOperationSource(serviceType, Utils.asList(builders));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromTypes(AnnotatedType ... serviceType) {
        Arrays.stream(serviceType).forEach(x$0 -> this.withOperationsFromType((AnnotatedType)x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withResolverBuilders(ResolverBuilder ... resolverBuilders) {
        return this.withResolverBuilders((GeneratorConfiguration config, ExtensionList<ResolverBuilder> defaults) -> Arrays.asList(resolverBuilders));
    }

    public GraphQLSchemaGenerator withResolverBuilders(ExtensionProvider<GeneratorConfiguration, ResolverBuilder> provider) {
        this.resolverBuilderProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withNestedResolverBuilders(ResolverBuilder ... resolverBuilders) {
        return this.withNestedResolverBuilders((GeneratorConfiguration config, ExtensionList<ResolverBuilder> defaults) -> Arrays.asList(resolverBuilders));
    }

    public GraphQLSchemaGenerator withNestedResolverBuilders(ExtensionProvider<GeneratorConfiguration, ResolverBuilder> provider) {
        this.nestedResolverBuilderProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withInputFieldBuilders(InputFieldBuilder ... inputFieldBuilders) {
        return this.withInputFieldBuilders((ExtendedGeneratorConfiguration env, ExtensionList<InputFieldBuilder> defaults) -> defaults.prepend(inputFieldBuilders));
    }

    public GraphQLSchemaGenerator withInputFieldBuilders(ExtensionProvider<ExtendedGeneratorConfiguration, InputFieldBuilder> provider) {
        this.inputFieldBuilderProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withAbstractInputTypeResolution() {
        this.abstractInputHandler = new AutoScanAbstractInputHandler();
        return this;
    }

    public GraphQLSchemaGenerator withAbstractInputHandler(AbstractInputHandler abstractInputHandler) {
        this.abstractInputHandler = abstractInputHandler;
        return this;
    }

    public GraphQLSchemaGenerator withBasePackages(String ... basePackages) {
        this.basePackages = Utils.emptyIfNull(basePackages);
        return this;
    }

    public GraphQLSchemaGenerator withStringInterpolation(MessageBundle ... messageBundles) {
        this.messageBundle.withBundles(messageBundles);
        return this;
    }

    public GraphQLSchemaGenerator withJavaDeprecationRespected(boolean respectJavaDeprecation) {
        this.javaDeprecationConfig = new JavaDeprecationMappingConfig(respectJavaDeprecation, this.javaDeprecationConfig.deprecationReason);
        return this;
    }

    public GraphQLSchemaGenerator withJavaDeprecationReason(String deprecationReason) {
        this.javaDeprecationConfig = new JavaDeprecationMappingConfig(this.javaDeprecationConfig.enabled, deprecationReason);
        return this;
    }

    public GraphQLSchemaGenerator withTypeInfoGenerator(TypeInfoGenerator typeInfoGenerator) {
        this.typeInfoGenerator = typeInfoGenerator;
        return this;
    }

    public GraphQLSchemaGenerator withValueMapperFactory(ValueMapperFactory valueMapperFactory) {
        this.valueMapperFactory = valueMapperFactory;
        return this;
    }

    public GraphQLSchemaGenerator withInterfaceMappingStrategy(InterfaceMappingStrategy interfaceStrategy) {
        this.interfaceStrategy = interfaceStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withScalarDeserializationStrategy(ScalarDeserializationStrategy scalarStrategy) {
        this.scalarStrategy = scalarStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withInclusionStrategy(InclusionStrategy inclusionStrategy) {
        this.inclusionStrategy = inclusionStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withImplementationDiscoveryStrategy(ImplementationDiscoveryStrategy implDiscoveryStrategy) {
        this.implDiscoveryStrategy = implDiscoveryStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withTypeTransformer(TypeTransformer transformer) {
        this.typeTransformer = transformer;
        return this;
    }

    public GraphQLSchemaGenerator withTypeMappers(TypeMapper ... typeMappers) {
        return this.withTypeMappers((GeneratorConfiguration conf, ExtensionList<TypeMapper> current) -> current.insertAfterOrAppend(IdAdapter.class, typeMappers));
    }

    public GraphQLSchemaGenerator withTypeMappersPrepended(TypeMapper ... typeMappers) {
        this.typeMapperProviders.add(0, (conf, current) -> current.insertAfterOrAppend(IdAdapter.class, typeMappers));
        return this;
    }

    public GraphQLSchemaGenerator withTypeMappersPrepended(ExtensionProvider<GeneratorConfiguration, TypeMapper> provider) {
        this.typeMapperProviders.add(0, provider);
        return this;
    }

    public GraphQLSchemaGenerator withTypeMappers(ExtensionProvider<GeneratorConfiguration, TypeMapper> provider) {
        this.typeMapperProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withSchemaTransformers(SchemaTransformer ... transformers) {
        return this.withSchemaTransformers((GeneratorConfiguration conf, ExtensionList<SchemaTransformer> current) -> current.append(transformers));
    }

    public GraphQLSchemaGenerator withSchemaTransformers(ExtensionProvider<GeneratorConfiguration, SchemaTransformer> provider) {
        this.schemaTransformerProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withInputConverters(InputConverter<?, ?> ... inputConverters) {
        return this.withInputConverters((GeneratorConfiguration config, ExtensionList<InputConverter> current) -> current.insert(0, inputConverters));
    }

    public GraphQLSchemaGenerator withInputConvertersPrepended(InputConverter<?, ?> ... inputConverters) {
        this.inputConverterProviders.add(0, (config, current) -> current.insert(0, inputConverters));
        return this;
    }

    public GraphQLSchemaGenerator withInputConverters(ExtensionProvider<GeneratorConfiguration, InputConverter> provider) {
        this.inputConverterProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withOutputConverters(OutputConverter<?, ?> ... outputConverters) {
        return this.withOutputConverters((GeneratorConfiguration config, ExtensionList<OutputConverter> current) -> current.insertAfterOrAppend(IdAdapter.class, outputConverters));
    }

    public GraphQLSchemaGenerator withOutputConvertersPrepended(OutputConverter<?, ?> ... outputConverters) {
        this.outputConverterProviders.add(0, (config, current) -> current.insertAfterOrAppend(IdAdapter.class, outputConverters));
        return this;
    }

    public GraphQLSchemaGenerator withOutputConverters(ExtensionProvider<GeneratorConfiguration, OutputConverter> provider) {
        this.outputConverterProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withTypeAdapters(AbstractTypeAdapter<?, ?> ... typeAdapters) {
        this.withInputConverters(typeAdapters);
        this.withOutputConverters(typeAdapters);
        return this.withTypeMappers((GeneratorConfiguration conf, ExtensionList<TypeMapper> defaults) -> defaults.insertAfter(ScalarMapper.class, (E[])typeAdapters));
    }

    public GraphQLSchemaGenerator withArgumentInjectors(ArgumentInjector ... argumentInjectors) {
        return this.withArgumentInjectors((GeneratorConfiguration config, ExtensionList<ArgumentInjector> current) -> current.insert(0, argumentInjectors));
    }

    public GraphQLSchemaGenerator withArgumentInjectors(ExtensionProvider<GeneratorConfiguration, ArgumentInjector> provider) {
        this.argumentInjectorProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withModules(Module ... modules) {
        return this.withModules((GeneratorConfiguration config, ExtensionList<Module> current) -> current.append(modules));
    }

    public GraphQLSchemaGenerator withModules(ExtensionProvider<GeneratorConfiguration, Module> provider) {
        this.moduleProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withResolverInterceptors(List<ResolverInterceptor> innerInterceptors, List<ResolverInterceptor> outerInterceptors) {
        return this.withResolverInterceptorFactories((config, current) -> current.append(new GlobalResolverInterceptorFactory(innerInterceptors, outerInterceptors)));
    }

    public GraphQLSchemaGenerator withResolverInterceptors(ResolverInterceptor ... interceptors) {
        return this.withResolverInterceptors(Arrays.asList(interceptors));
    }

    public GraphQLSchemaGenerator withResolverInterceptors(List<ResolverInterceptor> interceptors) {
        return this.withResolverInterceptorFactories((config, current) -> current.append(GlobalResolverInterceptorFactory.early(interceptors)));
    }

    public GraphQLSchemaGenerator withOuterResolverInterceptors(ResolverInterceptor ... interceptors) {
        return this.withOuterResolverInterceptors(Arrays.asList(interceptors));
    }

    public GraphQLSchemaGenerator withOuterResolverInterceptors(List<ResolverInterceptor> interceptors) {
        return this.withResolverInterceptorFactories((config, current) -> current.append(GlobalResolverInterceptorFactory.late(interceptors)));
    }

    public GraphQLSchemaGenerator withResolverInterceptorFactories(ExtensionProvider<GeneratorConfiguration, ResolverInterceptorFactory> provider) {
        this.interceptorFactoryProviders.add(provider);
        return this;
    }

    @Deprecated
    public GraphQLSchemaGenerator withAdditionalTypes(Collection<GraphQLType> additionalTypes) {
        return this.withAdditionalTypes(additionalTypes, Collections.emptyMap(), new NoOpCodeRegistryBuilder());
    }

    public GraphQLSchemaGenerator withAdditionalTypes(Collection<? extends GraphQLType> additionalTypes, Map<String, AnnotatedType> additionalTypeMappings, GraphQLCodeRegistry codeRegistry) {
        return this.withAdditionalTypes(additionalTypes, additionalTypeMappings, new CodeRegistryMerger(codeRegistry));
    }

    public GraphQLSchemaGenerator withAdditionalTypes(Collection<? extends GraphQLType> additionalTypes, Map<String, AnnotatedType> additionalTypeMappings, CodeRegistryBuilder codeRegistryUpdater) {
        this.additionalTypeMappings.putAll(additionalTypeMappings);
        additionalTypes.forEach(type -> this.merge((GraphQLType)type, this.additionalTypes, codeRegistryUpdater, this.codeRegistry));
        return this;
    }

    public GraphQLSchemaGenerator withBatchLoaderExecutor(Executor executor) {
        this.batchLoaderExecutor = executor;
        return this;
    }

    private void merge(GraphQLType type, Map<String, GraphQLNamedType> additionalTypes, CodeRegistryBuilder updater, GraphQLCodeRegistry.Builder builder) {
        TypeResolver typeResolver;
        GraphQLNamedType namedType = GraphQLUtils.unwrap(type);
        if (!this.isRealType(namedType)) {
            return;
        }
        if (additionalTypes.containsKey(namedType.getName())) {
            if (additionalTypes.get(namedType.getName()).equals(namedType)) {
                return;
            }
            throw new ConfigurationException("Type name collision: multiple registered additional types are named '" + namedType.getName() + "'");
        }
        additionalTypes.put(namedType.getName(), namedType);
        if (namedType instanceof GraphQLInterfaceType && (typeResolver = updater.getTypeResolver((GraphQLInterfaceType)namedType)) != null) {
            builder.typeResolverIfAbsent((GraphQLInterfaceType)namedType, typeResolver);
        }
        if (namedType instanceof GraphQLUnionType && (typeResolver = updater.getTypeResolver((GraphQLUnionType)namedType)) != null) {
            builder.typeResolverIfAbsent((GraphQLUnionType)namedType, typeResolver);
        }
        if (namedType instanceof GraphQLFieldsContainer) {
            GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)namedType;
            fieldsContainer.getFieldDefinitions().forEach(fieldDef -> {
                DataFetcher<?> dataFetcher = updater.getDataFetcher(fieldsContainer, (GraphQLFieldDefinition)fieldDef);
                if (dataFetcher != null) {
                    builder.dataFetcherIfAbsent(FieldCoordinates.coordinates((GraphQLFieldsContainer)fieldsContainer, (GraphQLFieldDefinition)fieldDef), dataFetcher);
                }
                this.merge((GraphQLType)fieldDef.getType(), additionalTypes, updater, builder);
                fieldDef.getArguments().forEach(arg -> this.merge((GraphQLType)arg.getType(), additionalTypes, updater, builder));
            });
        }
        if (namedType instanceof GraphQLInputFieldsContainer) {
            ((GraphQLInputFieldsContainer)namedType).getFieldDefinitions().forEach(fieldDef -> this.merge((GraphQLType)fieldDef.getType(), additionalTypes, updater, builder));
        }
    }

    public GraphQLSchemaGenerator withAdditionalDirectives(Type ... additionalDirectives) {
        return this.withAdditionalDirectives((AnnotatedType[])Arrays.stream(additionalDirectives).map(GenericTypeReflector::annotate).toArray(AnnotatedType[]::new));
    }

    public GraphQLSchemaGenerator withAdditionalDirectives(AnnotatedType ... additionalDirectives) {
        Collections.addAll(this.additionalDirectiveTypes, additionalDirectives);
        return this;
    }

    public GraphQLSchemaGenerator withAdditionalDirectives(GraphQLDirective ... additionalDirectives) {
        NoOpCodeRegistryBuilder noOp = new NoOpCodeRegistryBuilder();
        Arrays.stream(additionalDirectives).forEach(directive -> {
            if (this.additionalDirectives.put(directive.getName(), (GraphQLDirective)directive) != null) {
                throw new ConfigurationException("Directive name collision: multiple registered additional directives are named '" + directive.getName() + "'");
            }
            directive.getArguments().forEach(arg -> this.merge((GraphQLType)arg.getType(), this.additionalTypes, noOp, this.codeRegistry));
        });
        return this;
    }

    @SafeVarargs
    public final GraphQLSchemaGenerator withTypeComparators(Comparator<AnnotatedType> ... comparators) {
        return this.withTypeComparators((GeneratorConfiguration config, ExtensionList<Comparator<AnnotatedType>> current) -> current.append(comparators));
    }

    public GraphQLSchemaGenerator withTypeComparators(ExtensionProvider<GeneratorConfiguration, Comparator<AnnotatedType>> provider) {
        this.typeComparatorProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withOperationBuilder(OperationBuilder operationBuilder) {
        this.operationBuilder = operationBuilder;
        return this;
    }

    public GraphQLSchemaGenerator withDirectiveBuilder(DirectiveBuilder directiveBuilder) {
        this.directiveBuilder = directiveBuilder;
        return this;
    }

    public GraphQLSchemaGenerator withRelayCompliantMutations() {
        return this.withRelayCompliantMutations("result", "Mutation result");
    }

    public GraphQLSchemaGenerator withRelayCompliantMutations(String wrapperFieldName, String wrapperFieldDescription) {
        this.relayMappingConfig.relayCompliantMutations = true;
        this.relayMappingConfig.wrapperFieldName = wrapperFieldName;
        this.relayMappingConfig.wrapperFieldDescription = wrapperFieldDescription;
        return this;
    }

    public GraphQLSchemaGenerator withRelayNodeInterfaceInference(boolean enabled) {
        this.relayMappingConfig.inferNodeInterface = enabled;
        return this;
    }

    public GraphQLSchemaGenerator withRelayConnectionCheckRelaxed() {
        this.relayMappingConfig.strictConnectionSpec = false;
        return this;
    }

    public GraphQLSchemaGenerator withSchemaProcessors(GraphQLSchemaProcessor ... processors) {
        Collections.addAll(this.processors, processors);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var12_28;
        void var11_23;
        void var10_18;
        ValueMapperFactory<?> internalValueMapperFactory;
        GeneratorConfiguration configuration = new GeneratorConfiguration(this.interfaceStrategy, this.scalarStrategy, this.typeTransformer, this.basePackages, this.javaDeprecationConfig);
        List<Module> modules = Defaults.modules();
        for (ExtensionProvider<GeneratorConfiguration, Module> provider : this.moduleProviders) {
            modules = provider.getExtensions(configuration, new ExtensionList<Module>(modules));
        }
        this.checkForDuplicates("modules", modules);
        modules.forEach(module -> module.setUp(() -> this));
        if (this.operationSourceRegistry.isEmpty()) {
            throw new IllegalStateException("At least one top-level operation source must be registered");
        }
        if (this.inclusionStrategy == null) {
            this.inclusionStrategy = new DefaultInclusionStrategy(this.basePackages);
        }
        ValueMapperFactory<?> valueMapperFactory = internalValueMapperFactory = this.valueMapperFactory != null ? this.valueMapperFactory : Defaults.valueMapperFactory(this.typeInfoGenerator);
        if (this.scalarStrategy == null) {
            this.scalarStrategy = internalValueMapperFactory instanceof ScalarDeserializationStrategy ? (ScalarDeserializationStrategy)((Object)internalValueMapperFactory) : (ScalarDeserializationStrategy)((Object)Defaults.valueMapperFactory(this.typeInfoGenerator));
        }
        List<ResolverBuilder> resolverBuilders = Collections.singletonList(new AnnotatedResolverBuilder());
        for (ExtensionProvider<GeneratorConfiguration, ResolverBuilder> extensionProvider : this.resolverBuilderProviders) {
            resolverBuilders = extensionProvider.getExtensions(configuration, new ExtensionList<ResolverBuilder>(resolverBuilders));
        }
        this.checkForEmptyOrDuplicates("resolver builders", resolverBuilders);
        this.operationSourceRegistry.registerGlobalResolverBuilders(resolverBuilders);
        List<ResolverBuilder> nestedResolverBuilders = Arrays.asList(new AnnotatedResolverBuilder(), new BeanResolverBuilder(this.basePackages).withJavaDeprecation(this.javaDeprecationConfig), new RecordResolverBuilder(this.basePackages));
        for (ExtensionProvider<GeneratorConfiguration, ResolverBuilder> extensionProvider : this.nestedResolverBuilderProviders) {
            nestedResolverBuilders = extensionProvider.getExtensions(configuration, new ExtensionList<ResolverBuilder>(nestedResolverBuilders));
        }
        this.checkForEmptyOrDuplicates("nested resolver builders", nestedResolverBuilders);
        this.operationSourceRegistry.registerGlobalNestedResolverBuilders(nestedResolverBuilders);
        ObjectTypeMapper objectTypeMapper = new ObjectTypeMapper();
        PublisherAdapter publisherAdapter = new PublisherAdapter();
        EnumMapper enumMapper = new EnumMapper(this.javaDeprecationConfig);
        this.typeMappers = Arrays.asList(new NonNullMapper(), new IdAdapter(), new ScalarMapper(), new CompletableFutureAdapter(), publisherAdapter, new AnnotationMapper(), new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), enumMapper, new ArrayAdapter(), new UnionTypeMapper(), new UnionInlineMapper(), new StreamToCollectionTypeAdapter(), new DataFetcherResultAdapter(), new VoidToBooleanTypeAdapter(), new ListMapper(), new IterableAdapter(), new PageMapper(), new OptionalAdapter(), new EnumMapToObjectTypeAdapter(enumMapper), new ObjectScalarMapper(), new InterfaceMapper(this.interfaceStrategy, objectTypeMapper), objectTypeMapper);
        for (ExtensionProvider<GeneratorConfiguration, TypeMapper> extensionProvider : this.typeMapperProviders) {
            this.typeMappers = extensionProvider.getExtensions(configuration, new ExtensionList<TypeMapper>(this.typeMappers));
        }
        this.checkForEmptyOrDuplicates("type mappers", this.typeMappers);
        this.transformers = Arrays.asList(new NonNullMapper(), publisherAdapter);
        for (ExtensionProvider<GeneratorConfiguration, Object> extensionProvider : this.schemaTransformerProviders) {
            this.transformers = extensionProvider.getExtensions(configuration, new ExtensionList<SchemaTransformer>(this.transformers));
        }
        this.checkForEmptyOrDuplicates("schema transformers", this.transformers);
        List<OutputConverter> outputConverters = Arrays.asList(new IdAdapter(), new ArrayAdapter(), new CollectionOutputConverter(), new CompletableFutureAdapter(), new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new OptionalAdapter(), new StreamToCollectionTypeAdapter(), publisherAdapter);
        for (ExtensionProvider<GeneratorConfiguration, OutputConverter> extensionProvider : this.outputConverterProviders) {
            outputConverters = extensionProvider.getExtensions(configuration, new ExtensionList<OutputConverter>(outputConverters));
        }
        this.checkForDuplicates("output converters", outputConverters);
        List<InputConverter> list = Arrays.asList(new CompletableFutureAdapter(), new StreamToCollectionTypeAdapter(), new IterableAdapter(), new EnumMapToObjectTypeAdapter(enumMapper));
        for (ExtensionProvider<GeneratorConfiguration, InputConverter> extensionProvider : this.inputConverterProviders) {
            List<InputConverter> list2 = extensionProvider.getExtensions(configuration, new ExtensionList(var10_18));
        }
        this.checkForDuplicates("input converters", (List)var10_18);
        List<ArgumentInjector> list3 = Arrays.asList(new IdAdapter(), new RootContextInjector(), new ContextInjector(), new EnvironmentInjector(), new DirectiveValueDeserializer(), new InputValueDeserializer());
        for (ExtensionProvider<GeneratorConfiguration, ArgumentInjector> extensionProvider : this.argumentInjectorProviders) {
            List<ArgumentInjector> list4 = extensionProvider.getExtensions(configuration, new ExtensionList(var11_23));
        }
        this.checkForDuplicates("argument injectors", (List)var11_23);
        List<ResolverInterceptorFactory> list5 = Arrays.asList(new DataFetcherResultAdapter(), new BatchLoaderAdapterFactory(this.batchLoaderExecutor), new VoidToBooleanTypeAdapter());
        for (ExtensionProvider<GeneratorConfiguration, ResolverInterceptorFactory> extensionProvider : this.interceptorFactoryProviders) {
            List<ResolverInterceptorFactory> list6 = extensionProvider.getExtensions(configuration, new ExtensionList(var12_28));
        }
        this.interceptorFactory = new DelegatingResolverInterceptorFactory((List)var12_28);
        HashMap<GraphQLNamedType, AnnotatedType> hashMap = new HashMap<GraphQLNamedType, AnnotatedType>();
        for (Map.Entry<String, GraphQLNamedType> entry : this.additionalTypes.entrySet()) {
            hashMap.put(entry.getValue(), this.additionalTypeMappings.get(entry.getKey()));
        }
        this.environment = new GlobalEnvironment(this.messageBundle, new Relay(), new TypeRegistry(hashMap), new ConverterRegistry((List<InputConverter>)var10_18, outputConverters), new ArgumentInjectorRegistry((List<ArgumentInjector>)var11_23), this.typeTransformer, this.inclusionStrategy, this.typeInfoGenerator);
        ExtendedGeneratorConfiguration extendedGeneratorConfiguration = new ExtendedGeneratorConfiguration(configuration, this.environment);
        this.valueMapperFactory = new MemoizedValueMapperFactory(this.environment, internalValueMapperFactory);
        Object obj = this.valueMapperFactory.getValueMapper(Collections.emptyMap(), this.environment);
        InputFieldBuilder defaultInputFieldBuilder = obj instanceof InputFieldBuilder ? (InputFieldBuilder)obj : (InputFieldBuilder)Defaults.valueMapperFactory(this.typeInfoGenerator).getValueMapper(Collections.emptyMap(), this.environment);
        this.inputFieldBuilders = Arrays.asList(new AnnotationInputFieldBuilder(), defaultInputFieldBuilder);
        for (ExtensionProvider<ExtendedGeneratorConfiguration, InputFieldBuilder> provider : this.inputFieldBuilderProviders) {
            this.inputFieldBuilders = provider.getExtensions(extendedGeneratorConfiguration, new ExtensionList<InputFieldBuilder>(this.inputFieldBuilders));
        }
        this.checkForEmptyOrDuplicates("input field builders", this.inputFieldBuilders);
        List<Comparator<Object>> typeComparators = new ArrayList<Comparator>();
        typeComparators.add(new IgnoredAnnotationsTypeComparator().include("io.leangen").exclude(GraphQLNonNull.class));
        Type annotatedTypeComparator = TypeFactory.parameterizedClass(Comparator.class, (Type[])new Type[]{AnnotatedType.class});
        for (TypeMapper typeMapper : this.typeMappers) {
            if (!GenericTypeReflector.isSuperType((Type)annotatedTypeComparator, typeMapper.getClass())) continue;
            typeComparators.add((Comparator)((Object)typeMapper));
        }
        for (ExtensionProvider extensionProvider : this.typeComparatorProviders) {
            typeComparators = extensionProvider.getExtensions(configuration, new ExtensionList(typeComparators));
        }
        ArrayList<Comparator> finalTypeComparators = typeComparators;
        this.typeComparator = (t1, t2) -> finalTypeComparators.stream().anyMatch(comparator -> comparator.compare(t1, t2) == 0) ? 0 : -1;
    }

    public GraphQLSchema generate() {
        return this.generateExecutable().getSchema();
    }

    public ExecutableSchema generateExecutable() {
        List<GraphQLFieldDefinition> subscriptions;
        this.init();
        String queryRootName = this.messageBundle.interpolate(this.queryRoot);
        String mutationRootName = this.messageBundle.interpolate(this.mutationRoot);
        String subscriptionRootName = this.messageBundle.interpolate(this.subscriptionRoot);
        BuildContext buildContext = new BuildContext(this.basePackages, this.environment, new OperationRegistry(this.operationSourceRegistry, this.operationBuilder, this.inclusionStrategy, this.typeTransformer, this.basePackages, this.environment), new TypeMapperRegistry(this.typeMappers), new SchemaTransformerRegistry(this.transformers), this.valueMapperFactory, this.interfaceStrategy, this.scalarStrategy, this.typeTransformer, this.abstractInputHandler, new DelegatingInputFieldBuilder(this.inputFieldBuilders), this.interceptorFactory, this.directiveBuilder, this.inclusionStrategy, this.relayMappingConfig, this.additionalTypes.values(), this.additionalDirectiveTypes, this.typeComparator, this.implDiscoveryStrategy, this.codeRegistry);
        OperationMapper operationMapper = new OperationMapper(queryRootName, mutationRootName, subscriptionRootName, buildContext);
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema();
        builder.query(GraphQLObjectType.newObject().name(queryRootName).description(this.messageBundle.interpolate(this.queryRootDescription)).fields(operationMapper.getQueries()).build());
        List<GraphQLFieldDefinition> mutations = operationMapper.getMutations();
        if (!mutations.isEmpty()) {
            builder.mutation(GraphQLObjectType.newObject().name(mutationRootName).description(this.messageBundle.interpolate(this.mutationRootDescription)).fields(mutations).build());
        }
        if (!(subscriptions = operationMapper.getSubscriptions()).isEmpty()) {
            builder.subscription(GraphQLObjectType.newObject().name(subscriptionRootName).description(this.messageBundle.interpolate(this.subscriptionRootDescription)).fields(subscriptions).build());
        }
        HashSet<GraphQLNamedType> additional = new HashSet<GraphQLNamedType>(this.additionalTypes.values());
        additional.addAll(buildContext.typeRegistry.getDiscoveredTypes());
        builder.additionalTypes(additional);
        builder.additionalDirectives(new HashSet<GraphQLDirective>(this.additionalDirectives.values()));
        builder.additionalDirectives(new HashSet<GraphQLDirective>(operationMapper.getDirectives()));
        builder.withSchemaAppliedDirectives(operationMapper.getSchemaDirectives());
        builder.codeRegistry(buildContext.codeRegistry.build());
        this.applyProcessors(builder, buildContext);
        buildContext.executePostBuildHooks();
        GraphQLSchema schema = builder.build();
        return new ExecutableSchema(schema, buildContext.typeRegistry, operationMapper.getBatchResolvers(), this.environment);
    }

    private void applyProcessors(GraphQLSchema.Builder builder, BuildContext buildContext) {
        for (GraphQLSchemaProcessor processor : this.processors) {
            processor.process(builder, buildContext);
        }
    }

    private boolean isRealType(GraphQLNamedType type) {
        return !GraphQLUtils.isIntrospectionType((GraphQLType)type) && !(type instanceof GraphQLTypeReference) && !(type instanceof GraphQLArgument) && !(type instanceof GraphQLDirective) && !type.getName().equals(this.messageBundle.interpolate(this.queryRoot)) && !type.getName().equals(this.messageBundle.interpolate(this.mutationRoot)) && !type.getName().equals(this.messageBundle.interpolate(this.subscriptionRoot));
    }

    private Type checkType(Type type) {
        if (type == null) {
            throw TypeMappingException.unknownType();
        }
        Class clazz = ClassUtils.getRawType(type);
        if (ClassUtils.isProxy(clazz)) {
            throw new TypeMappingException("The registered object of type " + clazz.getName() + " appears to be a dynamically generated proxy, so its type can not be reliably determined. Provide the type explicitly when registering the bean. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#dynamic-proxies");
        }
        if (ClassUtils.isMissingTypeParameters(type)) {
            throw new TypeMappingException("The registered object is of generic type " + type.getTypeName() + ". Provide the full type explicitly when registering the bean. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#generic-top-level-singletons");
        }
        return type;
    }

    private void checkType(AnnotatedType type) {
        if (type == null) {
            throw TypeMappingException.unknownType();
        }
        this.checkType(type.getType());
    }

    private void checkForEmptyOrDuplicates(String extensionType, List<?> extensions) {
        if (extensions.isEmpty()) {
            throw new ConfigurationException("No " + extensionType + "SimpleFieldValidation registered");
        }
        this.checkForDuplicates(extensionType, extensions);
    }

    private <E> void checkForDuplicates(String extensionType, List<E> extensions) {
        HashSet seen = new HashSet();
        extensions.forEach(element -> {
            if (!seen.add(element)) {
                throw new ConfigurationException("Duplicate " + extensionType + " of type " + element.getClass().getName() + " registered");
            }
        });
    }

    private static class DelegatingResolverInterceptorFactory
    implements ResolverInterceptorFactory {
        private final List<ResolverInterceptorFactory> delegates;

        private DelegatingResolverInterceptorFactory(List<ResolverInterceptorFactory> delegates) {
            this.delegates = delegates;
        }

        @Override
        public List<ResolverInterceptor> getInterceptors(ResolverInterceptorFactoryParams params) {
            return this.delegates.stream().flatMap(delegate -> delegate.getInterceptors(params).stream()).collect(Collectors.toList());
        }

        @Override
        public List<ResolverInterceptor> getOuterInterceptors(ResolverInterceptorFactoryParams params) {
            return this.delegates.stream().flatMap(delegate -> delegate.getOuterInterceptors(params).stream()).collect(Collectors.toList());
        }
    }

    private static class GlobalResolverInterceptorFactory
    implements ResolverInterceptorFactory {
        private final List<ResolverInterceptor> earlyInterceptors;
        private final List<ResolverInterceptor> lateInterceptors;

        GlobalResolverInterceptorFactory(List<ResolverInterceptor> earlyInterceptors, List<ResolverInterceptor> lateInterceptors) {
            this.earlyInterceptors = earlyInterceptors;
            this.lateInterceptors = lateInterceptors;
        }

        static GlobalResolverInterceptorFactory early(List<ResolverInterceptor> interceptors) {
            return new GlobalResolverInterceptorFactory(interceptors, Collections.emptyList());
        }

        static GlobalResolverInterceptorFactory late(List<ResolverInterceptor> interceptors) {
            return new GlobalResolverInterceptorFactory(Collections.emptyList(), interceptors);
        }

        @Override
        public List<ResolverInterceptor> getInterceptors(ResolverInterceptorFactoryParams params) {
            return this.earlyInterceptors;
        }

        @Override
        public List<ResolverInterceptor> getOuterInterceptors(ResolverInterceptorFactoryParams params) {
            return this.lateInterceptors;
        }
    }

    private static class MemoizedValueMapperFactory
    implements ValueMapperFactory<ValueMapper> {
        private final ValueMapper defaultValueMapper;
        private final ValueMapperFactory<?> delegate;

        public MemoizedValueMapperFactory(GlobalEnvironment environment, ValueMapperFactory<?> delegate) {
            this.defaultValueMapper = delegate.getValueMapper(Collections.emptyMap(), environment);
            this.delegate = delegate;
        }

        @Override
        public ValueMapper getValueMapper(Map<Class, List<Class<?>>> concreteSubTypes, GlobalEnvironment environment) {
            if (concreteSubTypes.isEmpty() || concreteSubTypes.values().stream().allMatch(List::isEmpty)) {
                return this.defaultValueMapper;
            }
            return this.delegate.getValueMapper(concreteSubTypes, environment);
        }
    }

    private static class NoOpCodeRegistryBuilder
    implements CodeRegistryBuilder {
        private NoOpCodeRegistryBuilder() {
        }
    }

    private static class CodeRegistryMerger
    implements CodeRegistryBuilder {
        private final GraphQLCodeRegistry codeRegistry;

        public CodeRegistryMerger(GraphQLCodeRegistry codeRegistry) {
            this.codeRegistry = codeRegistry;
        }

        @Override
        public TypeResolver getTypeResolver(GraphQLInterfaceType interfaceType) {
            return this.codeRegistry.getTypeResolver(interfaceType);
        }

        @Override
        public TypeResolver getTypeResolver(GraphQLUnionType unionType) {
            return this.codeRegistry.getTypeResolver(unionType);
        }

        @Override
        public DataFetcher<?> getDataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDef) {
            return this.codeRegistry.getDataFetcher(parentType, fieldDef);
        }
    }

    public static interface CodeRegistryBuilder {
        default public TypeResolver getTypeResolver(GraphQLInterfaceType interfaceType) {
            return null;
        }

        default public TypeResolver getTypeResolver(GraphQLUnionType unionType) {
            return null;
        }

        default public DataFetcher<?> getDataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDef) {
            return null;
        }
    }
}

