/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.schema.DataFetchingEnvironment;
import io.leangen.graphql.execution.OperationExecutor;
import io.leangen.graphql.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;

public class BatchLoaderFactory {
    public BatchLoaderWithContext<?, ?> createBatchLoader(OperationExecutor executor) {
        if (executor.getOperation().getArguments().isEmpty()) {
            return (keys, env) -> {
                try {
                    return (CompletionStage)executor.execute(keys, Collections.emptyMap(), env);
                }
                catch (Exception e) {
                    return Utils.failedFuture(e);
                }
            };
        }
        return (keys, env) -> {
            try {
                List<BatchSubTask> subTasks = this.split(keys, env);
                return this.runSubTasks(keys.size(), subTasks, executor);
            }
            catch (Exception e) {
                return Utils.failedFuture(e);
            }
        };
    }

    private List<BatchSubTask> split(List<Object> keys, BatchLoaderEnvironment env) {
        HashMap<Map, BatchSubTask> byArgumentsMap = new HashMap<Map, BatchSubTask>();
        for (int i = 0; i < keys.size(); ++i) {
            Object keyContext = env.getKeyContextsList().get(i);
            Map arguments = keyContext instanceof DataFetchingEnvironment ? ((DataFetchingEnvironment)keyContext).getArguments() : null;
            BatchSubTask kc = byArgumentsMap.computeIfAbsent(arguments, args -> new BatchSubTask((Map<String, Object>)args, env));
            kc.add(i, keys.get(i), keyContext);
        }
        return new ArrayList<BatchSubTask>(byArgumentsMap.values());
    }

    private CompletableFuture<List<Object>> runSubTasks(int totalSize, List<BatchSubTask> tasks, OperationExecutor executor) throws Exception {
        CompletableFuture[] futures = new CompletableFuture[tasks.size()];
        for (int i = 0; i < tasks.size(); ++i) {
            BatchSubTask task = tasks.get(i);
            futures[i] = task.result = ((CompletionStage)executor.execute(task.keys, task.arguments, task.newBatchLoaderEnvironment())).toCompletableFuture();
        }
        return CompletableFuture.allOf(futures).thenApply(__ -> this.mergeResults(totalSize, tasks));
    }

    private List<Object> mergeResults(int totalSize, List<BatchSubTask> tasks) {
        Object[] result = new Object[totalSize];
        for (BatchSubTask task : tasks) {
            List<Object> partResult = task.result.join();
            for (int i = 0; i < task.indexes.size(); ++i) {
                result[task.indexes.get((int)i).intValue()] = partResult.get(i);
            }
        }
        return Arrays.asList(result);
    }

    private static class BatchSubTask {
        final List<Object> keys = new ArrayList<Object>();
        final List<Object> keyContexts = new ArrayList<Object>();
        final List<Integer> indexes = new ArrayList<Integer>();
        final Map<String, Object> arguments;
        CompletableFuture<List<Object>> result;
        private final BatchLoaderEnvironment env;

        public BatchSubTask(Map<String, Object> arguments, BatchLoaderEnvironment env) {
            this.arguments = arguments;
            this.env = env;
        }

        void add(Integer index, Object key, Object keyContext) {
            this.indexes.add(index);
            this.keys.add(key);
            this.keyContexts.add(keyContext);
        }

        BatchLoaderEnvironment newBatchLoaderEnvironment() {
            return BatchLoaderEnvironment.newBatchLoaderEnvironment().context(this.env.getContext()).keyContexts(this.keys, this.keyContexts).build();
        }
    }
}

