/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.OperationExecutor;
import io.leangen.graphql.generator.BatchLoaderFactory;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.generator.RelayDataFetchingEnvironmentDecorator;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.generator.Validator;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.TypeMappingEnvironment;
import io.leangen.graphql.metadata.Directive;
import io.leangen.graphql.metadata.DirectiveArgument;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.MappingException;
import io.leangen.graphql.metadata.strategy.query.DirectiveBuilderParams;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.ContextUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoaderWithContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMapper {
    private final List<GraphQLFieldDefinition> queries;
    private final List<GraphQLFieldDefinition> mutations;
    private final List<GraphQLFieldDefinition> subscriptions;
    private final Collection<GraphQLDirective> directives;
    private final Map<String, GraphQLDirective> discoveredDirectives = new HashMap<String, GraphQLDirective>();
    private final List<GraphQLAppliedDirective> schemaDirectives;
    private final Map<String, BatchLoaderWithContext<?, ?>> batchResolvers = new HashMap();
    private final BatchLoaderFactory batchloaderFactory = new BatchLoaderFactory();
    private static final Logger log = LoggerFactory.getLogger(OperationMapper.class);

    public OperationMapper(String queryRoot, String mutationRoot, String subscriptionRoot, BuildContext buildContext) {
        this.registerDirectiveDefinitions(buildContext);
        this.queries = this.generateQueries(queryRoot, buildContext);
        this.mutations = this.generateMutations(mutationRoot, buildContext);
        this.subscriptions = this.generateSubscriptions(subscriptionRoot, buildContext);
        this.schemaDirectives = this.generateSchemaDirectives(buildContext);
        this.directives = this.discoveredDirectives.values();
        buildContext.resolveTypeReferences();
    }

    private List<GraphQLFieldDefinition> generateQueries(String queryRoot, BuildContext buildContext) {
        Map<String, String> nodeQueriesByType;
        ArrayList<Operation> rootQueries = new ArrayList<Operation>(buildContext.operationRegistry.getRootQueries());
        List<GraphQLFieldDefinition> queries = rootQueries.stream().map(query -> this.toGraphQLField(queryRoot, (Operation)query, buildContext)).collect(Collectors.toList());
        buildContext.resolveTypeReferences();
        if (rootQueries.stream().noneMatch(query -> query.getName().equals("node")) && !(nodeQueriesByType = this.getNodeQueriesByType(rootQueries, queries, buildContext.typeRegistry, buildContext.node, buildContext)).isEmpty()) {
            queries.add(buildContext.relay.nodeField(buildContext.node, this.createNodeResolver(nodeQueriesByType, buildContext.relay)));
        }
        return queries;
    }

    private List<GraphQLFieldDefinition> generateMutations(String mutationRoot, BuildContext buildContext) {
        ArrayList<GraphQLFieldDefinition> mutations = new ArrayList<GraphQLFieldDefinition>();
        for (Operation mutation : buildContext.operationRegistry.getMutations()) {
            GraphQLFieldDefinition mutationField;
            if (buildContext.relayMappingConfig.relayCompliantMutations) {
                mutationField = this.toRelayMutation(mutationRoot, this.toGraphQLField(mutation, buildContext), this.createResolver(mutationRoot, mutation, buildContext), buildContext);
                buildContext.typeRegistry.registerMapping(FieldCoordinates.coordinates((String)mutationRoot, (String)mutationField.getName()), mutation);
            } else {
                mutationField = this.toGraphQLField(mutationRoot, mutation, buildContext);
            }
            mutations.add(mutationField);
        }
        return mutations;
    }

    private List<GraphQLFieldDefinition> generateSubscriptions(String subscriptionRoot, BuildContext buildContext) {
        return buildContext.operationRegistry.getSubscriptions().stream().map(subscription -> this.toGraphQLField(subscriptionRoot, (Operation)subscription, buildContext)).collect(Collectors.toList());
    }

    private void registerDirectiveDefinitions(BuildContext buildContext) {
        buildContext.additionalDirectives.stream().map(directiveType -> {
            List<Class<?>> concreteSubTypes = ClassUtils.isAbstract(directiveType) ? buildContext.abstractInputHandler.findConcreteSubTypes(ClassUtils.getRawType(directiveType.getType()), buildContext) : Collections.emptyList();
            return buildContext.directiveBuilder.buildClientDirective((AnnotatedType)directiveType, buildContext.directiveBuilderParams(concreteSubTypes));
        }).forEach(directive -> this.registerDirectiveDefinition((Directive)directive, buildContext));
    }

    private List<GraphQLAppliedDirective> generateSchemaDirectives(BuildContext buildContext) {
        return buildContext.operationRegistry.getOperationSourceTypes().stream().flatMap(sourceType -> buildContext.directiveBuilder.buildSchemaDirectives((AnnotatedType)sourceType, buildContext.directiveBuilderParams()).stream()).map(directive -> this.toGraphQLAppliedDirective((Directive)directive, buildContext)).collect(Collectors.toList());
    }

    private GraphQLFieldDefinition toGraphQLField(Operation operation, BuildContext buildContext) {
        GraphQLOutputType type = this.toGraphQLType(operation.getJavaType(), new TypeMappingEnvironment(operation.getTypedElement(), this, buildContext));
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription()).deprecate(operation.getDeprecationReason()).type(type);
        this.toGraphQLAppliedDirectives(operation.getTypedElement(), buildContext.directiveBuilder::buildFieldDefinitionDirectives, buildContext).forEach(arg_0 -> ((GraphQLFieldDefinition.Builder)fieldBuilder).withAppliedDirective(arg_0));
        List<GraphQLArgument> arguments = operation.getArguments().stream().filter(OperationArgument::isMappable).map(argument -> this.toGraphQLArgument((OperationArgument)argument, buildContext)).collect(Collectors.toList());
        fieldBuilder.arguments(arguments);
        if (GraphQLUtils.isRelayConnectionType((GraphQLType)type) && buildContext.relayMappingConfig.strictConnectionSpec) {
            this.validateConnectionSpecCompliance(operation.getName(), arguments, buildContext.relay);
        }
        return buildContext.transformers.transform(fieldBuilder.build(), operation, this, buildContext);
    }

    public GraphQLFieldDefinition toGraphQLField(String parentType, Operation operation, BuildContext buildContext) {
        GraphQLFieldDefinition field = this.toGraphQLField(operation, buildContext);
        DataFetcher<?> resolver = this.createResolver(parentType, operation, buildContext);
        FieldCoordinates coordinates = FieldCoordinates.coordinates((String)parentType, (String)field.getName());
        buildContext.typeRegistry.registerMapping(coordinates, operation);
        buildContext.codeRegistry.dataFetcher(coordinates, resolver);
        return field;
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, TypeMappingEnvironment env) {
        return this.toGraphQLType(javaType, new HashSet<Class<? extends TypeMapper>>(), env);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, TypeMappingEnvironment env) {
        env.addType(javaType);
        GraphQLOutputType type = env.buildContext.typeMappers.getTypeMapper((AnnotatedElement)env.rootElement, javaType, mappersToSkip).toGraphQLType(javaType, mappersToSkip, env);
        this.log(env.buildContext.validator.checkUniqueness(type, (AnnotatedElement)env.rootElement, javaType));
        env.buildContext.typeCache.completeType(type);
        return type;
    }

    public GraphQLInputObjectField toGraphQLInputField(InputField inputField, BuildContext buildContext) {
        GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(inputField.getName()).description(inputField.getDescription()).type(this.toGraphQLInputType(inputField.getJavaType(), new TypeMappingEnvironment(inputField.getTypedElement(), this, buildContext)));
        this.toGraphQLAppliedDirectives(inputField.getTypedElement(), buildContext.directiveBuilder::buildInputFieldDefinitionDirectives, buildContext).forEach(arg_0 -> ((GraphQLInputObjectField.Builder)builder).withAppliedDirective(arg_0));
        if (inputField.getDefaultValue().isSet()) {
            builder.defaultValueProgrammatic(inputField.getDefaultValue().getValue());
        }
        return buildContext.transformers.transform(builder.build(), inputField, this, buildContext);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, TypeMappingEnvironment env) {
        return this.toGraphQLInputType(javaType, new HashSet<Class<? extends TypeMapper>>(), env);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, TypeMappingEnvironment env) {
        env.addType(javaType);
        GraphQLInputType type = env.buildContext.typeMappers.getTypeMapper((AnnotatedElement)env.rootElement, javaType, mappersToSkip).toGraphQLInputType(javaType, mappersToSkip, env);
        this.log(env.buildContext.validator.checkUniqueness(type, (AnnotatedElement)env.rootElement, javaType));
        return type;
    }

    private GraphQLArgument toGraphQLArgument(OperationArgument operationArgument, BuildContext buildContext) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(operationArgument.getName()).description(operationArgument.getDescription()).type(this.toGraphQLInputType(operationArgument.getJavaType(), new TypeMappingEnvironment(operationArgument.getTypedElement(), this, buildContext)));
        this.toGraphQLAppliedDirectives(operationArgument.getTypedElement(), buildContext.directiveBuilder::buildArgumentDefinitionDirectives, buildContext).forEach(arg_0 -> ((GraphQLArgument.Builder)builder).withAppliedDirective(arg_0));
        if (operationArgument.getDefaultValue().isSet()) {
            builder.defaultValueProgrammatic(operationArgument.getDefaultValue().getValue());
        }
        return buildContext.transformers.transform(builder.build(), operationArgument, this, buildContext);
    }

    private List<GraphQLAppliedDirective> toGraphQLAppliedDirectives(TypedElement element, BiFunction<AnnotatedElement, DirectiveBuilderParams, List<Directive>> directiveBuilder, BuildContext buildContext) {
        return element.getElements().stream().flatMap(el -> ((List)directiveBuilder.apply((AnnotatedElement)el, buildContext.directiveBuilderParams())).stream()).map(directive -> this.toGraphQLAppliedDirective((Directive)directive, buildContext)).collect(Collectors.toList());
    }

    private void registerDirectiveDefinition(Directive directive, BuildContext buildContext) {
        if (!this.discoveredDirectives.containsKey(directive.getName())) {
            this.discoveredDirectives.put(directive.getName(), this.toGraphQLDirective(directive, buildContext));
        }
    }

    public GraphQLDirective toGraphQLDirective(Directive directive, BuildContext buildContext) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(directive.getDescription()).repeatable(directive.isRepeatable()).validLocations(directive.getLocations());
        directive.getArguments().forEach(arg -> builder.argument(this.toGraphQLArgument((DirectiveArgument)arg, buildContext)));
        return buildContext.transformers.transform(builder.build(), directive, this, buildContext);
    }

    public GraphQLAppliedDirective toGraphQLAppliedDirective(Directive directive, BuildContext buildContext) {
        this.registerDirectiveDefinition(directive, buildContext);
        GraphQLAppliedDirective.Builder builder = (GraphQLAppliedDirective.Builder)((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name(directive.getName())).description(directive.getDescription());
        directive.getArguments().forEach(arg -> builder.argument(this.toGraphQLAppliedDirectiveArgument((DirectiveArgument)arg, buildContext)));
        return buildContext.transformers.transform(builder.build(), directive, this, buildContext);
    }

    private GraphQLArgument toGraphQLArgument(DirectiveArgument directiveArgument, BuildContext buildContext) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(directiveArgument.getName()).description(directiveArgument.getDescription()).type(this.toGraphQLInputType(directiveArgument.getJavaType(), new TypeMappingEnvironment(directiveArgument.getTypedElement(), this, buildContext)));
        this.toGraphQLAppliedDirectives(directiveArgument.getTypedElement(), buildContext.directiveBuilder::buildArgumentDefinitionDirectives, buildContext).forEach(arg_0 -> ((GraphQLArgument.Builder)builder).withAppliedDirective(arg_0));
        if (directiveArgument.getDefaultValue().isSet()) {
            builder.defaultValueProgrammatic(directiveArgument.getDefaultValue().getValue());
        }
        return buildContext.transformers.transform(builder.build(), directiveArgument, this, buildContext);
    }

    private GraphQLAppliedDirectiveArgument toGraphQLAppliedDirectiveArgument(DirectiveArgument directiveArgument, BuildContext buildContext) {
        GraphQLAppliedDirectiveArgument.Builder builder = ((GraphQLAppliedDirectiveArgument.Builder)((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(directiveArgument.getName())).description(directiveArgument.getDescription())).type(this.toGraphQLInputType(directiveArgument.getJavaType(), new TypeMappingEnvironment(directiveArgument.getTypedElement(), this, buildContext))).valueProgrammatic(directiveArgument.getValue());
        return buildContext.transformers.transform(builder.build(), directiveArgument, this, buildContext);
    }

    private GraphQLFieldDefinition toRelayMutation(String parentType, GraphQLFieldDefinition mutation, DataFetcher<?> resolver, BuildContext buildContext) {
        List<GraphQLFieldDefinition> outputFields;
        String payloadTypeName = mutation.getName() + "Payload";
        if (mutation.getType() instanceof GraphQLObjectType) {
            outputFields = ((GraphQLObjectType)mutation.getType()).getFieldDefinitions();
        } else {
            outputFields = new ArrayList();
            outputFields.add(GraphQLFieldDefinition.newFieldDefinition().name(buildContext.relayMappingConfig.wrapperFieldName).description(buildContext.relayMappingConfig.wrapperFieldDescription).type(mutation.getType()).build());
            DataFetcher wrapperFieldResolver = DataFetchingEnvironment::getSource;
            buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)payloadTypeName, (String)buildContext.relayMappingConfig.wrapperFieldName), wrapperFieldResolver);
        }
        List inputFields = mutation.getArguments().stream().map(arg -> {
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType());
            if (arg.hasSetDefaultValue()) {
                builder.defaultValueProgrammatic(arg.getArgumentDefaultValue().getValue());
            }
            return builder.build();
        }).collect(Collectors.toList());
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(mutation.getName() + "Input").field(GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type((GraphQLInputType)Scalars.GraphQLString)).fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(payloadTypeName).field(GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type((GraphQLOutputType)Scalars.GraphQLString)).fields(outputFields).build();
        DataFetcher clientMutationIdResolver = env -> {
            if (ContextUtils.isDefault(env.getContext())) {
                return ContextUtils.getClientMutationId(env.getContext());
            }
            return (String)new PropertyDataFetcher("clientMutationId").get(env);
        };
        buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)payloadTypeName, (String)"clientMutationId"), clientMutationIdResolver);
        GraphQLFieldDefinition relayMutation = GraphQLFieldDefinition.newFieldDefinition().name(mutation.getName()).type((GraphQLOutputType)outputType).argument(GraphQLArgument.newArgument().name("input").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)inputObjectType))).build();
        DataFetcher wrappedResolver = env -> {
            RelayDataFetchingEnvironmentDecorator innerEnv = new RelayDataFetchingEnvironmentDecorator(env);
            ContextUtils.setClientMutationId(env.getContext(), (String)innerEnv.getArgument("clientMutationId"));
            return resolver.get((DataFetchingEnvironment)innerEnv);
        };
        buildContext.codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)parentType, (String)relayMutation.getName()), wrappedResolver);
        return relayMutation;
    }

    private DataFetcher<?> createResolver(String parentType, Operation operation, BuildContext buildContext) {
        Stream<AnnotatedType> inputTypes = operation.getArguments().stream().filter(OperationArgument::isMappable).map(OperationArgument::getJavaType);
        ValueMapper valueMapper = buildContext.createValueMapper(inputTypes);
        OperationExecutor executor = new OperationExecutor(operation, valueMapper, buildContext.globalEnvironment, buildContext.interceptorFactory);
        if (operation.isBatched()) {
            String loaderName = parentType + ':' + operation.getName();
            BatchLoaderWithContext<?, ?> batchLoader = this.batchloaderFactory.createBatchLoader(executor);
            this.batchResolvers.put(loaderName, batchLoader);
            return env -> env.getDataLoader(loaderName).load(env.getSource(), (Object)env);
        }
        return executor;
    }

    private DataFetcher<?> createNodeResolver(Map<String, String> nodeQueriesByType, Relay relay) {
        return env -> {
            String typeName;
            try {
                typeName = relay.fromGlobalId((String)env.getArgument("id")).getType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(env.getArgument("id") + " is not a valid Relay node ID");
            }
            if (!nodeQueriesByType.containsKey(typeName)) {
                throw new IllegalArgumentException(typeName + " is not a Relay node type or no registered query can fetch it by ID");
            }
            GraphQLObjectType queryRoot = env.getGraphQLSchema().getQueryType();
            GraphQLFieldDefinition nodeQueryForType = queryRoot.getFieldDefinition((String)nodeQueriesByType.get(typeName));
            return env.getGraphQLSchema().getCodeRegistry().getDataFetcher((GraphQLFieldsContainer)queryRoot, nodeQueryForType).get(env);
        };
    }

    private Map<String, String> getNodeQueriesByType(List<Operation> queries, List<GraphQLFieldDefinition> graphQLQueries, TypeRegistry typeRegistry, GraphQLInterfaceType node, BuildContext buildContext) {
        HashMap<String, String> nodeQueriesByType = new HashMap<String, String>();
        for (int i = 0; i < queries.size(); ++i) {
            GraphQLType unwrappedQueryType;
            Operation query = queries.get(i);
            GraphQLFieldDefinition graphQLQuery = graphQLQueries.get(i);
            if (graphQLQuery.getArgument("id") == null || !GraphQLUtils.isRelayId(graphQLQuery.getArgument("id")) || query.getResolver("id") == null || !((unwrappedQueryType = GraphQLUtils.unwrapNonNull((GraphQLType)graphQLQuery.getType())) instanceof GraphQLNamedType)) continue;
            GraphQLNamedOutputType unwrappedOutput = (GraphQLNamedOutputType)unwrappedQueryType;
            if ((unwrappedQueryType = buildContext.typeCache.resolveType(unwrappedOutput.getName())) instanceof GraphQLObjectType && ((GraphQLObjectType)unwrappedQueryType).getInterfaces().contains(node)) {
                nodeQueriesByType.put(unwrappedOutput.getName(), query.getName());
                continue;
            }
            if (unwrappedQueryType instanceof GraphQLInterfaceType) {
                typeRegistry.getOutputTypes(unwrappedOutput.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
                continue;
            }
            if (!(unwrappedQueryType instanceof GraphQLUnionType)) continue;
            typeRegistry.getOutputTypes(unwrappedOutput.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).filter(typeRegistry::isMappedType).filter(implementation -> GenericTypeReflector.isSuperType((Type)query.getResolver("id").getReturnType().getType(), (Type)typeRegistry.getMappedType((GraphQLNamedType)implementation).getType())).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
        }
        return nodeQueriesByType;
    }

    private void log(Validator.ValidationResult result) {
        if (!result.isValid()) {
            log.warn(result.getMessage());
        }
    }

    private void validateConnectionSpecCompliance(String operationName, List<GraphQLArgument> arguments, Relay relay) {
        String errorMessageTemplate = "Operation '" + operationName + "' is incompatible with the Relay Connection spec due to %s. If this is intentional, disable strict compliance checking. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#relay-connection-spec-violation";
        boolean forwardPageSupported = relay.getForwardPaginationConnectionFieldArguments().stream().allMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName())));
        boolean backwardPageSupported = relay.getBackwardPaginationConnectionFieldArguments().stream().allMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName())));
        if (!forwardPageSupported && !backwardPageSupported) {
            throw new MappingException(String.format(errorMessageTemplate, "required arguments missing"));
        }
        if (relay.getConnectionFieldArguments().stream().anyMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName()) && !GraphQLUtils.unwrap((GraphQLType)arg.getType()).getName().equals(GraphQLUtils.name((GraphQLSchemaElement)specArg.getType()))))) {
            throw new MappingException(String.format(errorMessageTemplate, "argument type mismatch"));
        }
    }

    public List<GraphQLFieldDefinition> getQueries() {
        return this.queries;
    }

    public List<GraphQLFieldDefinition> getMutations() {
        return this.mutations;
    }

    public List<GraphQLFieldDefinition> getSubscriptions() {
        return this.subscriptions;
    }

    public Collection<GraphQLDirective> getDirectives() {
        return this.directives;
    }

    public List<GraphQLAppliedDirective> getSchemaDirectives() {
        return this.schemaDirectives;
    }

    public Map<String, BatchLoaderWithContext<?, ?>> getBatchResolvers() {
        return this.batchResolvers;
    }
}

