/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.mapping.TypeMappingEnvironment;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.metadata.Directive;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.TypeDiscriminatorField;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilderParams;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ObjectTypeMapper
extends CachingMapper<GraphQLObjectType, GraphQLInputObjectType> {
    @Override
    public GraphQLObjectType toGraphQLType(String typeName, AnnotatedType javaType, TypeMappingEnvironment env) {
        BuildContext buildContext = env.buildContext;
        GraphQLObjectType.Builder typeBuilder = GraphQLObjectType.newObject().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType, buildContext.messageBundle));
        List<GraphQLFieldDefinition> fields = this.getFields(typeName, javaType, env);
        fields.forEach(arg_0 -> ((GraphQLObjectType.Builder)typeBuilder).field(arg_0));
        List<GraphQLNamedOutputType> interfaces = this.getInterfaces(javaType, fields, env);
        interfaces.forEach(inter -> {
            if (inter instanceof GraphQLInterfaceType) {
                typeBuilder.withInterface((GraphQLInterfaceType)inter);
            } else {
                typeBuilder.withInterface((GraphQLTypeReference)inter);
            }
        });
        buildContext.directiveBuilder.buildObjectTypeDirectives(javaType, buildContext.directiveBuilderParams()).forEach(directive -> {
            GraphQLObjectType.Builder cfr_ignored_0 = (GraphQLObjectType.Builder)typeBuilder.withAppliedDirective(env.operationMapper.toGraphQLAppliedDirective((Directive)directive, buildContext));
        });
        typeBuilder.comparatorRegistry(buildContext.comparatorRegistry(javaType));
        GraphQLObjectType type = typeBuilder.build();
        interfaces.forEach(inter -> buildContext.typeRegistry.registerCovariantType(inter.getName(), javaType, (GraphQLNamedOutputType)type));
        buildContext.typeRegistry.registerMapping(type.getName(), javaType);
        return type;
    }

    @Override
    public GraphQLInputObjectType toGraphQLInputType(String typeName, AnnotatedType javaType, TypeMappingEnvironment env) {
        BuildContext buildContext = env.buildContext;
        GraphQLInputObjectType.Builder typeBuilder = GraphQLInputObjectType.newInputObject().name(typeName).description(buildContext.typeInfoGenerator.generateInputTypeDescription(javaType, buildContext.messageBundle));
        InputFieldBuilderParams params = InputFieldBuilderParams.builder().withType(javaType).withEnvironment(buildContext.globalEnvironment).withConcreteSubTypes(buildContext.abstractInputHandler.findConcreteSubTypes(ClassUtils.getRawType(javaType.getType()), buildContext)).build();
        buildContext.inputFieldBuilder.getInputFields(params).forEach(field -> typeBuilder.field(env.operationMapper.toGraphQLInputField((InputField)field, buildContext)));
        if (ClassUtils.isAbstract(javaType)) {
            this.getTypeDiscriminatorField(params, buildContext).ifPresent(arg_0 -> ((GraphQLInputObjectType.Builder)typeBuilder).field(arg_0));
        }
        buildContext.directiveBuilder.buildInputObjectTypeDirectives(javaType, buildContext.directiveBuilderParams()).forEach(directive -> {
            GraphQLInputObjectType.Builder cfr_ignored_0 = (GraphQLInputObjectType.Builder)typeBuilder.withAppliedDirective(env.operationMapper.toGraphQLAppliedDirective((Directive)directive, buildContext));
        });
        typeBuilder.comparatorRegistry(buildContext.comparatorRegistry(javaType));
        GraphQLInputObjectType type = typeBuilder.build();
        buildContext.typeRegistry.registerMapping(type.getName(), javaType);
        return type;
    }

    @Override
    public boolean supports(AnnotatedElement element, AnnotatedType type) {
        return true;
    }

    protected List<GraphQLFieldDefinition> getFields(String typeName, AnnotatedType javaType, TypeMappingEnvironment env) {
        return env.buildContext.operationRegistry.getChildQueries(javaType).stream().map(childQuery -> env.operationMapper.toGraphQLField(typeName, (Operation)childQuery, env.buildContext)).collect(Collectors.toList());
    }

    protected List<GraphQLNamedOutputType> getInterfaces(AnnotatedType javaType, List<GraphQLFieldDefinition> fields, TypeMappingEnvironment env) {
        BuildContext buildContext = env.buildContext;
        ArrayList<GraphQLNamedOutputType> interfaces = new ArrayList<GraphQLNamedOutputType>();
        if (buildContext.relayMappingConfig.inferNodeInterface && fields.stream().anyMatch(GraphQLUtils::isRelayId)) {
            interfaces.add((GraphQLNamedOutputType)buildContext.node);
        }
        buildContext.interfaceStrategy.getInterfaces(javaType).forEach(inter -> interfaces.add((GraphQLNamedOutputType)env.operationMapper.toGraphQLType((AnnotatedType)inter, env)));
        return interfaces;
    }

    protected Optional<GraphQLInputObjectField> getTypeDiscriminatorField(InputFieldBuilderParams params, BuildContext buildContext) {
        return Optional.ofNullable(buildContext.inputFieldBuilder.getTypeDiscriminatorField(params)).map(discriminator -> GraphQLInputObjectField.newInputObjectField().name(discriminator.getName()).description(discriminator.getDescription()).type(this.getDiscriminatorFieldType((TypeDiscriminatorField)discriminator, params.getType(), buildContext)).build());
    }

    private GraphQLInputType getDiscriminatorFieldType(TypeDiscriminatorField discriminator, AnnotatedType type, BuildContext buildContext) {
        Class raw = ClassUtils.getRawType(type.getType());
        String typeName = buildContext.typeInfoGenerator.generateTypeName(GenericTypeReflector.annotate(raw), buildContext.messageBundle) + "TypeDisambiguator";
        if (buildContext.typeCache.contains(typeName)) {
            return GraphQLTypeReference.typeRef((String)typeName);
        }
        buildContext.typeCache.register(typeName);
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(typeName).description("Input type discriminator");
        Arrays.stream(discriminator.getValues()).forEach(arg_0 -> ((GraphQLEnumType.Builder)builder).value(arg_0));
        return builder.build();
    }
}

