/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import graphql.language.OperationDefinition;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class Operation {
    private final String name;
    private final String description;
    private final String deprecationReason;
    private final TypedElement typedElement;
    private final Type contextType;
    private final Map<String, Resolver> resolversByFingerprint;
    private final List<OperationArgument> arguments;
    private final OperationDefinition.Operation operationType;
    private final boolean batched;
    private final boolean async;

    public Operation(String name, AnnotatedType javaType, Type contextType, List<OperationArgument> arguments, List<Resolver> resolvers, OperationDefinition.Operation operationType, boolean batched, boolean async) {
        if (!resolvers.stream().allMatch(Resolver::isBatched) && !resolvers.stream().noneMatch(Resolver::isBatched)) {
            throw new IllegalArgumentException("Operation \"" + name + "\" mixes regular and batched resolvers");
        }
        this.name = name;
        this.description = resolvers.stream().map(Resolver::getOperationDescription).filter(Utils::isNotEmpty).findFirst().orElse(null);
        this.deprecationReason = resolvers.stream().map(Resolver::getOperationDeprecationReason).filter(Objects::nonNull).findFirst().orElse(null);
        this.typedElement = new TypedElement(javaType, resolvers.stream().flatMap(resolver -> resolver.getTypedElement().getElements().stream()).distinct().collect(Collectors.toList()));
        this.contextType = contextType;
        this.resolversByFingerprint = this.collectResolversByFingerprint(resolvers);
        this.arguments = arguments;
        this.operationType = operationType;
        this.batched = batched;
        this.async = async;
    }

    public Operation unbatch() {
        return this.batched ? new UnbatchedOperation(this) : this;
    }

    private Map<String, Resolver> collectResolversByFingerprint(List<Resolver> resolvers) {
        HashMap<String, Resolver> resolversByFingerprint = new HashMap<String, Resolver>();
        resolvers.forEach(resolver -> resolversByFingerprint.putIfAbsent(resolver.getFingerprint(), (Resolver)resolver));
        return resolversByFingerprint;
    }

    public Resolver getApplicableResolver(Set<String> argumentNames) {
        if (this.resolversByFingerprint.size() == 1) {
            return this.getResolvers().iterator().next();
        }
        return this.resolversByFingerprint.get(this.getFingerprint(argumentNames));
    }

    public Resolver getResolver(String ... argumentNames) {
        return this.resolversByFingerprint.get(this.getFingerprint(new HashSet<String>(Arrays.asList(argumentNames))));
    }

    public boolean isEmbeddableForType(Type type) {
        return this.contextType != null && GenericTypeReflector.isSuperType((Type)this.contextType, (Type)type);
    }

    public boolean isRoot() {
        return this.contextType == null;
    }

    private String getFingerprint(Set<String> argumentNames) {
        StringBuilder fingerPrint = new StringBuilder();
        argumentNames.stream().sorted().forEach(fingerPrint::append);
        return fingerPrint.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public AnnotatedType getJavaType() {
        return this.typedElement.getJavaType();
    }

    public List<OperationArgument> getArguments() {
        return this.arguments;
    }

    public Collection<Resolver> getResolvers() {
        return this.resolversByFingerprint.values();
    }

    public OperationDefinition.Operation getOperationType() {
        return this.operationType;
    }

    public boolean isBatched() {
        return this.batched;
    }

    public TypedElement getTypedElement() {
        return this.typedElement;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String toString() {
        return this.name + "(" + this.arguments.stream().map(OperationArgument::getName).collect(Collectors.joining(",")) + ")";
    }

    private static class UnbatchedOperation
    extends Operation {
        private UnbatchedOperation(Operation operation) {
            super(operation.name, UnbatchedOperation.unbatchJavaType(operation.getJavaType(), operation.isAsync()), UnbatchedOperation.unbatchContextType(operation.contextType), operation.arguments, new ArrayList<Resolver>(operation.getResolvers()), operation.getOperationType(), true, operation.isAsync());
        }

        private static AnnotatedType unbatchJavaType(AnnotatedType javaType, boolean async) {
            if (async) {
                javaType = GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, CompletionStage.class.getTypeParameters()[0]);
            }
            return GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, List.class.getTypeParameters()[0]);
        }

        private static Type unbatchContextType(Type contextType) {
            return GenericTypeReflector.getTypeParameter((Type)contextType, List.class.getTypeParameters()[0]);
        }

        @Override
        public Operation unbatch() {
            return this;
        }
    }
}

