/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value;

import io.leangen.graphql.execution.GlobalEnvironment;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class InputFieldBuilderParams {
    private final AnnotatedType type;
    private final GlobalEnvironment environment;
    private final List<Class<?>> concreteSubTypes;

    private InputFieldBuilderParams(AnnotatedType type, GlobalEnvironment environment, List<Class<?>> concreteSubTypes) {
        this.type = Objects.requireNonNull(type);
        this.environment = Objects.requireNonNull(environment);
        this.concreteSubTypes = concreteSubTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AnnotatedType getType() {
        return this.type;
    }

    public GlobalEnvironment getEnvironment() {
        return this.environment;
    }

    public List<Class<?>> getConcreteSubTypes() {
        return this.concreteSubTypes;
    }

    public static class Builder {
        private AnnotatedType type;
        private GlobalEnvironment environment;
        private List<Class<?>> concreteSubTypes = Collections.emptyList();

        public Builder withType(AnnotatedType type) {
            this.type = type;
            return this;
        }

        public Builder withEnvironment(GlobalEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public Builder withConcreteSubTypes(List<Class<?>> concreteSubTypes) {
            this.concreteSubTypes = concreteSubTypes;
            return this;
        }

        public InputFieldBuilderParams build() {
            return new InputFieldBuilderParams(this.type, this.environment, this.concreteSubTypes);
        }
    }
}

