/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.gson;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.GraphQLInputField;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.metadata.DefaultValue;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.TypeDiscriminatorField;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.InputFieldInclusionParams;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilderParams;
import io.leangen.graphql.metadata.strategy.value.InputFieldInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.InputParsingException;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.gson.GsonFieldNamingStrategy;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Scalars;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GsonValueMapper
implements ValueMapper,
InputFieldBuilder {
    private final Gson gson;
    private final InputFieldInfoGenerator inputInfoGen = new InputFieldInfoGenerator();
    private static final Gson NO_CONVERTERS = new Gson();

    GsonValueMapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T fromInput(Object graphQLInput, Type sourceType, AnnotatedType outputType) throws InputParsingException {
        if (graphQLInput.getClass() == outputType.getType()) {
            return (T)graphQLInput;
        }
        try {
            JsonElement jsonElement = NO_CONVERTERS.toJsonTree(graphQLInput, sourceType);
            return (T)this.gson.fromJson(jsonElement, outputType.getType());
        }
        catch (JsonSyntaxException e) {
            throw new InputParsingException(graphQLInput, outputType.getType(), e);
        }
    }

    @Override
    public <T> T fromString(String json, AnnotatedType type) {
        if (json == null || String.class.equals((Object)type.getType())) {
            return (T)json;
        }
        try {
            if (Scalars.isScalar(type.getType()) && !ClassUtils.isPrimitive(type) && !GenericTypeReflector.isBoxType((Type)type.getType())) {
                return (T)Scalars.toGraphQLScalarType(type.getType()).getCoercing().parseValue((Object)json);
            }
            return (T)this.gson.fromJson(json, type.getType());
        }
        catch (JsonSyntaxException e) {
            throw new InputParsingException(json, type.getType(), e);
        }
    }

    @Override
    public String toString(Object output, AnnotatedType type) {
        if (output != null && Scalars.isScalar(type.getType())) {
            output = Scalars.toGraphQLScalarType(type.getType()).getCoercing().serialize(output);
        }
        if (output == null || output instanceof String) {
            return (String)output;
        }
        return this.gson.toJson(output, type.getType());
    }

    @Override
    public Set<InputField> getInputFields(InputFieldBuilderParams params) {
        Map<String, InputField> explicit = this.fromFields(params);
        Map<String, InputField> implicit = this.fromGetters(params);
        HashMap<String, InputField> merged = new HashMap<String, InputField>(explicit);
        implicit.forEach(merged::putIfAbsent);
        return new HashSet<InputField>(merged.values());
    }

    private Map<String, InputField> fromFields(InputFieldBuilderParams params) {
        AnnotatedType type = params.getType();
        Class raw = ClassUtils.getRawType(type.getType());
        if (raw.isInterface() || raw.isPrimitive()) {
            return Collections.emptyMap();
        }
        HashMap<String, InputField> inputFields = new HashMap<String, InputField>();
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                if (this.gson.excluder().excludeClass(field.getType(), false) || this.gson.excluder().excludeField(field, false)) continue;
                List<AnnotatedElement> propertyMembers = ClassUtils.getPropertyMembers(field);
                String fieldName = this.gson.fieldNamingStrategy().translateName(field);
                InputFieldInclusionParams inclusionParams = InputFieldInclusionParams.builder().withType(params.getType()).withElementDeclaringClass(field.getDeclaringClass()).withElements(propertyMembers).withDeserializationInfo(true, this.isDeserializableInSubType(fieldName, this.gson.fieldNamingStrategy(), params.getConcreteSubTypes())).build();
                if (!params.getEnvironment().inclusionStrategy.includeInputField(inclusionParams)) continue;
                TypedElement element = this.reduce(type, field, params.getEnvironment().typeTransformer);
                field.setAccessible(true);
                InputField inputField = new InputField(fieldName, this.getDescription(propertyMembers, params.getEnvironment().messageBundle), element, null, this.defaultValue(propertyMembers, element.getJavaType(), params.getEnvironment()));
                if (inputFields.containsKey(fieldName)) {
                    throw new IllegalArgumentException(raw + " declares multiple input fields named " + fieldName);
                }
                inputFields.put(fieldName, inputField);
            }
            raw = raw.getSuperclass();
            type = GenericTypeReflector.getExactSuperType((AnnotatedType)type, raw);
        }
        return inputFields;
    }

    private Map<String, InputField> fromGetters(InputFieldBuilderParams params) {
        AnnotatedType type = params.getType();
        Class raw = ClassUtils.getRawType(type.getType());
        GsonFieldNamingStrategy namingStrategy = new GsonFieldNamingStrategy(params.getEnvironment().messageBundle);
        List getters = Arrays.stream(raw.getMethods()).filter(ClassUtils::isGetter).collect(Collectors.toList());
        HashMap<String, InputField> inputFields = new HashMap<String, InputField>();
        for (Method getter : getters) {
            List<AnnotatedElement> propertyMembers;
            if (this.gson.excluder().excludeClass(getter.getReturnType(), false) || (propertyMembers = ClassUtils.getPropertyMembers(getter)).stream().anyMatch(element -> element instanceof Field)) continue;
            String fieldName = namingStrategy.getPropertyName(propertyMembers).orElse(ClassUtils.getFieldNameFromGetter(getter));
            InputFieldInclusionParams inclusionParams = InputFieldInclusionParams.builder().withType(params.getType()).withElementDeclaringClass(getter.getDeclaringClass()).withElements(propertyMembers).withDeserializationInfo(false, this.isDeserializableInSubType(fieldName, this.gson.fieldNamingStrategy(), params.getConcreteSubTypes())).build();
            if (!params.getEnvironment().inclusionStrategy.includeInputField(inclusionParams)) continue;
            TypedElement element2 = this.reduce(type, getter, params.getEnvironment().typeTransformer);
            InputField inputField = new InputField(fieldName, this.getDescription(propertyMembers, params.getEnvironment().messageBundle), element2, null, this.defaultValue(propertyMembers, element2.getJavaType(), params.getEnvironment()));
            if (inputFields.containsKey(fieldName)) {
                throw new IllegalArgumentException(raw + " declares multiple input fields named " + fieldName);
            }
            inputFields.put(fieldName, inputField);
        }
        return inputFields;
    }

    @Override
    public TypeDiscriminatorField getTypeDiscriminatorField(InputFieldBuilderParams params) {
        String[] subTypes = (String[])params.getConcreteSubTypes().stream().map(GenericTypeReflector::annotate).map(impl -> params.getEnvironment().typeInfoGenerator.generateTypeName((AnnotatedType)impl, params.getEnvironment().messageBundle)).toArray(String[]::new);
        if (subTypes.length > 1) {
            return new TypeDiscriminatorField("_type_", "Input type discriminator", subTypes);
        }
        return null;
    }

    protected TypedElement reduce(AnnotatedType declaringType, Field field, TypeTransformer transformer) {
        Optional<TypedElement> fld = Optional.of(this.element(ClassUtils.getFieldType(field, declaringType), field, declaringType, transformer));
        Optional<TypedElement> setter = ClassUtils.findSetter(field.getDeclaringClass(), field.getName(), field.getType()).map(mutator -> this.element(ClassUtils.getParameterTypes(mutator, declaringType)[0], mutator, declaringType, transformer));
        Optional<TypedElement> getter = ClassUtils.findGetter(field.getDeclaringClass(), field.getName()).filter(accessor -> accessor.isAnnotationPresent(GraphQLInputField.class)).map(accessor -> this.element(ClassUtils.getReturnType(accessor, declaringType), accessor, declaringType, transformer));
        return new TypedElement(Utils.flatten(getter, setter, fld).collect(Collectors.toList()));
    }

    protected TypedElement reduce(AnnotatedType declaringType, Method getter, TypeTransformer transformer) {
        Optional<TypedElement> setter = ClassUtils.findSetter(getter.getDeclaringClass(), ClassUtils.getFieldNameFromGetter(getter), getter.getReturnType()).map(mutator -> this.element(ClassUtils.getParameterTypes(mutator, declaringType)[0], mutator, declaringType, transformer));
        Optional<TypedElement> gtr = Optional.of(getter).map(accessor -> this.element(ClassUtils.getReturnType(accessor, declaringType), accessor, declaringType, transformer));
        List<TypedElement> elements = Utils.flatten(gtr, setter).collect(Collectors.toList());
        return new TypedElement(elements);
    }

    protected String getDescription(List<AnnotatedElement> members, MessageBundle messageBundle) {
        return this.inputInfoGen.getDescription(members, messageBundle).orElse(null);
    }

    protected DefaultValue defaultValue(List<AnnotatedElement> members, AnnotatedType fieldType, GlobalEnvironment environment) {
        return this.inputInfoGen.defaultValue(members, fieldType, environment);
    }

    private <T extends Member & AnnotatedElement> TypedElement element(AnnotatedType type, T annotatedMember, AnnotatedType declaringType, TypeTransformer transformer) {
        try {
            return new TypedElement(transformer.transform(type), annotatedMember);
        }
        catch (TypeMappingException e) {
            throw TypeMappingException.ambiguousMemberType(annotatedMember, declaringType, e);
        }
    }

    private boolean isDeserializableInSubType(String fieldName, FieldNamingStrategy namingStrategy, List<Class<?>> concreteSubTypes) {
        return concreteSubTypes.stream().anyMatch(impl -> ClassUtils.findField(impl, field -> namingStrategy.translateName(field).equals(fieldName)).isPresent());
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return true;
    }
}

