/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.relay.Relay;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.TypeResolver;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.generator.DelegatingTypeResolver;
import io.leangen.graphql.generator.OperationRegistry;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.RelayNodeTypeResolver;
import io.leangen.graphql.generator.TypeCache;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.generator.Validator;
import io.leangen.graphql.generator.mapping.SchemaTransformerRegistry;
import io.leangen.graphql.generator.mapping.TypeMapperRegistry;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.ImplementationDiscoveryStrategy;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.DirectiveBuilder;
import io.leangen.graphql.metadata.strategy.query.DirectiveBuilderParams;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.InputFieldBuilder;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.util.ClassFinder;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BuildContext {
    public final GlobalEnvironment globalEnvironment;
    public final OperationRegistry operationRegistry;
    public final TypeRegistry typeRegistry;
    public final TypeCache typeCache;
    public final TypeMapperRegistry typeMappers;
    public final SchemaTransformerRegistry transformers;
    public final Relay relay;
    public final GraphQLInterfaceType node;
    public final TypeResolver typeResolver;
    public final InterfaceMappingStrategy interfaceStrategy;
    public final String[] basePackages;
    public final MessageBundle messageBundle;
    public final ValueMapperFactory<?> valueMapperFactory;
    public final InputFieldBuilder inputFieldBuilder;
    public final InclusionStrategy inclusionStrategy;
    public final ScalarDeserializationStrategy scalarStrategy;
    public final TypeTransformer typeTransformer;
    public final AbstractInputHandler abstractInputHandler;
    public final ImplementationDiscoveryStrategy implDiscoveryStrategy;
    public final TypeInfoGenerator typeInfoGenerator;
    public final ResolverInterceptorFactory interceptorFactory;
    public final DirectiveBuilder directiveBuilder;
    public final RelayMappingConfig relayMappingConfig;
    public final ClassFinder classFinder;
    public final List<Consumer<BuildContext>> postBuildHooks;
    public final List<AnnotatedType> additionalDirectives;
    public final GraphQLCodeRegistry.Builder codeRegistry;
    final Validator validator;

    public BuildContext(String[] basePackages, GlobalEnvironment environment, OperationRegistry operationRegistry, TypeMapperRegistry typeMappers, SchemaTransformerRegistry transformers, ValueMapperFactory<?> valueMapperFactory, InterfaceMappingStrategy interfaceStrategy, ScalarDeserializationStrategy scalarStrategy, TypeTransformer typeTransformer, AbstractInputHandler abstractInputHandler, InputFieldBuilder inputFieldBuilder, ResolverInterceptorFactory interceptorFactory, DirectiveBuilder directiveBuilder, InclusionStrategy inclusionStrategy, RelayMappingConfig relayMappingConfig, Collection<GraphQLNamedType> knownTypes, List<AnnotatedType> additionalDirectives, Comparator<AnnotatedType> typeComparator, ImplementationDiscoveryStrategy implementationStrategy, GraphQLCodeRegistry.Builder codeRegistry) {
        this.operationRegistry = operationRegistry;
        this.typeRegistry = environment.typeRegistry;
        this.transformers = transformers;
        this.interceptorFactory = interceptorFactory;
        this.directiveBuilder = directiveBuilder;
        this.typeCache = new TypeCache(knownTypes);
        this.additionalDirectives = additionalDirectives;
        this.typeMappers = typeMappers;
        this.typeInfoGenerator = environment.typeInfoGenerator;
        this.messageBundle = environment.messageBundle;
        this.relay = environment.relay;
        this.node = knownTypes.stream().filter(GraphQLUtils::isRelayNodeInterface).findFirst().map(type -> (GraphQLInterfaceType)type).orElse(this.relay.nodeInterface((TypeResolver)new RelayNodeTypeResolver(environment)));
        this.typeResolver = new DelegatingTypeResolver(environment);
        this.interfaceStrategy = interfaceStrategy;
        this.basePackages = basePackages;
        this.valueMapperFactory = valueMapperFactory;
        this.inputFieldBuilder = inputFieldBuilder;
        this.inclusionStrategy = inclusionStrategy;
        this.scalarStrategy = scalarStrategy;
        this.typeTransformer = typeTransformer;
        this.implDiscoveryStrategy = implementationStrategy;
        this.abstractInputHandler = abstractInputHandler;
        this.globalEnvironment = environment;
        this.relayMappingConfig = relayMappingConfig;
        this.classFinder = new ClassFinder();
        this.validator = new Validator(environment, typeMappers, knownTypes, typeComparator);
        this.codeRegistry = codeRegistry;
        this.postBuildHooks = new ArrayList<Consumer<BuildContext>>(Collections.singletonList(context -> this.classFinder.close()));
    }

    public String interpolate(String template) {
        return this.messageBundle.interpolate(template);
    }

    ValueMapper createValueMapper(Stream<AnnotatedType> inputTypes) {
        List abstractTypes = inputTypes.flatMap(input -> this.abstractInputHandler.findConstituentAbstractTypes((AnnotatedType)input, this).stream().map(ClassUtils::getRawType)).distinct().collect(Collectors.toList());
        Map<Class, List<Class<?>>> concreteSubTypes = abstractTypes.stream().collect(Collectors.toMap(Function.identity(), abs -> this.abstractInputHandler.findConcreteSubTypes((Class<?>)abs, this)));
        return this.valueMapperFactory.getValueMapper(concreteSubTypes, this.globalEnvironment);
    }

    public GraphqlTypeComparatorRegistry comparatorRegistry(AnnotatedType type) {
        return this.typeInfoGenerator.generateComparatorRegistry(type, this.messageBundle);
    }

    public DirectiveBuilderParams directiveBuilderParams() {
        return this.directiveBuilderParams(Collections.emptyList());
    }

    public DirectiveBuilderParams directiveBuilderParams(List<Class<?>> concreteSubTypes) {
        return DirectiveBuilderParams.builder().withEnvironment(this.globalEnvironment).withInputFieldBuilder(this.inputFieldBuilder).withConcreteSubTypes(concreteSubTypes).build();
    }

    void resolveTypeReferences() {
        this.typeCache.resolveTypeReferences(this.typeRegistry);
    }

    public void executePostBuildHooks() {
        this.postBuildHooks.forEach(hook -> hook.accept(this));
    }
}

