/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.strategy;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterfaceMappingStrategy
implements InterfaceMappingStrategy {
    private boolean mapClasses = true;
    private boolean ignoreUnresolvable = false;
    private Predicate<Class> filter = Utils.acceptAll();
    private static final Logger log = LoggerFactory.getLogger(AbstractInterfaceMappingStrategy.class);

    protected AbstractInterfaceMappingStrategy() {
    }

    public AbstractInterfaceMappingStrategy withClassMapping(boolean mapClasses) {
        this.mapClasses = mapClasses;
        return this;
    }

    public AbstractInterfaceMappingStrategy withUnresolvableInterfacesIgnored() {
        this.ignoreUnresolvable = true;
        return this;
    }

    @SafeVarargs
    public final AbstractInterfaceMappingStrategy withFilters(Predicate<Class> ... filters) {
        this.filter = this.filter.and(Arrays.stream(filters).reduce(Predicate::and).orElseGet(Utils::acceptAll));
        return this;
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return (this.mapClasses || ClassUtils.getRawType(type.getType()).isInterface()) && this.supportsInterface(type);
    }

    protected abstract boolean supportsInterface(AnnotatedType var1);

    @Override
    public Collection<AnnotatedType> getInterfaces(AnnotatedType type) {
        HashMap interfaces = new HashMap();
        this.collectInterfaces(type, interfaces);
        return interfaces.values();
    }

    private void collectInterfaces(AnnotatedType type, Map<Class<?>, AnnotatedType> interfaces) {
        Class clazz = ClassUtils.getRawType(type.getType());
        if (interfaces.containsKey(clazz)) {
            return;
        }
        if ((clazz.isInterface() || this.mapClasses) && this.supports(type)) {
            interfaces.put(clazz, type);
        }
        Arrays.stream(clazz.getInterfaces()).filter(this.filter).map(inter -> this.getExactSuperType(type, (Class)inter)).filter(Objects::nonNull).forEach(inter -> this.collectInterfaces((AnnotatedType)inter, interfaces));
        Class superClass = clazz.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            this.collectInterfaces(GenericTypeReflector.getExactSuperType((AnnotatedType)type, superClass), interfaces);
        }
    }

    private AnnotatedType getExactSuperType(AnnotatedType type, Class inter) {
        AnnotatedType resolved = GenericTypeReflector.getExactSuperType((AnnotatedType)type, (Class)inter);
        if (resolved == null) {
            if (!this.ignoreUnresolvable) {
                throw TypeMappingException.unresolvableSuperType(inter, type.getType());
            }
            log.warn("Interface {} can not be resolved as a super type of {} so it will be ignored", (Object)inter.getName(), (Object)type.getType().getTypeName());
        }
        return resolved;
    }
}

