/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy;

import io.leangen.graphql.annotations.GraphQLIgnore;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.InputFieldInclusionParams;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class DefaultInclusionStrategy
implements InclusionStrategy {
    private final String[] basePackages;
    private final List<Predicate<AnnotatedElement>> operationElementFilters;

    public DefaultInclusionStrategy(String ... basePackages) {
        this.basePackages = basePackages;
        this.operationElementFilters = new ArrayList<Predicate<AnnotatedElement>>();
    }

    @Override
    public boolean includeOperation(List<AnnotatedElement> elements, AnnotatedType declaringType) {
        return elements.stream().allMatch(element -> ClassUtils.isReal(element) && !this.isIgnored((AnnotatedElement)element) && this.isAccepted((AnnotatedElement)element));
    }

    @Override
    public boolean includeArgument(Parameter parameter, AnnotatedType declaringType) {
        return ClassUtils.isReal(parameter) && !this.isDirectlyIgnored(parameter);
    }

    @Override
    public boolean includeArgumentForMapping(Parameter parameter, AnnotatedType parameterType, AnnotatedType declaringType) {
        return !this.isIgnored(parameter);
    }

    @Override
    public boolean includeInputField(InputFieldInclusionParams params) {
        return params.getElements().stream().noneMatch(this::isIgnored) && (params.isDirectlyDeserializable() || params.isDeserializableInSubType()) && this.isPackageAcceptable(params.getDeclaringType(), params.getElementDeclaringClass());
    }

    protected boolean isPackageAcceptable(AnnotatedType type, Class<?> elementDeclaringClass) {
        Class rawType = ClassUtils.getRawType(type.getType());
        String[] packages = new String[]{};
        if (Utils.isNotEmpty(this.basePackages)) {
            packages = this.basePackages;
        } else if (rawType.getPackage() != null) {
            packages = new String[]{rawType.getPackage().getName()};
        }
        packages = (String[])Arrays.stream(packages).filter(Utils::isNotEmpty).toArray(String[]::new);
        return elementDeclaringClass.equals(rawType) || Arrays.stream(packages).anyMatch(basePackage -> ClassUtils.isSubPackage(elementDeclaringClass.getPackage(), basePackage));
    }

    protected boolean isDirectlyIgnored(AnnotatedElement element) {
        return element.isAnnotationPresent(GraphQLIgnore.class);
    }

    protected boolean isIgnored(AnnotatedElement element) {
        return ClassUtils.hasAnnotation(element, GraphQLIgnore.class);
    }

    public DefaultInclusionStrategy excludeStaticMembers() {
        this.operationElementFilters.add(e -> !Modifier.isStatic(((Member)((Object)e)).getModifiers()));
        return this;
    }

    private boolean isAccepted(AnnotatedElement element) {
        return this.operationElementFilters.stream().allMatch(filter -> filter.test(element));
    }
}

