/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import graphql.relay.Relay;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.extension.ExtensionProvider;
import io.leangen.graphql.extension.GraphQLSchemaProcessor;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.OperationRepository;
import io.leangen.graphql.generator.OperationSourceRepository;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.TypeRepository;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.generator.mapping.ArgumentInjector;
import io.leangen.graphql.generator.mapping.ArgumentInjectorRepository;
import io.leangen.graphql.generator.mapping.ConverterRepository;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.generator.mapping.TypeMapperRepository;
import io.leangen.graphql.generator.mapping.common.ArrayAdapter;
import io.leangen.graphql.generator.mapping.common.ByteArrayToBase64Adapter;
import io.leangen.graphql.generator.mapping.common.CollectionOutputConverter;
import io.leangen.graphql.generator.mapping.common.ContextInjector;
import io.leangen.graphql.generator.mapping.common.EnumMapToObjectTypeAdapter;
import io.leangen.graphql.generator.mapping.common.EnumMapper;
import io.leangen.graphql.generator.mapping.common.EnvironmentInjector;
import io.leangen.graphql.generator.mapping.common.IdAdapter;
import io.leangen.graphql.generator.mapping.common.InputValueDeserializer;
import io.leangen.graphql.generator.mapping.common.InterfaceMapper;
import io.leangen.graphql.generator.mapping.common.ListMapper;
import io.leangen.graphql.generator.mapping.common.NonNullMapper;
import io.leangen.graphql.generator.mapping.common.ObjectScalarAdapter;
import io.leangen.graphql.generator.mapping.common.ObjectTypeMapper;
import io.leangen.graphql.generator.mapping.common.OptionalAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalDoubleAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalIntAdapter;
import io.leangen.graphql.generator.mapping.common.OptionalLongAdapter;
import io.leangen.graphql.generator.mapping.common.PageMapper;
import io.leangen.graphql.generator.mapping.common.RootContextInjector;
import io.leangen.graphql.generator.mapping.common.ScalarMapper;
import io.leangen.graphql.generator.mapping.common.StreamToCollectionTypeAdapter;
import io.leangen.graphql.generator.mapping.common.UnionInlineMapper;
import io.leangen.graphql.generator.mapping.common.UnionTypeMapper;
import io.leangen.graphql.generator.mapping.common.VoidToBooleanTypeAdapter;
import io.leangen.graphql.generator.mapping.core.CompletableFutureMapper;
import io.leangen.graphql.generator.mapping.core.DataFetcherResultMapper;
import io.leangen.graphql.generator.mapping.core.PublisherMapper;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.AnnotatedInterfaceStrategy;
import io.leangen.graphql.generator.mapping.strategy.AutoScanAbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.DefaultImplementationDiscoveryStrategy;
import io.leangen.graphql.generator.mapping.strategy.ImplementationDiscoveryStrategy;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.generator.mapping.strategy.NoOpAbstractInputHandler;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.DefaultInclusionStrategy;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.AnnotatedResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.BeanResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.DefaultOperationBuilder;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeTransformer;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.InputFieldDiscoveryStrategy;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Defaults;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GraphQLSchemaGenerator {
    private InterfaceMappingStrategy interfaceStrategy = new AnnotatedInterfaceStrategy(true);
    private ScalarDeserializationStrategy scalarStrategy;
    private AbstractInputHandler abstractInputHandler = new NoOpAbstractInputHandler();
    private OperationBuilder operationBuilder = new DefaultOperationBuilder(DefaultOperationBuilder.TypeInference.NONE);
    private ValueMapperFactory<?> valueMapperFactory;
    private InputFieldDiscoveryStrategy inputFieldStrategy;
    private InclusionStrategy inclusionStrategy;
    private ImplementationDiscoveryStrategy implDiscoveryStrategy = new DefaultImplementationDiscoveryStrategy();
    private TypeInfoGenerator typeInfoGenerator = new DefaultTypeInfoGenerator();
    private TypeTransformer typeTransformer = new DefaultTypeTransformer(false, false);
    private GlobalEnvironment environment;
    private String[] basePackages;
    private List<TypeMapper> typeMappers;
    private boolean respectJavaDeprecation = true;
    private final OperationSourceRepository operationSourceRepository = new OperationSourceRepository();
    private final Set<ExtensionProvider<TypeMapper>> typeMapperProviders = new LinkedHashSet<ExtensionProvider<TypeMapper>>();
    private final Set<ExtensionProvider<InputConverter>> inputConverterProviders = new LinkedHashSet<ExtensionProvider<InputConverter>>();
    private final Set<ExtensionProvider<OutputConverter>> outputConverterProviders = new LinkedHashSet<ExtensionProvider<OutputConverter>>();
    private final Set<ExtensionProvider<ArgumentInjector>> argumentInjectorProviders = new LinkedHashSet<ExtensionProvider<ArgumentInjector>>();
    private final Set<ExtensionProvider<ResolverBuilder>> resolverBuilderProviders = new LinkedHashSet<ExtensionProvider<ResolverBuilder>>();
    private final Set<ExtensionProvider<ResolverBuilder>> nestedResolverBuilderProviders = new LinkedHashSet<ExtensionProvider<ResolverBuilder>>();
    private final Collection<GraphQLSchemaProcessor> processors = new HashSet<GraphQLSchemaProcessor>();
    private final RelayMappingConfig relayMappingConfig = new RelayMappingConfig();
    private final Set<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
    private final String queryRoot;
    private final String mutationRoot;
    private final String subscriptionRoot;

    public GraphQLSchemaGenerator() {
        this("Query", "Mutation", "Subscription");
    }

    public GraphQLSchemaGenerator(String queryRoot, String mutationRoot, String subscriptionRoot) {
        this.queryRoot = queryRoot;
        this.mutationRoot = mutationRoot;
        this.subscriptionRoot = subscriptionRoot;
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton) {
        this.checkType(serviceSingleton.getClass());
        return this.withOperationsFromSingleton(serviceSingleton, serviceSingleton.getClass());
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, Type beanType) {
        return this.withOperationsFromSingleton(serviceSingleton, GenericTypeReflector.annotate((Type)beanType));
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, AnnotatedType beanType) {
        this.checkType(beanType);
        this.operationSourceRepository.registerOperationSource(serviceSingleton, beanType);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, ResolverBuilder ... builders) {
        return this.withOperationsFromSingleton(serviceSingleton, serviceSingleton.getClass(), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, Type beanType, ResolverBuilder ... builders) {
        this.checkType(beanType);
        return this.withOperationsFromSingleton(serviceSingleton, GenericTypeReflector.annotate((Type)beanType), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromSingleton(Object serviceSingleton, AnnotatedType beanType, ResolverBuilder ... builders) {
        this.checkType(beanType);
        this.operationSourceRepository.registerOperationSource(serviceSingleton, beanType, Arrays.asList(builders));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromSingletons(Object ... serviceSingletons) {
        Arrays.stream(serviceSingletons).forEach(this::withOperationsFromSingleton);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(Type serviceType) {
        return this.withOperationsFromType(GenericTypeReflector.annotate((Type)serviceType));
    }

    public GraphQLSchemaGenerator withOperationsFromType(Type serviceType, ResolverBuilder ... builders) {
        return this.withOperationsFromType(GenericTypeReflector.annotate((Type)serviceType), builders);
    }

    public GraphQLSchemaGenerator withOperationsFromTypes(Type ... serviceType) {
        Arrays.stream(serviceType).forEach(this::withOperationsFromType);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(AnnotatedType serviceType) {
        this.checkType(serviceType);
        this.operationSourceRepository.registerOperationSource(serviceType);
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromType(AnnotatedType serviceType, ResolverBuilder ... builders) {
        this.checkType(serviceType);
        this.operationSourceRepository.registerOperationSource(serviceType, Arrays.asList(builders));
        return this;
    }

    public GraphQLSchemaGenerator withOperationsFromTypes(AnnotatedType ... serviceType) {
        Arrays.stream(serviceType).forEach(this::withOperationsFromType);
        return this;
    }

    public GraphQLSchemaGenerator withNestedOperationsFromTypes(Type ... types) {
        Arrays.stream(types).forEach(x$0 -> this.withNestedResolverBuildersForType((Type)x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withNestedOperationsFromTypes(AnnotatedType ... types) {
        Arrays.stream(types).forEach(x$0 -> this.withNestedResolverBuildersForType((AnnotatedType)x$0, new ResolverBuilder[0]));
        return this;
    }

    public GraphQLSchemaGenerator withNestedResolverBuildersForType(Type querySourceType, ResolverBuilder ... resolverBuilders) {
        return this.withNestedResolverBuildersForType(GenericTypeReflector.annotate((Type)querySourceType), resolverBuilders);
    }

    public GraphQLSchemaGenerator withNestedResolverBuildersForType(AnnotatedType querySourceType, ResolverBuilder ... resolverBuilders) {
        this.operationSourceRepository.registerNestedOperationSource(querySourceType, Arrays.asList(resolverBuilders));
        return this;
    }

    public GraphQLSchemaGenerator withResolverBuilders(ResolverBuilder ... resolverBuilders) {
        this.resolverBuilderProviders.add(this.fixedConfig(resolverBuilders));
        return this;
    }

    public GraphQLSchemaGenerator withResolverBuilders(ExtensionProvider<ResolverBuilder> provider) {
        this.resolverBuilderProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withNestedResolverBuilders(ResolverBuilder ... resolverBuilders) {
        this.nestedResolverBuilderProviders.add(this.fixedConfig(resolverBuilders));
        return this;
    }

    public GraphQLSchemaGenerator withNestedResolverBuilders(ExtensionProvider<ResolverBuilder> provider) {
        this.nestedResolverBuilderProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withAbstractInputTypeResolution() {
        this.abstractInputHandler = new AutoScanAbstractInputHandler();
        return this;
    }

    public GraphQLSchemaGenerator withAbstractInputHandler(AbstractInputHandler abstractInputHandler) {
        this.abstractInputHandler = abstractInputHandler;
        return this;
    }

    public GraphQLSchemaGenerator withBasePackages(String ... basePackages) {
        this.basePackages = basePackages;
        return this;
    }

    public GraphQLSchemaGenerator withJavaDeprecationRespected(boolean respectJavaDeprecation) {
        this.respectJavaDeprecation = respectJavaDeprecation;
        return this;
    }

    public GraphQLSchemaGenerator withTypeInfoGenerator(TypeInfoGenerator typeInfoGenerator) {
        this.typeInfoGenerator = typeInfoGenerator;
        return this;
    }

    public GraphQLSchemaGenerator withValueMapperFactory(ValueMapperFactory<?> valueMapperFactory) {
        this.valueMapperFactory = valueMapperFactory;
        return this;
    }

    public GraphQLSchemaGenerator withInputFieldDiscoveryStrategy(InputFieldDiscoveryStrategy inputFieldStrategy) {
        this.inputFieldStrategy = inputFieldStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withInterfaceMappingStrategy(InterfaceMappingStrategy interfaceStrategy) {
        this.interfaceStrategy = interfaceStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withScalarDeserializationStrategy(ScalarDeserializationStrategy scalarStrategy) {
        this.scalarStrategy = scalarStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withInclusionStrategy(InclusionStrategy inclusionStrategy) {
        this.inclusionStrategy = inclusionStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withImplementationDiscoveryStrategy(ImplementationDiscoveryStrategy implDiscoveryStrategy) {
        this.implDiscoveryStrategy = implDiscoveryStrategy;
        return this;
    }

    public GraphQLSchemaGenerator withTypeTransformer(TypeTransformer transformer) {
        this.typeTransformer = transformer;
        return this;
    }

    public GraphQLSchemaGenerator withTypeMappers(TypeMapper ... typeMappers) {
        this.typeMapperProviders.add(this.fixedConfig(typeMappers));
        return this;
    }

    public GraphQLSchemaGenerator withTypeMappers(ExtensionProvider<TypeMapper> provider) {
        this.typeMapperProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withInputConverters(InputConverter<?, ?> ... inputConverters) {
        this.inputConverterProviders.add(this.fixedConfig(inputConverters));
        return this;
    }

    public GraphQLSchemaGenerator withInputConverters(ExtensionProvider<InputConverter> provider) {
        this.inputConverterProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withOutputConverters(OutputConverter<?, ?> ... outputConverters) {
        this.outputConverterProviders.add(this.fixedConfig(outputConverters));
        return this;
    }

    public GraphQLSchemaGenerator withOutputConverters(ExtensionProvider<OutputConverter> provider) {
        this.outputConverterProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withTypeAdapters(AbstractTypeAdapter<?, ?> ... typeAdapters) {
        this.withInputConverters((Configuration conf, ExtensionList<InputConverter> defaults) -> defaults.insert(0, typeAdapters));
        this.withOutputConverters((Configuration conf, ExtensionList<OutputConverter> defaults) -> defaults.insert(0, typeAdapters));
        return this.withTypeMappers((Configuration conf, ExtensionList<TypeMapper> defaults) -> defaults.insertAfter(ScalarMapper.class, typeAdapters));
    }

    public GraphQLSchemaGenerator withArgumentInjectors(ArgumentInjector ... argumentInjectors) {
        this.argumentInjectorProviders.add(this.fixedConfig(argumentInjectors));
        return this;
    }

    public GraphQLSchemaGenerator withArgumentInjectors(ExtensionProvider<ArgumentInjector> provider) {
        this.argumentInjectorProviders.add(provider);
        return this;
    }

    public GraphQLSchemaGenerator withAdditionalTypes(Collection<GraphQLType> additionalTypes) {
        additionalTypes.stream().filter(type -> !this.isInternalType((GraphQLType)type)).forEach(this.additionalTypes::add);
        return this;
    }

    public GraphQLSchemaGenerator withOperationBuilder(OperationBuilder operationBuilder) {
        this.operationBuilder = operationBuilder;
        return this;
    }

    public GraphQLSchemaGenerator withRelayCompliantMutations() {
        return this.withRelayCompliantMutations("result", "Mutation result");
    }

    public GraphQLSchemaGenerator withRelayCompliantMutations(String wrapperFieldName, String wrapperFieldDescription) {
        this.relayMappingConfig.relayCompliantMutations = true;
        this.relayMappingConfig.wrapperFieldName = wrapperFieldName;
        this.relayMappingConfig.wrapperFieldDescription = wrapperFieldDescription;
        return this;
    }

    public GraphQLSchemaGenerator withRelayNodeInterfaceInference(boolean enabled) {
        this.relayMappingConfig.inferNodeInterface = enabled;
        return this;
    }

    public GraphQLSchemaGenerator withSchemaProcessors(GraphQLSchemaProcessor ... processors) {
        Collections.addAll(this.processors, processors);
        return this;
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaults() {
        return this.withDefaultResolverBuilders().withDefaultNestedResolverBuilders().withDefaultMappers().withDefaultConverters().withDefaultArgumentInjectors();
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultMappers() {
        return this.withTypeMappers(this.defaultConfig());
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultInputConverters() {
        return this.withInputConverters(this.defaultConfig());
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultOutputConverters() {
        return this.withOutputConverters(this.defaultConfig());
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultConverters() {
        return this.withDefaultInputConverters().withDefaultOutputConverters();
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultArgumentInjectors() {
        return this.withArgumentInjectors(this.defaultConfig());
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultResolverBuilders() {
        return this.withResolverBuilders(this.defaultConfig());
    }

    @Deprecated
    public GraphQLSchemaGenerator withDefaultNestedResolverBuilders() {
        return this.withNestedResolverBuilders(this.defaultConfig());
    }

    private void init() {
        ValueMapperFactory internalValueMapperFactory;
        Configuration configuration = new Configuration(this.interfaceStrategy, this.scalarStrategy, this.typeTransformer, this.basePackages);
        if (this.operationSourceRepository.isEmpty()) {
            throw new IllegalStateException("At least one top-level operation source must be registered");
        }
        if (this.inclusionStrategy == null) {
            this.inclusionStrategy = new DefaultInclusionStrategy(this.basePackages);
        }
        ValueMapperFactory valueMapperFactory = internalValueMapperFactory = this.valueMapperFactory != null ? this.valueMapperFactory : Defaults.valueMapperFactory(this.typeInfoGenerator);
        if (this.scalarStrategy == null) {
            this.scalarStrategy = internalValueMapperFactory instanceof ScalarDeserializationStrategy ? (ScalarDeserializationStrategy)((Object)internalValueMapperFactory) : (ScalarDeserializationStrategy)((Object)Defaults.valueMapperFactory(this.typeInfoGenerator));
        }
        if (this.resolverBuilderProviders.isEmpty()) {
            this.resolverBuilderProviders.add(this.defaultConfig());
        }
        List<AnnotatedResolverBuilder> defaultResolverBuilders = Collections.singletonList(new AnnotatedResolverBuilder());
        LinkedHashSet<ResolverBuilder> collectedResolverBuilders = new LinkedHashSet<ResolverBuilder>();
        this.resolverBuilderProviders.forEach(config -> collectedResolverBuilders.addAll(config.getExtensions(configuration, new ExtensionList(defaultResolverBuilders))));
        if (collectedResolverBuilders.isEmpty()) {
            throw new IllegalStateException("Configuration error: No resolver builders registered");
        }
        this.operationSourceRepository.registerGlobalResolverBuilders(collectedResolverBuilders);
        if (this.nestedResolverBuilderProviders.isEmpty()) {
            this.nestedResolverBuilderProviders.add(this.defaultConfig());
        }
        List<ResolverBuilder> defaultNestedResolverBuilders = Arrays.asList(new AnnotatedResolverBuilder(), new BeanResolverBuilder(this.basePackages).withJavaDeprecationRespected(this.respectJavaDeprecation));
        LinkedHashSet<ResolverBuilder> collectedNestedResolverBuilders = new LinkedHashSet<ResolverBuilder>();
        this.nestedResolverBuilderProviders.forEach(config -> collectedNestedResolverBuilders.addAll(config.getExtensions(configuration, new ExtensionList(defaultNestedResolverBuilders))));
        if (collectedNestedResolverBuilders.isEmpty()) {
            throw new IllegalStateException("Configuration error: No nested resolver builders registered");
        }
        this.operationSourceRepository.registerGlobalNestedResolverBuilders(collectedNestedResolverBuilders);
        if (this.typeMapperProviders.isEmpty()) {
            this.typeMapperProviders.add(this.defaultConfig());
        }
        ObjectTypeMapper objectTypeMapper = new ObjectTypeMapper();
        EnumMapper enumMapper = new EnumMapper(this.respectJavaDeprecation);
        List<TypeMapper> defaultMappers = Arrays.asList(new NonNullMapper(), new IdAdapter(), new ScalarMapper(), new CompletableFutureMapper(), new PublisherMapper(), new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new ByteArrayToBase64Adapter(), enumMapper, new ArrayAdapter(), new UnionTypeMapper(), new UnionInlineMapper(), new StreamToCollectionTypeAdapter(), new DataFetcherResultMapper(), new VoidToBooleanTypeAdapter(), new ListMapper(), new PageMapper(), new OptionalAdapter(), new EnumMapToObjectTypeAdapter(enumMapper), new ObjectScalarAdapter(this.scalarStrategy), new InterfaceMapper(this.interfaceStrategy, objectTypeMapper), objectTypeMapper);
        this.typeMappers = this.typeMapperProviders.stream().flatMap(provider -> provider.getExtensions(configuration, new ExtensionList(defaultMappers)).stream()).distinct().collect(Collectors.toList());
        if (this.typeMappers.isEmpty()) {
            throw new IllegalStateException("Configuration error: No type mappers registered");
        }
        if (this.outputConverterProviders.isEmpty()) {
            this.outputConverterProviders.add(this.defaultConfig());
        }
        List<OutputConverter> defaultOutputConverters = Arrays.asList(new IdAdapter(), new VoidToBooleanTypeAdapter(), new ByteArrayToBase64Adapter(), new ArrayAdapter(), new CollectionOutputConverter(), new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new OptionalAdapter(), new StreamToCollectionTypeAdapter(), new ObjectScalarAdapter(this.scalarStrategy));
        List<OutputConverter> outputConverters = this.outputConverterProviders.stream().flatMap(provider -> provider.getExtensions(configuration, new ExtensionList(defaultOutputConverters)).stream()).distinct().collect(Collectors.toList());
        if (this.inputConverterProviders.isEmpty()) {
            this.inputConverterProviders.add(this.defaultConfig());
        }
        List<InputConverter> defaultInputConverters = Arrays.asList(new OptionalIntAdapter(), new OptionalLongAdapter(), new OptionalDoubleAdapter(), new OptionalAdapter(), new StreamToCollectionTypeAdapter(), new ByteArrayToBase64Adapter(), new EnumMapToObjectTypeAdapter(enumMapper));
        List<InputConverter> inputConverters = this.inputConverterProviders.stream().flatMap(provider -> provider.getExtensions(configuration, new ExtensionList(defaultInputConverters)).stream()).distinct().collect(Collectors.toList());
        if (this.argumentInjectorProviders.isEmpty()) {
            this.argumentInjectorProviders.add(this.defaultConfig());
        }
        List<ArgumentInjector> defaultArgumentInjectors = Arrays.asList(new IdAdapter(), new RootContextInjector(), new ContextInjector(), new EnvironmentInjector(), new InputValueDeserializer());
        List<ArgumentInjector> argumentInjectors = this.argumentInjectorProviders.stream().flatMap(provider -> provider.getExtensions(configuration, new ExtensionList(defaultArgumentInjectors)).stream()).distinct().collect(Collectors.toList());
        if (argumentInjectors.isEmpty()) {
            throw new IllegalStateException("Configuration error: No argument injector registered");
        }
        this.environment = new GlobalEnvironment(new Relay(), new TypeRepository(this.additionalTypes), new ConverterRepository(inputConverters, outputConverters), new ArgumentInjectorRepository(argumentInjectors));
        this.valueMapperFactory = new MemoizedValueMapperFactory(this.environment, internalValueMapperFactory);
        if (this.inputFieldStrategy == null) {
            Object def = this.valueMapperFactory.getValueMapper();
            this.inputFieldStrategy = def instanceof InputFieldDiscoveryStrategy ? (InputFieldDiscoveryStrategy)def : (InputFieldDiscoveryStrategy)Defaults.valueMapperFactory(this.typeInfoGenerator).getValueMapper();
        }
    }

    public GraphQLSchema generate() {
        List<GraphQLFieldDefinition> subscriptions;
        this.init();
        BuildContext buildContext = new BuildContext(this.basePackages, this.environment, new OperationRepository(this.operationSourceRepository, this.operationBuilder, this.inclusionStrategy, this.typeTransformer, this.basePackages), new TypeMapperRepository(this.typeMappers), this.valueMapperFactory, this.typeInfoGenerator, this.interfaceStrategy, this.scalarStrategy, this.typeTransformer, this.abstractInputHandler, this.inputFieldStrategy, this.inclusionStrategy, this.relayMappingConfig, this.additionalTypes, this.implDiscoveryStrategy);
        OperationMapper operationMapper = new OperationMapper(buildContext);
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema().query(GraphQLObjectType.newObject().name(this.queryRoot).description("Query root type").fields(operationMapper.getQueries()).build());
        List<GraphQLFieldDefinition> mutations = operationMapper.getMutations();
        if (!mutations.isEmpty()) {
            builder.mutation(GraphQLObjectType.newObject().name(this.mutationRoot).description("Mutation root type").fields(mutations).build());
        }
        if (!(subscriptions = operationMapper.getSubscriptions()).isEmpty()) {
            builder.subscription(GraphQLObjectType.newObject().name(this.subscriptionRoot).description("Subscription root type").fields(subscriptions).build());
        }
        this.applyProcessors(builder, buildContext);
        this.additionalTypes.addAll(buildContext.typeRepository.getDiscoveredTypes());
        return builder.build(this.additionalTypes);
    }

    private void applyProcessors(GraphQLSchema.Builder builder, BuildContext buildContext) {
        for (GraphQLSchemaProcessor processor : this.processors) {
            processor.process(builder, buildContext);
        }
    }

    private boolean isInternalType(GraphQLType type) {
        return GraphQLUtils.isIntrospectionType(type) || type.getName().equals(this.queryRoot) || type.getName().equals(this.mutationRoot) || type.getName().equals(this.subscriptionRoot);
    }

    private void checkType(Type type) {
        if (type == null) {
            throw new TypeMappingException();
        }
        Class clazz = ClassUtils.getRawType(type);
        if (ClassUtils.isProxy(clazz)) {
            throw new TypeMappingException("The registered object of type " + clazz.getName() + " appears to be a dynamically generated proxy, so its type can not be reliably determined. Provide the type explicitly when registering the bean. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#dynamic-proxies");
        }
        if (ClassUtils.isMissingTypeParameters(type)) {
            throw new TypeMappingException("The registered object is of generic type " + type.getTypeName() + ". Provide the full type explicitly when registering the bean. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#generic-top-level-singletons");
        }
    }

    private void checkType(AnnotatedType type) {
        if (type == null) {
            throw new TypeMappingException();
        }
        this.checkType(type.getType());
    }

    private <T> ExtensionProvider<T> defaultConfig() {
        return (config, defaults) -> defaults;
    }

    private <T> ExtensionProvider<T> fixedConfig(T[] additions) {
        return (config, defaults) -> Arrays.asList(additions);
    }

    private static class MemoizedValueMapperFactory<T extends ValueMapper>
    implements ValueMapperFactory<T> {
        private final T defaultValueMapper;
        private final ValueMapperFactory<T> delegate;

        public MemoizedValueMapperFactory(GlobalEnvironment environment, ValueMapperFactory<T> delegate) {
            this.defaultValueMapper = delegate.getValueMapper(Collections.emptyMap(), environment);
            this.delegate = delegate;
        }

        @Override
        public T getValueMapper(Map<Class, List<Class>> concreteSubTypes, GlobalEnvironment environment) {
            if (concreteSubTypes.isEmpty() || concreteSubTypes.values().stream().allMatch(List::isEmpty)) {
                return this.defaultValueMapper;
            }
            return this.delegate.getValueMapper(concreteSubTypes, environment);
        }
    }

    public static final class ExtensionList<E>
    extends ArrayList<E> {
        ExtensionList(Collection<? extends E> c) {
            super(c);
        }

        @SafeVarargs
        public final ExtensionList<E> append(E ... extensions) {
            Collections.addAll(this, extensions);
            return this;
        }

        public ExtensionList<E> append(Collection<E> extensions) {
            super.addAll(extensions);
            return this;
        }

        @SafeVarargs
        public final ExtensionList<E> insert(int index, E ... extensions) {
            for (int i = 0; i < extensions.length; ++i) {
                this.add(index + i, extensions[i]);
            }
            return this;
        }

        @SafeVarargs
        public final ExtensionList<E> insertAfter(Class<? extends E> extensionType, E ... extensions) {
            return this.insert(this.firstIndexOfType(extensionType) + 1, extensions);
        }

        @SafeVarargs
        public final ExtensionList<E> insertBefore(Class<? extends E> extensionType, E ... extensions) {
            return this.insert(this.firstIndexOfType(extensionType), extensions);
        }

        public ExtensionList<E> drop(int index) {
            super.remove(index);
            return this;
        }

        public ExtensionList<E> drop(Class<? extends E> extensionType) {
            return this.drop(this.firstIndexOfType(extensionType));
        }

        public ExtensionList<E> dropAll(Predicate<? super E> filter) {
            super.removeIf(filter);
            return this;
        }

        public ExtensionList<E> replace(int index, E replacement) {
            super.set(index, replacement);
            return this;
        }

        public ExtensionList<E> replace(Class<? extends E> extensionType, E replacement) {
            return this.replace(this.firstIndexOfType(extensionType), replacement);
        }

        private int firstIndexOfType(Class<? extends E> extensionType) {
            for (int i = 0; i < this.size(); ++i) {
                if (!extensionType.isInstance(this.get(i))) continue;
                return i;
            }
            throw new IllegalArgumentException("Extension of type " + extensionType.getName() + " not found");
        }
    }

    public static class Configuration {
        public final InterfaceMappingStrategy interfaceMappingStrategy;
        public final ScalarDeserializationStrategy scalarDeserializationStrategy;
        public final TypeTransformer typeTransformer;
        public final String[] basePackages;

        public Configuration(InterfaceMappingStrategy interfaceMappingStrategy, ScalarDeserializationStrategy scalarDeserializationStrategy, TypeTransformer typeTransformer, String[] basePackages) {
            this.interfaceMappingStrategy = interfaceMappingStrategy;
            this.scalarDeserializationStrategy = scalarDeserializationStrategy;
            this.typeTransformer = typeTransformer;
            this.basePackages = basePackages;
        }
    }
}

