/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.relay.Relay;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.generator.DelegatingTypeResolver;
import io.leangen.graphql.generator.OperationRepository;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.RelayNodeTypeResolver;
import io.leangen.graphql.generator.TypeCache;
import io.leangen.graphql.generator.TypeRepository;
import io.leangen.graphql.generator.Validator;
import io.leangen.graphql.generator.mapping.TypeMapperRepository;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.generator.mapping.strategy.ImplementationDiscoveryStrategy;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.InputFieldDiscoveryStrategy;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BuildContext {
    public final GlobalEnvironment globalEnvironment;
    public final OperationRepository operationRepository;
    public final TypeRepository typeRepository;
    public final TypeCache typeCache;
    public final TypeMapperRepository typeMappers;
    public final Relay relay;
    public final GraphQLInterfaceType node;
    public final TypeResolver typeResolver;
    public final InterfaceMappingStrategy interfaceStrategy;
    public final String[] basePackages;
    public final ValueMapperFactory valueMapperFactory;
    public final InputFieldDiscoveryStrategy inputFieldStrategy;
    public final InclusionStrategy inclusionStrategy;
    public final ScalarDeserializationStrategy scalarStrategy;
    public final TypeTransformer typeTransformer;
    public final AbstractInputHandler abstractInputHandler;
    public final ImplementationDiscoveryStrategy implDiscoveryStrategy;
    public final TypeInfoGenerator typeInfoGenerator;
    public final RelayMappingConfig relayMappingConfig;
    final Validator validator;

    public BuildContext(String[] basePackages, GlobalEnvironment environment, OperationRepository operationRepository, TypeMapperRepository typeMappers, ValueMapperFactory valueMapperFactory, TypeInfoGenerator typeInfoGenerator, InterfaceMappingStrategy interfaceStrategy, ScalarDeserializationStrategy scalarStrategy, TypeTransformer typeTransformer, AbstractInputHandler abstractInputHandler, InputFieldDiscoveryStrategy inputFieldStrategy, InclusionStrategy inclusionStrategy, RelayMappingConfig relayMappingConfig, Set<GraphQLType> knownTypes, ImplementationDiscoveryStrategy implementationStrategy) {
        this.operationRepository = operationRepository;
        this.typeRepository = environment.typeRepository;
        this.typeCache = new TypeCache(knownTypes);
        this.typeMappers = typeMappers;
        this.typeInfoGenerator = typeInfoGenerator;
        this.relay = environment.relay;
        this.node = knownTypes.stream().filter(GraphQLUtils::isRelayNodeInterface).findFirst().map(type -> (GraphQLInterfaceType)type).orElse(this.relay.nodeInterface((TypeResolver)new RelayNodeTypeResolver(this.typeRepository, typeInfoGenerator)));
        this.typeResolver = new DelegatingTypeResolver(this.typeRepository, typeInfoGenerator);
        this.interfaceStrategy = interfaceStrategy;
        this.basePackages = basePackages;
        this.valueMapperFactory = valueMapperFactory;
        this.inputFieldStrategy = inputFieldStrategy;
        this.inclusionStrategy = inclusionStrategy;
        this.scalarStrategy = scalarStrategy;
        this.typeTransformer = typeTransformer;
        this.implDiscoveryStrategy = implementationStrategy;
        this.abstractInputHandler = abstractInputHandler;
        this.globalEnvironment = environment;
        this.relayMappingConfig = relayMappingConfig;
        this.validator = new Validator(environment, typeMappers, knownTypes);
    }

    ValueMapper createValueMapper(Stream<AnnotatedType> inputTypes) {
        List abstractTypes = inputTypes.flatMap(input -> this.abstractInputHandler.findConstituentAbstractTypes((AnnotatedType)input, this).stream().map(ClassUtils::getRawType)).distinct().collect(Collectors.toList());
        Map<Class, List<Class>> concreteSubTypes = abstractTypes.stream().collect(Collectors.toMap(Function.identity(), abs -> this.abstractInputHandler.findConcreteSubTypes((Class)abs, this)));
        return this.valueMapperFactory.getValueMapper(concreteSubTypes, this.globalEnvironment);
    }

    void resolveTypeReferences() {
        this.typeCache.resolveTypeReferences(this.typeRepository);
    }
}

