/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.OperationExecutor;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.TypeRepository;
import io.leangen.graphql.generator.Validator;
import io.leangen.graphql.generator.types.MappedGraphQLFieldDefinition;
import io.leangen.graphql.generator.types.MappedGraphQLObjectType;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.OperationArgumentDefaultValue;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMapper {
    private List<GraphQLFieldDefinition> queries;
    private List<GraphQLFieldDefinition> mutations;
    private List<GraphQLFieldDefinition> subscriptions;
    private static final Logger log = LoggerFactory.getLogger(OperationMapper.class);

    public OperationMapper(BuildContext buildContext) {
        this.queries = this.generateQueries(buildContext);
        this.mutations = this.generateMutations(buildContext);
        this.subscriptions = this.generateSubscriptions(buildContext);
    }

    private List<GraphQLFieldDefinition> generateQueries(BuildContext buildContext) {
        Map<String, String> nodeQueriesByType;
        ArrayList<Operation> rootQueries = new ArrayList<Operation>(buildContext.operationRepository.getRootQueries());
        List<GraphQLFieldDefinition> queries = rootQueries.stream().map(query -> this.toGraphQLField((Operation)query, buildContext)).collect(Collectors.toList());
        buildContext.resolveTypeReferences();
        if (rootQueries.stream().noneMatch(query -> query.getName().equals("node")) && !(nodeQueriesByType = this.getNodeQueriesByType(rootQueries, queries, buildContext.typeRepository, buildContext.node, buildContext)).isEmpty()) {
            queries.add(buildContext.relay.nodeField(buildContext.node, this.createNodeResolver(nodeQueriesByType, buildContext.relay)));
        }
        return queries;
    }

    private List<GraphQLFieldDefinition> generateMutations(BuildContext buildContext) {
        Collection<Operation> mutations = buildContext.operationRepository.getMutations();
        return mutations.stream().map(mutation -> buildContext.relayMappingConfig.relayCompliantMutations ? this.toRelayMutation(this.toGraphQLField((Operation)mutation, buildContext), buildContext.relayMappingConfig) : this.toGraphQLField((Operation)mutation, buildContext)).collect(Collectors.toList());
    }

    private List<GraphQLFieldDefinition> generateSubscriptions(BuildContext buildContext) {
        return buildContext.operationRepository.getSubscriptions().stream().map(subscription -> this.toGraphQLField((Operation)subscription, buildContext)).collect(Collectors.toList());
    }

    public GraphQLFieldDefinition toGraphQLField(Operation operation, BuildContext buildContext) {
        GraphQLOutputType type = this.toGraphQLType(operation.getJavaType(), buildContext);
        GraphQLFieldDefinition.Builder queryBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription()).deprecate(operation.getDeprecationReason()).type(type);
        List arguments = operation.getArguments().stream().filter(OperationArgument::isMappable).map(argument -> this.toGraphQLArgument((OperationArgument)argument, buildContext)).collect(Collectors.toList());
        queryBuilder.argument(arguments);
        if (GraphQLUtils.isRelayConnectionType((GraphQLType)type) && buildContext.relay.getConnectionFieldArguments().stream().anyMatch(connArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(connArg.getName()) && !arg.getType().getName().equals(connArg.getType().getName())))) {
            throw new TypeMappingException("Operation \"" + operation.getName() + "\" has arguments of types incompatible with the Relay Connection spec");
        }
        Stream<AnnotatedType> inputTypes = operation.getArguments().stream().filter(OperationArgument::isMappable).map(OperationArgument::getJavaType);
        ValueMapper valueMapper = buildContext.createValueMapper(inputTypes);
        queryBuilder.dataFetcher(this.createResolver(operation, valueMapper, buildContext.globalEnvironment));
        return new MappedGraphQLFieldDefinition(queryBuilder.build(), operation);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, BuildContext buildContext) {
        GraphQLOutputType type = buildContext.typeMappers.getTypeMapper(javaType).toGraphQLType(javaType, this, buildContext);
        this.log(buildContext.validator.checkUniqueness(type, javaType));
        buildContext.typeCache.completeType(type);
        return type;
    }

    public GraphQLInputObjectField toGraphQLInputField(InputField inputField, BuildContext buildContext) {
        GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(inputField.getName()).description(inputField.getDescription()).type(this.toGraphQLInputType(inputField.getJavaType(), buildContext));
        return builder.build();
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, BuildContext buildContext) {
        GraphQLInputType type = buildContext.typeMappers.getTypeMapper(javaType).toGraphQLInputType(javaType, this, buildContext);
        this.log(buildContext.validator.checkUniqueness(type, javaType));
        return type;
    }

    private GraphQLArgument toGraphQLArgument(OperationArgument operationArgument, BuildContext buildContext) {
        GraphQLArgument.Builder argument = GraphQLArgument.newArgument().name(operationArgument.getName()).description(operationArgument.getDescription()).type(this.toGraphQLInputType(operationArgument.getJavaType(), buildContext));
        OperationArgumentDefaultValue defaultValue = operationArgument.getDefaultValue();
        if (defaultValue.isPresent()) {
            argument.defaultValue(defaultValue.get());
        }
        return argument.build();
    }

    private GraphQLFieldDefinition toRelayMutation(GraphQLFieldDefinition mutation, RelayMappingConfig relayMappingConfig) {
        List<GraphQLFieldDefinition> outputFields;
        if (mutation.getType() instanceof GraphQLObjectType) {
            outputFields = ((GraphQLObjectType)mutation.getType()).getFieldDefinitions();
        } else {
            outputFields = new ArrayList();
            outputFields.add(GraphQLFieldDefinition.newFieldDefinition().name(relayMappingConfig.wrapperFieldName).description(relayMappingConfig.wrapperFieldDescription).type(mutation.getType()).dataFetcher(DataFetchingEnvironment::getSource).build());
        }
        List inputFields = mutation.getArguments().stream().map(arg -> GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType()).defaultValue(arg.getDefaultValue()).build()).collect(Collectors.toList());
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(mutation.getName() + "Input").field(GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(mutation.getName() + "Payload").field(GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(env -> env.getContext() instanceof ContextWrapper ? ((ContextWrapper)env.getContext()).getExtension("clientMutationId") : new PropertyDataFetcher("clientMutationId"))).fields(outputFields).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(mutation.getName()).type((GraphQLOutputType)outputType).argument(GraphQLArgument.newArgument().name("input").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)inputObjectType))).dataFetcher(env -> {
            Map input = (Map)env.getArguments().get("input");
            env.getArguments().clear();
            env.getArguments().putAll(input);
            if (env.getContext() instanceof ContextWrapper) {
                ContextWrapper context = (ContextWrapper)env.getContext();
                context.putExtension("clientMutationId", env.getArgument("clientMutationId"));
            }
            return mutation.getDataFetcher().get(env);
        }).build();
    }

    private DataFetcher createResolver(Operation operation, ValueMapper valueMapper, GlobalEnvironment globalEnvironment) {
        if (operation.isBatched()) {
            return environment -> new OperationExecutor(operation, valueMapper, globalEnvironment).execute(environment);
        }
        return new OperationExecutor(operation, valueMapper, globalEnvironment)::execute;
    }

    private DataFetcher createNodeResolver(Map<String, String> nodeQueriesByType, Relay relay) {
        return env -> {
            String typeName;
            try {
                typeName = relay.fromGlobalId((String)env.getArguments().get("id")).getType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(env.getArguments().get("id") + " is not a valid Relay node ID");
            }
            if (!nodeQueriesByType.containsKey(typeName)) {
                throw new IllegalArgumentException(typeName + " is not a Relay node type or no registered query can fetch it by ID");
            }
            return env.getGraphQLSchema().getQueryType().getFieldDefinition((String)nodeQueriesByType.get(typeName)).getDataFetcher().get(env);
        };
    }

    private Map<String, String> getNodeQueriesByType(List<Operation> queries, List<GraphQLFieldDefinition> graphQlQueries, TypeRepository typeRepository, GraphQLInterfaceType node, BuildContext buildContext) {
        HashMap<String, String> nodeQueriesByType = new HashMap<String, String>();
        for (int i = 0; i < queries.size(); ++i) {
            Operation query = queries.get(i);
            GraphQLFieldDefinition graphQlQuery = graphQlQueries.get(i);
            if (graphQlQuery.getArgument("id") == null || !GraphQLUtils.isRelayId(graphQlQuery.getArgument("id")) || query.getResolver("id") == null) continue;
            GraphQLType unwrappedQueryType = GraphQLUtils.unwrapNonNull((GraphQLType)graphQlQuery.getType());
            if ((unwrappedQueryType = buildContext.typeCache.resolveType(unwrappedQueryType.getName())) instanceof GraphQLObjectType && ((GraphQLObjectType)unwrappedQueryType).getInterfaces().contains(node)) {
                nodeQueriesByType.put(unwrappedQueryType.getName(), query.getName());
                continue;
            }
            if (unwrappedQueryType instanceof GraphQLInterfaceType) {
                typeRepository.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
                continue;
            }
            if (!(unwrappedQueryType instanceof GraphQLUnionType)) continue;
            typeRepository.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).filter(implementation -> implementation instanceof MappedGraphQLObjectType).filter(implementation -> GenericTypeReflector.isSuperType((Type)query.getResolver("id").getReturnType().getType(), (Type)((MappedGraphQLObjectType)implementation).getJavaType().getType())).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
        }
        return nodeQueriesByType;
    }

    private void log(Validator.ValidationResult result) {
        if (!result.isValid()) {
            log.warn(result.getMessage());
        }
    }

    public List<GraphQLFieldDefinition> getQueries() {
        return this.queries;
    }

    public List<GraphQLFieldDefinition> getMutations() {
        return this.mutations;
    }

    public List<GraphQLFieldDefinition> getSubscriptions() {
        return this.subscriptions;
    }
}

