/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import io.leangen.geantyref.AnnotatedTypeMap;
import io.leangen.graphql.generator.OperationSource;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import java.lang.reflect.AnnotatedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class OperationSourceRepository {
    private final Collection<ResolverBuilder> topLevelResolverBuilders = new LinkedHashSet<ResolverBuilder>();
    private final Collection<ResolverBuilder> nestedResolverBuilders = new LinkedHashSet<ResolverBuilder>();
    private final Collection<OperationSource> operationSources = new HashSet<OperationSource>();
    private final Map<AnnotatedType, OperationSource> nestedOperationSources = new AnnotatedTypeMap();

    public void registerOperationSource(Object querySourceBean, AnnotatedType beanType) {
        this.operationSources.add(new OperationSource(querySourceBean, beanType, this.topLevelResolverBuilders));
    }

    public void registerOperationSource(Object querySourceBean, AnnotatedType beanType, Collection<ResolverBuilder> extractors) {
        this.operationSources.add(new OperationSource(querySourceBean, beanType, extractors.isEmpty() ? this.topLevelResolverBuilders : extractors));
    }

    public void registerOperationSource(AnnotatedType serviceType) {
        this.operationSources.add(new OperationSource(serviceType, this.topLevelResolverBuilders));
    }

    public void registerOperationSource(AnnotatedType serviceType, Collection<ResolverBuilder> strategies) {
        this.operationSources.add(new OperationSource(serviceType, strategies));
    }

    public void registerNestedOperationSource(AnnotatedType domainType) {
        this.nestedOperationSources.put(domainType, new OperationSource(domainType, this.nestedResolverBuilders));
    }

    public void registerNestedOperationSource(AnnotatedType domainType, Collection<ResolverBuilder> extractors) {
        this.nestedOperationSources.put(domainType, new OperationSource(domainType, extractors.isEmpty() ? this.nestedResolverBuilders : extractors));
    }

    public void registerGlobalResolverBuilders(Collection<ResolverBuilder> resolverDetectionStrategies) {
        this.topLevelResolverBuilders.addAll(resolverDetectionStrategies);
    }

    public void registerGlobalNestedResolverBuilders(Collection<ResolverBuilder> resolverDetectionStrategies) {
        this.nestedResolverBuilders.addAll(resolverDetectionStrategies);
    }

    public OperationSource nestedSourceForType(AnnotatedType domainType) {
        return this.nestedOperationSources.computeIfAbsent(domainType, javaType -> new OperationSource((AnnotatedType)javaType, this.nestedResolverBuilders));
    }

    public Collection<OperationSource> getOperationSources() {
        return this.operationSources;
    }

    public Collection<OperationSource> getNestedOperationSources() {
        return this.nestedOperationSources.values();
    }

    public boolean isEmpty() {
        return this.operationSources.isEmpty();
    }
}

