/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping;

import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;

public class ConverterRepository {
    private final List<InputConverter> inputConverters;
    private final List<OutputConverter> outputConverters;

    public ConverterRepository(List<InputConverter> inputConverters, List<OutputConverter> outputConverters) {
        this.inputConverters = Collections.unmodifiableList(inputConverters);
        this.outputConverters = Collections.unmodifiableList(outputConverters);
    }

    public List<InputConverter> getInputConverters() {
        return this.inputConverters;
    }

    public <T, S> InputConverter<T, S> getInputConverter(AnnotatedType inputType) {
        return this.inputConverters.stream().filter(conv -> conv.supports(inputType)).findFirst().orElse(null);
    }

    public <T, S> OutputConverter<T, S> getOutputConverter(AnnotatedType outputType) {
        return this.outputConverters.stream().filter(conv -> conv.supports(outputType)).findFirst().orElse(null);
    }

    public AnnotatedType getMappableInputType(AnnotatedType type) {
        InputConverter converter = this.getInputConverter(type);
        if (converter != null) {
            return this.getMappableInputType(converter.getSubstituteType(type));
        }
        return ClassUtils.transformType(type, this::getMappableInputType);
    }
}

