/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLEnumType;
import io.leangen.graphql.annotations.GraphQLEnumValue;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class EnumMapper
extends CachingMapper<GraphQLEnumType, GraphQLEnumType> {
    private final boolean respectJavaDeprecation;

    public EnumMapper(boolean respectJavaDeprecation) {
        this.respectJavaDeprecation = respectJavaDeprecation;
    }

    @Override
    public GraphQLEnumType toGraphQLType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType));
        this.addOptions(enumBuilder, javaType, buildContext.typeInfoGenerator);
        return enumBuilder.build();
    }

    @Override
    public GraphQLEnumType toGraphQLInputType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(typeName).description(buildContext.typeInfoGenerator.generateInputTypeDescription(javaType));
        this.addOptions(enumBuilder, javaType, buildContext.typeInfoGenerator);
        return enumBuilder.build();
    }

    private void addOptions(GraphQLEnumType.Builder enumBuilder, AnnotatedType javaType, TypeInfoGenerator infoGenerator) {
        this.sortEnumValues((Enum[])ClassUtils.getRawType(javaType.getType()).getEnumConstants(), infoGenerator.getFieldOrder(javaType)).stream().map(enumConst -> enumConst).forEach(enumConst -> enumBuilder.value(this.getValueName((Enum<?>)enumConst), enumConst, this.getValueDescription((Enum<?>)enumConst), this.getValueDeprecationReason((Enum<?>)enumConst)));
    }

    protected String getValueName(Enum<?> value) {
        GraphQLEnumValue annotation = ClassUtils.getEnumConstantField(value).getAnnotation(GraphQLEnumValue.class);
        return annotation != null && !annotation.name().isEmpty() ? annotation.name() : value.name();
    }

    protected String getValueDescription(Enum<?> value) {
        GraphQLEnumValue annotation = ClassUtils.getEnumConstantField(value).getAnnotation(GraphQLEnumValue.class);
        return annotation != null ? annotation.description() : null;
    }

    protected String getValueDeprecationReason(Enum<?> value) {
        GraphQLEnumValue annotation = ClassUtils.getEnumConstantField(value).getAnnotation(GraphQLEnumValue.class);
        if (annotation != null) {
            return Utils.decodeNullable(annotation.deprecationReason());
        }
        Deprecated deprecated = ClassUtils.getEnumConstantField(value).getAnnotation(Deprecated.class);
        return this.respectJavaDeprecation && deprecated != null ? "" : null;
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return ClassUtils.getRawType(type.getType()).isEnum();
    }

    @Override
    protected String getTypeName(AnnotatedType type, BuildContext buildContext) {
        return buildContext.typeInfoGenerator.generateTypeName(type);
    }

    @Override
    protected String getInputTypeName(AnnotatedType type, BuildContext buildContext) {
        return buildContext.typeInfoGenerator.generateInputTypeName(type);
    }

    private List<Enum> sortEnumValues(Enum[] values, String[] order) {
        TreeMap<String, Enum> fieldMap = new TreeMap<String, Enum>();
        for (Enum value : values) {
            fieldMap.put(this.getValueName(value), value);
        }
        ArrayList<Enum> result = new ArrayList<Enum>();
        for (String name : order) {
            if (!fieldMap.containsKey(name)) continue;
            result.add((Enum)fieldMap.remove(name));
        }
        result.addAll(fieldMap.values());
        return result;
    }
}

