/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import io.leangen.graphql.annotations.types.GraphQLInterface;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.generator.mapping.common.ObjectTypeMapper;
import io.leangen.graphql.generator.mapping.strategy.InterfaceMappingStrategy;
import io.leangen.graphql.generator.types.MappedGraphQLInterfaceType;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InterfaceMapper
extends CachingMapper<GraphQLInterfaceType, GraphQLInputObjectType> {
    private final InterfaceMappingStrategy interfaceStrategy;
    private final ObjectTypeMapper objectTypeMapper;

    public InterfaceMapper(InterfaceMappingStrategy interfaceStrategy, ObjectTypeMapper objectTypeMapper) {
        this.interfaceStrategy = Objects.requireNonNull(interfaceStrategy);
        this.objectTypeMapper = Objects.requireNonNull(objectTypeMapper);
    }

    @Override
    public GraphQLInterfaceType toGraphQLType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLInterfaceType.Builder typeBuilder = GraphQLInterfaceType.newInterface().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType));
        List<GraphQLFieldDefinition> fields = this.objectTypeMapper.getFields(javaType, buildContext, operationMapper);
        fields.forEach(arg_0 -> ((GraphQLInterfaceType.Builder)typeBuilder).field(arg_0));
        typeBuilder.typeResolver(buildContext.typeResolver);
        MappedGraphQLInterfaceType type = new MappedGraphQLInterfaceType(typeBuilder.build(), javaType);
        this.registerImplementations(javaType, type, operationMapper, buildContext);
        return type;
    }

    @Override
    public GraphQLInputObjectType toGraphQLInputType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        return this.objectTypeMapper.toGraphQLInputType(typeName, javaType, operationMapper, buildContext);
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return this.interfaceStrategy.supports(type);
    }

    protected void registerImplementations(AnnotatedType javaType, GraphQLInterfaceType type, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLInterface meta;
        if (javaType.isAnnotationPresent(GraphQLInterface.class) && (meta = javaType.getAnnotation(GraphQLInterface.class)).implementationAutoDiscovery()) {
            buildContext.implDiscoveryStrategy.findImplementations(javaType, meta.scanPackages(), buildContext).forEach(impl -> this.getImplementingType((AnnotatedType)impl, operationMapper, buildContext).ifPresent(implType -> buildContext.typeRepository.registerDiscoveredCovariantType(type.getName(), (AnnotatedType)impl, (GraphQLObjectType)implType)));
        }
    }

    private Optional<GraphQLObjectType> getImplementingType(AnnotatedType implType, OperationMapper operationMapper, BuildContext buildContext) {
        return Optional.of(implType).filter(impl -> !this.interfaceStrategy.supports((AnnotatedType)impl)).map(impl -> operationMapper.toGraphQLType((AnnotatedType)impl, buildContext)).filter(impl -> impl instanceof GraphQLObjectType).map(impl -> (GraphQLObjectType)impl);
    }
}

