/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.annotations.GraphQLScalar;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.generator.mapping.common.ObjectScalarAdapter;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class MapToListTypeAdapter<K, V>
extends AbstractTypeAdapter<Map<K, V>, List<MapEntry<K, V>>> {
    @Override
    public List<MapEntry<K, V>> convertOutput(Map<K, V> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return original.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public Map<K, V> convertInput(List<MapEntry<K, V>> original, AnnotatedType type, GlobalEnvironment environment, ValueMapper valueMapper) {
        Map initial = GenericTypeReflector.isSuperType((Type)type.getType(), HashMap.class) ? new HashMap() : (Map)ClassUtils.instance(type);
        return original.stream().collect(MapToListTypeAdapter.toMap(MapEntry::getKey, MapEntry::getValue, initial));
    }

    @Override
    public AnnotatedType getSubstituteType(AnnotatedType original) {
        AnnotatedType keyType = this.getElementType(original, 0);
        AnnotatedType valueType = this.getElementType(original, 1);
        Type entryType = TypeFactory.parameterizedClass(MapEntry.class, (Type[])new Type[]{keyType.getType(), valueType.getType()});
        return GenericTypeReflector.annotate((Type)TypeFactory.parameterizedClass(List.class, (Type[])new Type[]{entryType}), (Annotation[])original.getAnnotations());
    }

    @Override
    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        return new GraphQLList((GraphQLType)this.mapEntry(operationMapper.toGraphQLType(this.getElementType(javaType, 0), buildContext), operationMapper.toGraphQLType(this.getElementType(javaType, 1), buildContext), buildContext));
    }

    @Override
    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        return new GraphQLList((GraphQLType)this.mapEntry(operationMapper.toGraphQLInputType(this.getElementType(javaType, 0), buildContext), operationMapper.toGraphQLInputType(this.getElementType(javaType, 1), buildContext), buildContext));
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return super.supports(type) && !type.isAnnotationPresent(GraphQLScalar.class) && !type.getType().equals(ObjectScalarAdapter.ScalarMap.class);
    }

    private GraphQLOutputType mapEntry(GraphQLOutputType keyType, GraphQLOutputType valueType, BuildContext buildContext) {
        String typeName = "mapEntry_" + this.getTypeName((GraphQLType)keyType) + "_" + this.getTypeName((GraphQLType)valueType);
        if (buildContext.typeCache.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        buildContext.typeCache.register(typeName);
        return GraphQLObjectType.newObject().name(typeName).description("Map entry").field(GraphQLFieldDefinition.newFieldDefinition().name("key").description("Map key").type(keyType).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("Map value").type(valueType).build()).build();
    }

    private GraphQLInputType mapEntry(GraphQLInputType keyType, GraphQLInputType valueType, BuildContext buildContext) {
        String typeName = "mapEntry_" + this.getTypeName((GraphQLType)keyType) + "_" + this.getTypeName((GraphQLType)valueType) + "_input";
        if (buildContext.typeCache.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        buildContext.typeCache.register(typeName);
        return GraphQLInputObjectType.newInputObject().name(typeName).description("Map entry input").field(GraphQLInputObjectField.newInputObjectField().name("key").description("Map key input").type(keyType).build()).field(GraphQLInputObjectField.newInputObjectField().name("value").description("Map value input").type(valueType).build()).build();
    }

    private AnnotatedType getElementType(AnnotatedType javaType, int index) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, Map.class.getTypeParameters()[index]);
    }

    private String getTypeName(GraphQLType type) {
        if (type instanceof GraphQLModifiedType) {
            StringBuilder name = new StringBuilder();
            while (type instanceof GraphQLModifiedType) {
                if (type instanceof GraphQLList) {
                    name.append("list_");
                } else {
                    name.append("__");
                }
                type = ((GraphQLModifiedType)type).getWrappedType();
            }
            return name.append(type.getName()).toString();
        }
        return type.getName();
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Map<K, U> initial) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, () -> initial);
    }

    public static class MapEntry<K, V> {
        private K key;
        private V value;

        public MapEntry() {
        }

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

