/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NonNullMapper
implements TypeMapper {
    private final Set<Class<? extends Annotation>> nonNullAnnotations;

    public NonNullMapper() {
        HashSet annotations = new HashSet();
        annotations.add(io.leangen.graphql.annotations.GraphQLNonNull.class);
        for (String additional : new String[]{"javax.annotation.Nonnull", "javax.validation.constraints.NotNull", "org.jetbrains.annotations.NotNull"}) {
            try {
                annotations.add(ClassUtils.forName(additional));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.nonNullAnnotations = Collections.unmodifiableSet(annotations);
    }

    @Override
    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, OperationMapper OperationMapper2, BuildContext buildContext) {
        return new GraphQLNonNull((GraphQLType)OperationMapper2.toGraphQLType(this.removeNonNull(javaType), buildContext));
    }

    @Override
    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, OperationMapper OperationMapper2, BuildContext buildContext) {
        return new GraphQLNonNull((GraphQLType)OperationMapper2.toGraphQLInputType(this.removeNonNull(javaType), buildContext));
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return this.nonNullAnnotations.stream().anyMatch(type::isAnnotationPresent);
    }

    private AnnotatedType removeNonNull(AnnotatedType type) {
        ArrayList<Annotation> keptAnnotations = new ArrayList<Annotation>(type.getAnnotations().length - 1);
        for (Annotation annotation : type.getAnnotations()) {
            if (this.nonNullAnnotations.contains(annotation.annotationType())) continue;
            keptAnnotations.add(annotation);
        }
        return GenericTypeReflector.replaceAnnotations((AnnotatedType)type, (Annotation[])keptAnnotations.toArray(new Annotation[keptAnnotations.size()]));
    }
}

