/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLScalarType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.GraphQLScalar;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ObjectScalarAdapter
extends CachingMapper<GraphQLScalarType, GraphQLScalarType>
implements OutputConverter<Object, Map<String, ?>> {
    private final ScalarDeserializationStrategy scalarStrategy;
    private static final AnnotatedType MAP = GenericTypeReflector.annotate(ScalarMap.class);

    public ObjectScalarAdapter(ScalarDeserializationStrategy scalarStrategy) {
        this.scalarStrategy = Objects.requireNonNull(scalarStrategy);
    }

    @Override
    public GraphQLScalarType toGraphQLType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        return Scalars.graphQLObjectScalar(typeName);
    }

    @Override
    public GraphQLScalarType toGraphQLInputType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        return this.toGraphQLType(typeName, javaType, operationMapper, buildContext);
    }

    @Override
    public Map<String, ?> convertOutput(Object original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return (Map)resolutionEnvironment.valueMapper.fromInput(original, type.getType(), MAP);
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return type.isAnnotationPresent(GraphQLScalar.class) || Object.class.equals((Object)type.getType()) || GenericTypeReflector.isSuperType(Map.class, (Type)type.getType()) || this.scalarStrategy.isDirectlyDeserializable(type);
    }

    public static class ScalarMap
    extends LinkedHashMap {
    }
}

