/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.generator.types.MappedGraphQLObjectType;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ObjectTypeMapper
extends CachingMapper<GraphQLObjectType, GraphQLInputObjectType> {
    @Override
    public GraphQLObjectType toGraphQLType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLObjectType.Builder typeBuilder = GraphQLObjectType.newObject().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType));
        List<GraphQLFieldDefinition> fields = this.getFields(javaType, buildContext, operationMapper);
        fields.forEach(arg_0 -> ((GraphQLObjectType.Builder)typeBuilder).field(arg_0));
        List<GraphQLOutputType> interfaces = this.getInterfaces(javaType, fields, buildContext, operationMapper);
        interfaces.forEach(inter -> {
            if (inter instanceof GraphQLInterfaceType) {
                typeBuilder.withInterface((GraphQLInterfaceType)inter);
            } else {
                typeBuilder.withInterface((GraphQLTypeReference)inter);
            }
        });
        MappedGraphQLObjectType type = new MappedGraphQLObjectType(typeBuilder.build(), javaType);
        interfaces.forEach(inter -> buildContext.typeRepository.registerCovariantType(inter.getName(), javaType, (GraphQLOutputType)type));
        return type;
    }

    @Override
    public GraphQLInputObjectType toGraphQLInputType(String typeName, AnnotatedType javaType, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLInputObjectType.Builder typeBuilder = GraphQLInputObjectType.newInputObject().name(typeName).description(buildContext.typeInfoGenerator.generateInputTypeDescription(javaType));
        buildContext.inputFieldStrategy.getInputFields(javaType, buildContext.inclusionStrategy, buildContext.typeTransformer).forEach(field -> typeBuilder.field(operationMapper.toGraphQLInputField((InputField)field, buildContext)));
        if (ClassUtils.isAbstract(javaType)) {
            this.createInputDisambiguatorField(javaType, buildContext).ifPresent(arg_0 -> ((GraphQLInputObjectType.Builder)typeBuilder).field(arg_0));
        }
        return typeBuilder.build();
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return true;
    }

    protected List<GraphQLFieldDefinition> getFields(AnnotatedType javaType, BuildContext buildContext, OperationMapper operationMapper) {
        List<GraphQLFieldDefinition> fields = buildContext.operationRepository.getChildQueries(javaType).stream().map(childQuery -> operationMapper.toGraphQLField((Operation)childQuery, buildContext)).collect(Collectors.toList());
        return ObjectTypeMapper.sortFields(fields, buildContext.typeInfoGenerator.getFieldOrder(javaType));
    }

    protected List<GraphQLOutputType> getInterfaces(AnnotatedType javaType, List<GraphQLFieldDefinition> fields, BuildContext buildContext, OperationMapper operationMapper) {
        ArrayList<GraphQLOutputType> interfaces = new ArrayList<GraphQLOutputType>();
        if (buildContext.relayMappingConfig.inferNodeInterface && fields.stream().anyMatch(GraphQLUtils::isRelayId)) {
            interfaces.add((GraphQLOutputType)buildContext.node);
        }
        buildContext.interfaceStrategy.getInterfaces(javaType).forEach(inter -> interfaces.add(operationMapper.toGraphQLType((AnnotatedType)inter, buildContext)));
        return interfaces;
    }

    private static List<GraphQLFieldDefinition> sortFields(List<GraphQLFieldDefinition> fields, String[] specifiedFieldOrder) {
        TreeMap<String, GraphQLFieldDefinition> fieldMap = new TreeMap<String, GraphQLFieldDefinition>();
        for (GraphQLFieldDefinition field : fields) {
            fieldMap.put(field.getName(), field);
        }
        ArrayList<GraphQLFieldDefinition> result = new ArrayList<GraphQLFieldDefinition>();
        for (String name : specifiedFieldOrder) {
            if (!fieldMap.containsKey(name)) continue;
            result.add((GraphQLFieldDefinition)fieldMap.remove(name));
        }
        result.addAll(fieldMap.values());
        return result;
    }

    protected Optional<GraphQLInputObjectField> createInputDisambiguatorField(AnnotatedType javaType, BuildContext buildContext) {
        Class raw = ClassUtils.getRawType(javaType.getType());
        String typeName = buildContext.typeInfoGenerator.generateTypeName(GenericTypeReflector.annotate(raw)) + "TypeDisambiguator";
        GraphQLTypeReference fieldType = null;
        if (buildContext.typeCache.contains(typeName)) {
            fieldType = new GraphQLTypeReference(typeName);
        } else {
            List impls = buildContext.abstractInputHandler.findConcreteSubTypes(raw, buildContext).stream().map(GenericTypeReflector::annotate).collect(Collectors.toList());
            if (!impls.isEmpty()) {
                buildContext.typeCache.register(typeName);
                GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(typeName).description("Input type disambiguator");
                impls.stream().map(buildContext.typeInfoGenerator::generateTypeName).forEach(arg_0 -> ((GraphQLEnumType.Builder)builder).value(arg_0));
                fieldType = builder.build();
            }
        }
        return Optional.ofNullable(fieldType).map(type -> GraphQLInputObjectField.newInputObjectField().name("_type_").type(type).build());
    }
}

