/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.strategy;

import io.leangen.graphql.annotations.GraphQLIgnore;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.mapping.strategy.AbstractInputHandler;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Scalars;
import io.leangen.graphql.util.classpath.ClassInfo;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScanAbstractInputHandler
implements AbstractInputHandler {
    private final Map<Type, Set<Type>> abstractComponents = new HashMap<Type, Set<Type>>();
    protected static final Predicate<ClassInfo> NON_ABSTRACT = info -> (info.getModifier() & 0x600) == 0;
    protected static final Predicate<ClassInfo> NON_IGNORED = info -> info.getAnnotations().stream().noneMatch(ann -> ann.getClassName().equals(GraphQLIgnore.class.getName()));
    private static final Logger log = LoggerFactory.getLogger(AutoScanAbstractInputHandler.class);

    @Override
    public Set<Type> findConstituentAbstractTypes(AnnotatedType javaType, BuildContext buildContext) {
        if (Scalars.isScalar(javaType.getType()) || ClassUtils.isSubPackage(ClassUtils.getRawType(javaType.getType()).getPackage(), "java.") || buildContext.scalarStrategy.isDirectlyDeserializable(javaType)) {
            return Collections.emptySet();
        }
        if (javaType instanceof AnnotatedParameterizedType) {
            Set<Type> abstractTypes = Arrays.stream(((AnnotatedParameterizedType)javaType).getAnnotatedActualTypeArguments()).flatMap(arg -> this.findConstituentAbstractTypes((AnnotatedType)arg, buildContext).stream()).collect(Collectors.toSet());
            abstractTypes.addAll(this.findAbstract(javaType, buildContext));
            return abstractTypes;
        }
        if (javaType instanceof AnnotatedArrayType) {
            return this.findConstituentAbstractTypes(((AnnotatedArrayType)javaType).getAnnotatedGenericComponentType(), buildContext);
        }
        if (javaType instanceof AnnotatedWildcardType || javaType instanceof AnnotatedTypeVariable) {
            throw new TypeMappingException(javaType.getType());
        }
        return this.findAbstract(javaType, buildContext);
    }

    @Override
    public List<Class> findConcreteSubTypes(Class abstractType, BuildContext buildContext) {
        List<Class> subTypes = ClassUtils.findImplementations(abstractType, NON_ABSTRACT.and(NON_IGNORED), buildContext.basePackages);
        if (subTypes.isEmpty()) {
            log.warn("No concrete subtypes of " + abstractType.getName() + " found");
        }
        return subTypes;
    }

    private Set<Type> findAbstract(AnnotatedType javaType, BuildContext buildContext) {
        if (this.abstractComponents.get(javaType.getType()) != null) {
            return this.abstractComponents.get(javaType.getType());
        }
        if (this.abstractComponents.containsKey(javaType.getType())) {
            return Collections.emptySet();
        }
        this.abstractComponents.put(javaType.getType(), null);
        HashSet<Type> abstractTypes = new HashSet<Type>();
        if (ClassUtils.isAbstract(javaType)) {
            abstractTypes.add(javaType.getType());
        }
        buildContext.inputFieldStrategy.getInputFields(javaType, buildContext.inclusionStrategy, buildContext.typeTransformer).forEach(childQuery -> abstractTypes.addAll(this.findConstituentAbstractTypes(childQuery.getDeserializableType(), buildContext)));
        this.abstractComponents.put(javaType.getType(), abstractTypes);
        return abstractTypes;
    }
}

