/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.execution.Executable;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Resolver {
    private final String operationName;
    private final String operationDescription;
    private final String operationDeprecationReason;
    private final List<OperationArgument> arguments;
    private final AnnotatedType returnType;
    private final Set<OperationArgument> contextArguments;
    private final String complexityExpression;
    private final Executable executable;
    private final boolean batched;

    public Resolver(String operationName, String operationDescription, String operationDeprecationReason, boolean batched, Executable executable, AnnotatedType returnType, List<OperationArgument> arguments, String complexityExpression) {
        Set<OperationArgument> contextArguments = this.resolveContexts(arguments);
        if (batched) {
            this.validateBatching(executable.toString(), returnType, contextArguments);
        }
        this.executable = executable;
        this.operationName = operationName;
        this.operationDeprecationReason = operationDeprecationReason;
        this.batched = batched;
        this.operationDescription = operationDescription;
        this.arguments = arguments;
        this.returnType = returnType;
        this.contextArguments = contextArguments;
        this.complexityExpression = complexityExpression;
    }

    private void validateBatching(String executableSignature, AnnotatedType returnType, Set<OperationArgument> contextArguments) {
        if (contextArguments.isEmpty() || !Stream.concat(contextArguments.stream().map(arg -> arg.getJavaType().getType()), Stream.of(returnType.getType())).allMatch(type -> GenericTypeReflector.isSuperType(List.class, (Type)type))) {
            throw new IllegalArgumentException("Resolver method " + executableSignature + " is marked as batched but doesn't return a list or its context argument is not a list");
        }
    }

    private Set<OperationArgument> resolveContexts(List<OperationArgument> arguments) {
        return arguments.stream().filter(OperationArgument::isContext).collect(Collectors.toSet());
    }

    public Object resolve(Object source, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return this.executable.execute(source, args);
    }

    public Set<Type> getSourceTypes() {
        return this.contextArguments.stream().map(arg -> arg.getJavaType().getType()).collect(Collectors.toSet());
    }

    public String getOperationName() {
        return this.operationName;
    }

    public boolean isBatched() {
        return this.batched;
    }

    public String getOperationDescription() {
        return this.operationDescription;
    }

    public String getOperationDeprecationReason() {
        return this.operationDeprecationReason;
    }

    public Set<String> getFingerprints() {
        HashSet<String> fingerprints = new HashSet<String>(this.contextArguments.size() + 1);
        this.contextArguments.forEach(context -> fingerprints.add(this.fingerprint((OperationArgument)context)));
        fingerprints.add(this.fingerprint(null));
        return fingerprints;
    }

    public List<OperationArgument> getArguments() {
        return this.arguments;
    }

    public AnnotatedType getReturnType() {
        return this.returnType;
    }

    public String getComplexityExpression() {
        return this.complexityExpression;
    }

    private String fingerprint(OperationArgument ignoredResolverSource) {
        StringBuilder fingerprint = new StringBuilder();
        this.arguments.stream().filter(arg -> arg != ignoredResolverSource).filter(OperationArgument::isMappable).map(OperationArgument::getName).sorted().forEach(fingerprint::append);
        return fingerprint.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Resolver && this.executable.equals(((Resolver)that).executable);
    }

    public int hashCode() {
        return this.executable.hashCode();
    }

    public String toString() {
        return this.executable.toString();
    }
}

