/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.execution;

import io.leangen.graphql.metadata.execution.Executable;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class MethodInvoker
extends Executable {
    private AnnotatedType enclosingType;
    private AnnotatedType returnType;

    public MethodInvoker(Method resolverMethod, AnnotatedType enclosingType) {
        this.delegate = resolverMethod;
        this.enclosingType = enclosingType;
        this.returnType = this.resolveReturnType(enclosingType);
    }

    @Override
    public Object execute(Object target, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return ((Method)this.delegate).invoke(target, args);
    }

    @Override
    public AnnotatedType getReturnType() {
        return this.returnType;
    }

    private AnnotatedType resolveReturnType(AnnotatedType enclosingType) {
        return ClassUtils.getReturnType((Method)this.delegate, enclosingType);
    }

    @Override
    public int getParameterCount() {
        return ((Method)this.delegate).getParameterCount();
    }

    @Override
    public AnnotatedType[] getAnnotatedParameterTypes() {
        return ClassUtils.getParameterTypes((Method)this.delegate, this.enclosingType);
    }

    @Override
    public Parameter[] getParameters() {
        return ((Method)this.delegate).getParameters();
    }
}

