/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLId;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.OperationArgumentDefaultValue;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.ArgumentBuilderParams;
import io.leangen.graphql.metadata.strategy.query.ResolverArgumentBuilder;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedArgumentBuilder
implements ResolverArgumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedArgumentBuilder.class);

    @Override
    public List<OperationArgument> buildResolverArguments(ArgumentBuilderParams params) {
        Method resolverMethod = params.getResolverMethod();
        ArrayList<OperationArgument> operationArguments = new ArrayList<OperationArgument>(resolverMethod.getParameterCount());
        AnnotatedType[] parameterTypes = ClassUtils.getParameterTypes(resolverMethod, params.getDeclaringType());
        for (int i = 0; i < resolverMethod.getParameterCount(); ++i) {
            AnnotatedType parameterType;
            Parameter parameter = resolverMethod.getParameters()[i];
            if (parameter.isSynthetic() || parameter.isImplicit()) continue;
            try {
                parameterType = params.getTypeTransformer().transform(parameterTypes[i]);
            }
            catch (TypeMappingException e) {
                throw new TypeMappingException(resolverMethod, parameter, (Exception)e);
            }
            parameterType = ClassUtils.addAnnotations(parameterType, parameter.getAnnotations());
            operationArguments.add(new OperationArgument(parameterType, this.getArgumentName(parameter, parameterType, params.getInclusionStrategy()), this.getArgumentDescription(parameter, parameterType), this.defaultValue(parameter, parameterType), parameter.isAnnotationPresent(GraphQLContext.class), params.getInclusionStrategy().includeArgument(parameter, parameterType)));
        }
        return operationArguments;
    }

    protected String getArgumentName(Parameter parameter, AnnotatedType parameterType, InclusionStrategy inclusionStrategy) {
        if (Optional.ofNullable(parameterType.getAnnotation(GraphQLId.class)).filter(GraphQLId::relayId).isPresent()) {
            return "id";
        }
        GraphQLArgument meta = parameter.getAnnotation(GraphQLArgument.class);
        if (meta != null && !meta.name().isEmpty()) {
            return meta.name();
        }
        if (!parameter.isNamePresent() && inclusionStrategy.includeArgument(parameter, parameterType)) {
            log.warn("No explicit argument name given and the parameter name lost in compilation: " + parameter.getDeclaringExecutable().toGenericString() + "#" + parameter.toString() + ". For details and possible solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#missing-argument-name");
        }
        return parameter.getName();
    }

    protected String getArgumentDescription(Parameter parameter, AnnotatedType parameterType) {
        GraphQLArgument meta = parameter.getAnnotation(GraphQLArgument.class);
        return meta != null ? meta.description() : null;
    }

    protected OperationArgumentDefaultValue defaultValue(Parameter parameter, AnnotatedType parameterType) {
        GraphQLArgument meta = parameter.getAnnotation(GraphQLArgument.class);
        if (meta == null) {
            return OperationArgumentDefaultValue.EMPTY;
        }
        try {
            return meta.defaultValueProvider().newInstance().getDefaultValue(parameter, parameterType, this.defaultValue(meta.defaultValue()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(meta.defaultValueProvider().getName() + " must expose a public default constructor", e);
        }
    }

    private OperationArgumentDefaultValue defaultValue(String value) {
        if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(value)) {
            return OperationArgumentDefaultValue.EMPTY;
        }
        if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\ue000\n\t\t\t\t\n".equals(value)) {
            return OperationArgumentDefaultValue.NULL;
        }
        return new OperationArgumentDefaultValue(value);
    }
}

