/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.metadata.strategy.query.OperationNameGenerator;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class DelegatingOperationNameGenerator
implements OperationNameGenerator {
    private OperationNameGenerator[] delegateNameGenerators;

    public DelegatingOperationNameGenerator(OperationNameGenerator ... delegateNameGenerators) {
        this.delegateNameGenerators = delegateNameGenerators;
    }

    @Override
    public String generateQueryName(Method queryMethod, AnnotatedType declaringType, Object instance) {
        Optional<String> queryName = this.generateName(queryNameGenerator -> queryNameGenerator.generateQueryName(queryMethod, declaringType, instance));
        return this.requireName(queryName, queryMethod);
    }

    @Override
    public String generateQueryName(Field queryField, AnnotatedType declaringType, Object instance) {
        Optional<String> queryName = this.generateName(queryNameGenerator -> queryNameGenerator.generateQueryName(queryField, declaringType, instance));
        return this.requireName(queryName, queryField);
    }

    private String requireName(Optional<String> queryName, Member query) {
        if (queryName.isPresent()) {
            return queryName.get();
        }
        throw new IllegalStateException("Operation name impossible to determine from method " + query + " using the configured operation name generators: " + this.toString());
    }

    @Override
    public String generateMutationName(Method mutationMethod, AnnotatedType declaringType, Object instance) {
        Optional<String> mutationName = this.generateName(queryNameGenerator -> queryNameGenerator.generateMutationName(mutationMethod, declaringType, instance));
        return this.requireName(mutationName, mutationMethod);
    }

    @Override
    public String generateSubscriptionName(Method subscriptionMethod, AnnotatedType declaringType, Object instance) {
        Optional<String> subscriptionName = this.generateName(queryNameGenerator -> queryNameGenerator.generateSubscriptionName(subscriptionMethod, declaringType, instance));
        return this.requireName(subscriptionName, subscriptionMethod);
    }

    private Optional<String> generateName(Function<OperationNameGenerator, String> nameGeneratorFunction) {
        return Arrays.stream(this.delegateNameGenerators).map(nameGeneratorFunction).filter(queryName -> queryName != null && !queryName.isEmpty()).findFirst();
    }

    public String toString() {
        StringBuilder nameGenerators = new StringBuilder(DelegatingOperationNameGenerator.class.getSimpleName());
        nameGenerators.append("[ ");
        Arrays.stream(this.delegateNameGenerators).forEach(nameGen -> nameGenerators.append(nameGen.getClass().getSimpleName()).append(", "));
        nameGenerators.append("]");
        return nameGenerators.toString();
    }
}

