/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.query.OperationNameGenerator;
import io.leangen.graphql.metadata.strategy.query.ResolverArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilderParams;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public abstract class FilteredResolverBuilder
implements ResolverBuilder {
    protected OperationNameGenerator operationNameGenerator;
    protected ResolverArgumentBuilder argumentBuilder;
    protected List<Predicate<Member>> filters = new ArrayList<Predicate<Member>>();

    public FilteredResolverBuilder withOperationNameGenerator(OperationNameGenerator operationNameGenerator) {
        this.operationNameGenerator = operationNameGenerator;
        return this;
    }

    public FilteredResolverBuilder withResolverArgumentBuilder(ResolverArgumentBuilder argumentBuilder) {
        this.argumentBuilder = argumentBuilder;
        return this;
    }

    @SafeVarargs
    public final FilteredResolverBuilder withFilters(Predicate<Member> ... filters) {
        Collections.addAll(this.filters, filters);
        return this;
    }

    public FilteredResolverBuilder withDefaultFilters() {
        return this.withFilters(REAL_ONLY);
    }

    protected List<Predicate<Member>> getFilters() {
        return this.filters.isEmpty() ? Collections.singletonList(ACCEPT_ALL) : this.filters;
    }

    protected AnnotatedType getFieldType(Field field, ResolverBuilderParams params) {
        try {
            return params.getTypeTransformer().transform(ClassUtils.getFieldType(field, params.getBeanType()));
        }
        catch (TypeMappingException e) {
            throw new TypeMappingException(field, params.getBeanType(), (Exception)e);
        }
    }

    protected AnnotatedType getReturnType(Method method, ResolverBuilderParams params) {
        try {
            return params.getTypeTransformer().transform(ClassUtils.getReturnType(method, params.getBeanType()));
        }
        catch (TypeMappingException e) {
            throw new TypeMappingException((Member)method, params.getBeanType(), (Exception)e);
        }
    }

    static interface NameGenerator {
        public String name(Method var1, AnnotatedType var2, Object var3);
    }
}

