/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import graphql.execution.batched.Batched;
import io.leangen.graphql.annotations.GraphQLComplexity;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.execution.MethodInvoker;
import io.leangen.graphql.metadata.execution.SingletonMethodInvoker;
import io.leangen.graphql.metadata.strategy.query.AnnotatedArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.ArgumentBuilderParams;
import io.leangen.graphql.metadata.strategy.query.FilteredResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.MethodOperationNameGenerator;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilderParams;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public class PublicResolverBuilder
extends FilteredResolverBuilder {
    private String[] basePackages;
    private boolean javaDeprecation;
    private Function<Method, String> descriptionMapper = method -> "";
    private Function<Method, String> deprecationReasonMapper = method -> this.javaDeprecation && method.isAnnotationPresent(Deprecated.class) ? "" : null;

    public PublicResolverBuilder() {
        this(new String[0]);
    }

    public PublicResolverBuilder(String ... basePackages) {
        this.operationNameGenerator = new MethodOperationNameGenerator();
        this.argumentBuilder = new AnnotatedArgumentBuilder();
        this.withBasePackages(basePackages);
        this.withJavaDeprecationRespected(true);
        this.withDefaultFilters();
    }

    public PublicResolverBuilder withBasePackages(String ... basePackages) {
        this.basePackages = basePackages;
        return this;
    }

    public PublicResolverBuilder withJavaDeprecationRespected(boolean javaDeprecation) {
        this.javaDeprecation = javaDeprecation;
        return this;
    }

    public PublicResolverBuilder withDescriptionMapper(Function<Method, String> descriptionMapper) {
        this.descriptionMapper = descriptionMapper;
        return this;
    }

    public PublicResolverBuilder withDeprecationReasonMapper(Function<Method, String> deprecationReasonMapper) {
        this.deprecationReasonMapper = deprecationReasonMapper;
        return this;
    }

    @Override
    public Collection<Resolver> buildQueryResolvers(ResolverBuilderParams params) {
        return this.buildResolvers(params, this::isQuery, this.operationNameGenerator::generateQueryName, true);
    }

    @Override
    public Collection<Resolver> buildMutationResolvers(ResolverBuilderParams params) {
        return this.buildResolvers(params, this::isMutation, this.operationNameGenerator::generateMutationName, false);
    }

    @Override
    public Collection<Resolver> buildSubscriptionResolvers(ResolverBuilderParams params) {
        return this.buildResolvers(params, this::isSubscription, this.operationNameGenerator::generateSubscriptionName, false);
    }

    private Collection<Resolver> buildResolvers(ResolverBuilderParams params, Predicate<Method> filter, FilteredResolverBuilder.NameGenerator nameGenerator, boolean batchable) {
        AnnotatedType beanType = params.getBeanType();
        Object querySourceBean = params.getQuerySourceBean();
        Class rawType = ClassUtils.getRawType(beanType.getType());
        if (rawType.isArray() || rawType.isPrimitive()) {
            return Collections.emptyList();
        }
        return Arrays.stream(rawType.getMethods()).filter(method -> this.isPackageAcceptable((Method)method, rawType, params.getBasePackages())).filter(filter).filter(method -> params.getInclusionStrategy().includeOperation((AnnotatedElement)method, this.getReturnType((Method)method, params))).filter(this.getFilters().stream().reduce(Predicate::and).orElse(ACCEPT_ALL)).map(method -> new Resolver(nameGenerator.name((Method)method, beanType, querySourceBean), this.descriptionMapper.apply((Method)method), this.deprecationReasonMapper.apply((Method)method), batchable && method.isAnnotationPresent(Batched.class), querySourceBean == null ? new MethodInvoker((Method)method, beanType) : new SingletonMethodInvoker(querySourceBean, (Method)method, beanType), this.getReturnType((Method)method, params), this.argumentBuilder.buildResolverArguments(new ArgumentBuilderParams((Method)method, beanType, params.getInclusionStrategy(), params.getTypeTransformer())), method.isAnnotationPresent(GraphQLComplexity.class) ? method.getAnnotation(GraphQLComplexity.class).value() : null)).collect(Collectors.toList());
    }

    protected boolean isQuery(Method method) {
        return !this.isMutation(method) && !this.isSubscription(method);
    }

    protected boolean isMutation(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    protected boolean isSubscription(Method method) {
        return method.getReturnType() == Publisher.class;
    }

    protected boolean isPackageAcceptable(Method method, Class<?> beanType, String[] defaultPackages) {
        String[] basePackages = new String[]{};
        if (Utils.isArrayNotEmpty(this.basePackages)) {
            basePackages = this.basePackages;
        } else if (Utils.isArrayNotEmpty(defaultPackages)) {
            basePackages = defaultPackages;
        } else if (beanType.getPackage() != null) {
            basePackages = new String[]{beanType.getPackage().getName()};
        }
        basePackages = (String[])Arrays.stream(basePackages).filter(Utils::isNotEmpty).toArray(String[]::new);
        return method.getDeclaringClass().equals(beanType) || Arrays.stream(basePackages).anyMatch(basePackage -> ClassUtils.isSubPackage(method.getDeclaringClass().getPackage(), basePackage));
    }
}

