/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.type.TypeTransformer;
import io.leangen.graphql.metadata.strategy.value.InputFieldDiscoveryStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class GsonValueMapper
implements ValueMapper,
InputFieldDiscoveryStrategy {
    private final Gson gson;

    public GsonValueMapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T fromInput(Object graphQLInput, Type sourceType, AnnotatedType outputType) {
        if (graphQLInput.getClass() == outputType.getType()) {
            return (T)graphQLInput;
        }
        JsonElement jsonElement = this.gson.toJsonTree(graphQLInput, sourceType);
        return (T)this.gson.fromJson(jsonElement, outputType.getType());
    }

    @Override
    public <T> T fromString(String json, AnnotatedType outputType) {
        return (T)this.gson.fromJson(json, outputType.getType());
    }

    @Override
    public String toString(Object output) {
        return this.gson.toJson(output);
    }

    @Override
    public Set<InputField> getInputFields(AnnotatedType type, InclusionStrategy inclusionStrategy, TypeTransformer typeTransformer) {
        HashSet<InputField> inputFields = new HashSet<InputField>();
        Class raw = ClassUtils.getRawType(type.getType());
        if (raw.isInterface() || raw.isPrimitive()) {
            return inputFields;
        }
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                Field target;
                AnnotatedType fieldType;
                if (this.gson.excluder().excludeClass(field.getType(), false) || this.gson.excluder().excludeField(field, false)) continue;
                try {
                    fieldType = typeTransformer.transform(ClassUtils.getFieldType(field, type));
                }
                catch (TypeMappingException e) {
                    throw new TypeMappingException(field, type, (Exception)e);
                }
                Optional<Method> setter = ClassUtils.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
                Member member = target = setter.isPresent() ? (Member)setter.get() : field;
                if (!inclusionStrategy.includeInputField(target.getDeclaringClass(), target, fieldType)) continue;
                field.setAccessible(true);
                String fieldName = this.gson.fieldNamingStrategy().translateName(field);
                if (inputFields.add(new InputField(fieldName, null, fieldType, null))) continue;
                throw new IllegalArgumentException(raw + " declares multiple input fields named " + fieldName);
            }
            raw = raw.getSuperclass();
            type = GenericTypeReflector.getExactSuperType((AnnotatedType)type, raw);
        }
        return inputFields;
    }
}

