/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.value.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.metadata.strategy.type.DefaultTypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.ScalarDeserializationStrategy;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.jackson.AnnotationIntrospector;
import io.leangen.graphql.metadata.strategy.value.jackson.ConvertingDeserializers;
import io.leangen.graphql.metadata.strategy.value.jackson.JacksonValueMapper;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JacksonValueMapperFactory
implements ValueMapperFactory<JacksonValueMapper>,
ScalarDeserializationStrategy {
    private final ObjectMapper prototype;
    private final Configurer configurer;
    private final TypeInfoGenerator typeInfoGenerator;

    public JacksonValueMapperFactory() {
        this(null, new DefaultTypeInfoGenerator(), new AbstractClassAdapterConfigurer());
    }

    private JacksonValueMapperFactory(ObjectMapper prototype, TypeInfoGenerator typeInfoGenerator, Configurer configurer) {
        this.prototype = prototype;
        this.configurer = Objects.requireNonNull(configurer);
        this.typeInfoGenerator = Objects.requireNonNull(typeInfoGenerator);
    }

    @Override
    public JacksonValueMapper getValueMapper(Map<Class, List<Class>> concreteSubTypes, GlobalEnvironment environment) {
        ObjectMapper mapper = this.prototype != null ? this.prototype.copy() : new ObjectMapper();
        ObjectMapper objectMapper = this.configurer.configure(mapper, concreteSubTypes, this.typeInfoGenerator, environment);
        return new JacksonValueMapper(objectMapper);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isDirectlyDeserializable(AnnotatedType type) {
        return GenericTypeReflector.isSuperType(TreeNode.class, (Type)type.getType());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.typeInfoGenerator.getClass().getSimpleName();
    }

    public static class Builder {
        private Configurer configurer = new AbstractClassAdapterConfigurer();
        private TypeInfoGenerator typeInfoGenerator = new DefaultTypeInfoGenerator();
        private ObjectMapper prototype;

        public Builder withConfigurer(Configurer configurer) {
            this.configurer = configurer;
            return this;
        }

        public Builder withTypeInfoGenerator(TypeInfoGenerator typeInfoGenerator) {
            this.typeInfoGenerator = typeInfoGenerator;
            return this;
        }

        public Builder withPrototype(ObjectMapper prototype) {
            this.prototype = prototype;
            return this;
        }

        public JacksonValueMapperFactory build() {
            return new JacksonValueMapperFactory(this.prototype, this.typeInfoGenerator, this.configurer);
        }
    }

    @FunctionalInterface
    public static interface Configurer {
        public ObjectMapper configure(ObjectMapper var1, Map<Class, List<Class>> var2, TypeInfoGenerator var3, GlobalEnvironment var4);
    }

    public static class AbstractClassAdapterConfigurer
    implements Configurer {
        @Override
        public ObjectMapper configure(ObjectMapper objectMapper, Map<Class, List<Class>> concreteSubTypes, TypeInfoGenerator metaDataGen, GlobalEnvironment environment) {
            ObjectMapper mapper = objectMapper.findAndRegisterModules().registerModule(this.getAnnotationIntrospectorModule(this.collectSubtypes(concreteSubTypes, metaDataGen)));
            if (environment != null && !environment.getInputConverters().isEmpty()) {
                mapper.registerModule(this.getDeserializersModule(environment));
            }
            return mapper;
        }

        private Map<Type, List<NamedType>> collectSubtypes(Map<Class, List<Class>> concreteSubTypes, TypeInfoGenerator metaDataGen) {
            HashMap<Type, List<NamedType>> types = new HashMap<Type, List<NamedType>>();
            concreteSubTypes.forEach((abstractType, concreteTypes) -> {
                List subTypes = concreteTypes.stream().map(sub -> new NamedType(sub, metaDataGen.generateTypeName(GenericTypeReflector.annotate((Type)sub)))).collect(Collectors.toList());
                if (!subTypes.isEmpty()) {
                    types.put((Type)abstractType, subTypes);
                }
            });
            return types;
        }

        private Module getDeserializersModule(final GlobalEnvironment environment) {
            return new Module(){

                public String getModuleName() {
                    return "graphql-spqr-deserializers";
                }

                public Version version() {
                    return Version.unknownVersion();
                }

                public void setupModule(Module.SetupContext setupContext) {
                    setupContext.addDeserializers((Deserializers)new ConvertingDeserializers(environment));
                }
            };
        }

        private Module getAnnotationIntrospectorModule(final Map<Type, List<NamedType>> typeMap) {
            return new SimpleModule("graphql-spqr-annotation-introspector"){

                public void setupModule(Module.SetupContext context) {
                    super.setupModule(context);
                    context.insertAnnotationIntrospector((com.fasterxml.jackson.databind.AnnotationIntrospector)new AnnotationIntrospector(typeMap));
                }
            };
        }
    }
}

