/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.gson.GsonValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.jackson.JacksonValueMapperFactory;
import io.leangen.graphql.util.ClassUtils;

public class Defaults {
    private static final IllegalStateException noJsonLib = new IllegalStateException("No JSON deserialization library found on classpath. A compatible version of either Jackson or Gson must be available or a custom ValueMapperFactory must be provided");

    private static JsonLib jsonLibrary() {
        for (JsonLib jsonLib : JsonLib.values()) {
            try {
                ClassUtils.forName(jsonLib.requiredClass);
                return jsonLib;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw noJsonLib;
    }

    public static ValueMapperFactory valueMapperFactory(TypeInfoGenerator typeInfoGenerator) {
        switch (Defaults.jsonLibrary()) {
            case GSON: {
                return GsonValueMapperFactory.builder().withTypeInfoGenerator(typeInfoGenerator).build();
            }
            case JACKSON: {
                return JacksonValueMapperFactory.builder().withTypeInfoGenerator(typeInfoGenerator).build();
            }
        }
        throw noJsonLib;
    }

    private static enum JsonLib {
        JACKSON("com.fasterxml.jackson.databind.ObjectMapper"),
        GSON("com.google.gson.Gson");

        public final String requiredClass;

        private JsonLib(String requiredClass) {
            this.requiredClass = requiredClass;
        }
    }
}

