/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import graphql.GraphQLException;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Scalars {
    public static final GraphQLNonNull RelayId = new GraphQLNonNull((GraphQLType)graphql.Scalars.GraphQLID);
    public static final GraphQLScalarType GraphQLUuid = new GraphQLScalarType("UUID", "Built-in UUID", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof String) {
                return dataFetcherResult;
            }
            if (dataFetcherResult instanceof UUID) {
                return dataFetcherResult.toString();
            }
            throw Scalars.serializationException(dataFetcherResult, new Class[]{String.class, UUID.class});
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return UUID.fromString((String)input);
            }
            if (input instanceof UUID) {
                return input;
            }
            throw Scalars.valueParsingException(input, new Class[]{String.class, UUID.class});
        }

        public Object parseLiteral(Object input) {
            StringValue string = (StringValue)Scalars.literalOrException(input, StringValue.class);
            return UUID.fromString(string.getValue());
        }
    });
    public static final GraphQLScalarType GraphQLUri = new GraphQLScalarType("URI", "Built-in URI", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof URI) {
                return dataFetcherResult.toString();
            }
            if (dataFetcherResult instanceof String) {
                return dataFetcherResult;
            }
            throw Scalars.serializationException(dataFetcherResult, new Class[]{String.class, URI.class});
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return URI.create((String)input);
            }
            if (input instanceof URI) {
                return input;
            }
            throw Scalars.valueParsingException(input, new Class[]{String.class, URI.class});
        }

        public Object parseLiteral(Object input) {
            StringValue string = (StringValue)Scalars.literalOrException(input, StringValue.class);
            return URI.create(string.getValue());
        }
    });
    public static final GraphQLScalarType GraphQLLocale = new GraphQLScalarType("Locale", "Built-in Locale", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof Locale) {
                return ((Locale)dataFetcherResult).toLanguageTag();
            }
            if (dataFetcherResult instanceof String) {
                return dataFetcherResult;
            }
            throw Scalars.serializationException(dataFetcherResult, new Class[]{String.class, Locale.class});
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return Locale.forLanguageTag((String)input);
            }
            if (input instanceof Locale) {
                return input;
            }
            throw Scalars.valueParsingException(input, new Class[]{String.class, Locale.class});
        }

        public Object parseLiteral(Object input) {
            StringValue string = (StringValue)Scalars.literalOrException(input, StringValue.class);
            return Locale.forLanguageTag(string.getValue());
        }
    });
    public static final GraphQLScalarType GraphQLDate = Scalars.temporalScalar(java.util.Date.class, "Date", "an instant in time", s -> new java.util.Date(Instant.parse(s).toEpochMilli()), i -> new java.util.Date(i.toEpochMilli()), d -> d.toInstant().toString());
    public static final GraphQLScalarType GraphQLSqlDate = Scalars.temporalScalar(Date.class, "SqlDate", "a SQL compliant local date", s -> Date.valueOf(LocalDate.parse(s)), i -> Date.valueOf(i.atZone(ZoneOffset.UTC).toLocalDate()), d -> d.toLocalDate().toString());
    public static final GraphQLScalarType GraphQLCalendar = Scalars.temporalScalar(Calendar.class, "Calendar", "a date-time with a time-zone", s -> GregorianCalendar.from(ZonedDateTime.parse(s)), i -> GregorianCalendar.from(i.atZone(ZoneOffset.UTC)), c -> c.toInstant().toString());
    public static final GraphQLScalarType GraphQLInstant = Scalars.temporalScalar(Instant.class, "Instant", "an instant in time", Instant::parse, Function.identity());
    public static final GraphQLScalarType GraphQLLocalDate = Scalars.temporalScalar(LocalDate.class, "LocalDate", "a local date", LocalDate::parse, i -> i.atZone(ZoneOffset.UTC).toLocalDate());
    public static final GraphQLScalarType GraphQLLocalTime = Scalars.temporalScalar(LocalTime.class, "LocalTime", "a local time", LocalTime::parse, i -> i.atZone(ZoneOffset.UTC).toLocalTime());
    public static final GraphQLScalarType GraphQLLocalDateTime = Scalars.temporalScalar(LocalDateTime.class, "LocalDateTime", "a local date-time", LocalDateTime::parse, i -> i.atZone(ZoneOffset.UTC).toLocalDateTime());
    public static final GraphQLScalarType GraphQLZonedDateTime = Scalars.temporalScalar(ZonedDateTime.class, "ZonedDateTime", "a date-time with a time-zone", ZonedDateTime::parse, i -> i.atZone(ZoneOffset.UTC));
    public static final GraphQLScalarType GraphQLOffsetDateTime = Scalars.temporalScalar(OffsetDateTime.class, "OffsetDateTime", "a date-time with a UTC offset", OffsetDateTime::parse, i -> i.atOffset(ZoneOffset.UTC));
    public static final GraphQLScalarType GraphQLDurationScalar = Scalars.temporalScalar(Duration.class, "Duration", "an amount of time", Duration::parse, instant -> Duration.ofMillis(instant.toEpochMilli()));
    public static final GraphQLScalarType GraphQLPeriodScalar = Scalars.temporalScalar(Period.class, "Period", "a period of time", Period::parse, instant -> {
        throw new GraphQLException("Period can not be deserialized from a numeric value");
    });
    private static final Map<Type, GraphQLScalarType> SCALAR_MAPPING = Scalars.getScalarMapping();

    public static GraphQLScalarType graphQLObjectScalar(String name) {
        return new GraphQLScalarType(name, "Built-in scalar for dynamic structures", new Coercing(){

            public Object serialize(Object dataFetcherResult) {
                return dataFetcherResult;
            }

            public Object parseValue(Object input) {
                return input;
            }

            public Object parseLiteral(Object input) {
                return this.parseFieldValue((Value)input);
            }

            private Object parseFieldValue(Value value) {
                if (value instanceof StringValue) {
                    return ((StringValue)value).getValue();
                }
                if (value instanceof IntValue) {
                    return ((IntValue)value).getValue();
                }
                if (value instanceof FloatValue) {
                    return ((FloatValue)value).getValue();
                }
                if (value instanceof BooleanValue) {
                    return ((BooleanValue)value).isValue();
                }
                if (value instanceof EnumValue) {
                    return ((EnumValue)value).getName();
                }
                if (value instanceof NullValue) {
                    return null;
                }
                if (value instanceof ArrayValue) {
                    return ((ArrayValue)value).getValues().stream().map(this::parseFieldValue).collect(Collectors.toList());
                }
                if (value instanceof ObjectValue) {
                    LinkedHashMap map = new LinkedHashMap();
                    ((ObjectValue)value).getObjectFields().forEach(field -> map.put(field.getName(), this.parseFieldValue(field.getValue())));
                    return map;
                }
                throw new CoercingParseLiteralException("Unknown scalar AST type: " + value.getClass().getName());
            }
        });
    }

    public static <T> GraphQLScalarType temporalScalar(Class<?> type, String name, String description, Function<String, T> fromString, Function<Instant, T> fromDate) {
        return Scalars.temporalScalar(type, name, description, fromString, fromDate, Object::toString);
    }

    public static <T> GraphQLScalarType temporalScalar(final Class<?> type, String name, String description, final Function<String, T> fromString, final Function<Instant, T> fromDate, final Function<T, String> toString) {
        return new GraphQLScalarType(name, "Built-in scalar representing " + description, new Coercing(){

            public String serialize(Object dataFetcherResult) {
                return (String)toString.apply(dataFetcherResult);
            }

            public Object parseValue(Object input) {
                if (input instanceof String) {
                    return fromString.apply((String)input);
                }
                if (input instanceof Long) {
                    return fromDate.apply(Instant.ofEpochMilli((Long)input));
                }
                if (type.isInstance(input)) {
                    return input;
                }
                throw Scalars.valueParsingException(input, new Class[]{String.class, Long.class});
            }

            public T parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    return fromString.apply(((StringValue)input).getValue());
                }
                if (input instanceof IntValue) {
                    return fromDate.apply(Instant.ofEpochMilli(((IntValue)input).getValue().longValue()));
                }
                throw Scalars.literalParsingException(input, new Class[]{StringValue.class, IntValue.class});
            }
        });
    }

    private static <T extends Value> T literalOrException(Object input, Class<T> valueType) {
        if (valueType.isInstance(input)) {
            return (T)((Value)valueType.cast(input));
        }
        throw new CoercingParseLiteralException(Scalars.errorMessage(input, valueType));
    }

    private static CoercingParseLiteralException literalParsingException(Object input, Class ... allowedTypes) {
        return new CoercingParseLiteralException(Scalars.errorMessage(input, allowedTypes));
    }

    private static CoercingParseValueException valueParsingException(Object input, Class ... allowedTypes) {
        return new CoercingParseValueException(Scalars.errorMessage(input, allowedTypes));
    }

    private static CoercingSerializeException serializationException(Object input, Class ... allowedTypes) {
        return new CoercingSerializeException(Scalars.errorMessage(input, allowedTypes));
    }

    private static String errorMessage(Object input, Class ... allowedTypes) {
        String types = Arrays.stream(allowedTypes).map(type -> "'" + type.getSimpleName() + "'").collect(Collectors.joining(" or "));
        return String.format("Expected %stype %s but was '%s'", input instanceof Value ? "AST " : "", types, input == null ? "null" : input.getClass().getSimpleName());
    }

    private static String typeName(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getSimpleName();
    }

    public static boolean isScalar(Type javaType) {
        return SCALAR_MAPPING.containsKey(javaType);
    }

    public static GraphQLScalarType toGraphQLScalarType(Type javaType) {
        return SCALAR_MAPPING.get(javaType);
    }

    private static Map<Type, GraphQLScalarType> getScalarMapping() {
        HashMap<Class<Object>, GraphQLScalarType> scalarMapping = new HashMap<Class<Object>, GraphQLScalarType>();
        scalarMapping.put(Character.class, graphql.Scalars.GraphQLChar);
        scalarMapping.put(Character.TYPE, graphql.Scalars.GraphQLChar);
        scalarMapping.put(String.class, graphql.Scalars.GraphQLString);
        scalarMapping.put(Byte.class, graphql.Scalars.GraphQLByte);
        scalarMapping.put(Byte.TYPE, graphql.Scalars.GraphQLByte);
        scalarMapping.put(Short.class, graphql.Scalars.GraphQLShort);
        scalarMapping.put(Short.TYPE, graphql.Scalars.GraphQLShort);
        scalarMapping.put(Integer.class, graphql.Scalars.GraphQLInt);
        scalarMapping.put(Integer.TYPE, graphql.Scalars.GraphQLInt);
        scalarMapping.put(Long.class, graphql.Scalars.GraphQLLong);
        scalarMapping.put(Long.TYPE, graphql.Scalars.GraphQLLong);
        scalarMapping.put(Float.class, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(Float.TYPE, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(Double.class, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(Double.TYPE, graphql.Scalars.GraphQLFloat);
        scalarMapping.put(BigInteger.class, graphql.Scalars.GraphQLBigInteger);
        scalarMapping.put(BigDecimal.class, graphql.Scalars.GraphQLBigDecimal);
        scalarMapping.put(Number.class, graphql.Scalars.GraphQLBigDecimal);
        scalarMapping.put(Boolean.class, graphql.Scalars.GraphQLBoolean);
        scalarMapping.put(Boolean.TYPE, graphql.Scalars.GraphQLBoolean);
        scalarMapping.put(UUID.class, GraphQLUuid);
        scalarMapping.put(URI.class, GraphQLUri);
        scalarMapping.put(java.util.Date.class, GraphQLDate);
        scalarMapping.put(Date.class, GraphQLSqlDate);
        scalarMapping.put(Calendar.class, GraphQLCalendar);
        scalarMapping.put(Instant.class, GraphQLInstant);
        scalarMapping.put(LocalDate.class, GraphQLLocalDate);
        scalarMapping.put(LocalTime.class, GraphQLLocalTime);
        scalarMapping.put(LocalDateTime.class, GraphQLLocalDateTime);
        scalarMapping.put(ZonedDateTime.class, GraphQLZonedDateTime);
        scalarMapping.put(OffsetDateTime.class, GraphQLOffsetDateTime);
        scalarMapping.put(Duration.class, GraphQLDurationScalar);
        scalarMapping.put(Period.class, GraphQLPeriodScalar);
        scalarMapping.put(Locale.class, GraphQLLocale);
        return Collections.unmodifiableMap(scalarMapping);
    }
}

