/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Utils {
    public static final String NULL = "\n\t\t\n\t\t\n\ue000\ue001\ue002\ue000\n\t\t\t\t\n";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> Optional<T> or(Optional<T> left, Optional<T> right) {
        return left.isPresent() ? left : right;
    }

    public static <T> Optional<T> or(Optional<T> left, Supplier<Optional<T>> right) {
        return left.isPresent() ? left : right.get();
    }

    public static boolean isEmpty(String string) {
        return !Utils.isNotEmpty(string);
    }

    public static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    public static String decodeNullable(String string) {
        return NULL.equals(string) ? null : string;
    }

    public static String capitalize(String str) {
        char newChar;
        char firstChar = str.charAt(0);
        if (firstChar == (newChar = Character.toUpperCase(firstChar))) {
            return str;
        }
        char[] newChars = new char[str.length()];
        newChars[0] = newChar;
        str.getChars(1, str.length(), newChars, 1);
        return String.valueOf(newChars);
    }

    public static boolean isArrayEmpty(Object array) {
        return !Utils.isArrayNotEmpty(array);
    }

    public static boolean isArrayNotEmpty(Object array) {
        return array != null && Array.getLength(array) != 0;
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T> ... streams) {
        return Arrays.stream(streams).reduce(Stream::concat).orElse(Stream.empty());
    }

    public static String[] emptyArray() {
        return EMPTY_STRING_ARRAY;
    }
}

