/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util.classpath;

import io.leangen.graphql.util.classpath.AnnotationInfo;
import io.leangen.graphql.util.classpath.ClassReadingException;
import io.leangen.graphql.util.classpath.FieldInfo;
import io.leangen.graphql.util.classpath.MethodInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;

public class ClassInfo
extends ClassVisitor {
    static int ASM_CR_ACCEPT_CRITERIA = 0;
    private int modifier = 0;
    private String className = null;
    private String superClassName = null;
    private String[] implementedInterfaces = new String[0];
    private Set<AnnotationNode> annotations = new HashSet<AnnotationNode>();
    private File locationFound = null;
    private Set<FieldInfo> fields = new HashSet<FieldInfo>();
    private Set<MethodInfo> methods = new HashSet<MethodInfo>();

    public ClassInfo(File classFile) throws ClassReadingException {
        super(327680);
        try {
            ClassReader cr = new ClassReader((InputStream)new FileInputStream(classFile));
            cr.accept((ClassVisitor)this, ASM_CR_ACCEPT_CRITERIA);
        }
        catch (IOException ex) {
            throw new ClassReadingException("Unable to load class file \"{0}\"", ex);
        }
    }

    public ClassInfo(InputStream is) throws ClassReadingException {
        super(327680);
        try {
            ClassReader cr = new ClassReader(is);
            cr.accept((ClassVisitor)this, ASM_CR_ACCEPT_CRITERIA);
        }
        catch (IOException ex) {
            throw new ClassReadingException("Unable to load class from open  input stream", ex);
        }
    }

    ClassInfo(String name, String superClassName, String[] interfaces, int asmAccessMask, File location) {
        super(327680);
        this.setClassFields(name, superClassName, interfaces, asmAccessMask, location);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String[] getInterfaces() {
        return this.implementedInterfaces;
    }

    public Set<AnnotationInfo> getAnnotations() {
        return this.annotations.stream().map(node -> new AnnotationInfo(this.translateInternalAnnotationClassName(node.desc), node.values)).collect(Collectors.toSet());
    }

    public int getModifier() {
        return this.modifier;
    }

    public File getClassLocation() {
        return this.locationFound;
    }

    public Set<FieldInfo> getFields() {
        return this.fields;
    }

    public Set<MethodInfo> getMethods() {
        return this.methods;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String sep = " ";
        buf.append(this.annotations.stream().map(ann -> "@" + ann.desc).collect(Collectors.joining(sep)));
        if (buf.length() > 0) {
            buf.append(sep);
        }
        if ((this.modifier & 1) != 0) {
            buf.append("public ");
        }
        if ((this.modifier & 0x400) != 0) {
            buf.append("abstract ");
        }
        if ((this.modifier & 0x200) != 0) {
            buf.append("interface ");
        } else {
            buf.append("class ");
        }
        buf.append(this.className);
        if (this.implementedInterfaces.length > 0) {
            buf.append(" implements");
            for (String intf : this.implementedInterfaces) {
                buf.append(sep);
                buf.append(intf);
            }
        }
        if (this.superClassName != null && !this.superClassName.equals("java.lang.Object")) {
            buf.append(sep);
            buf.append("extends ");
            buf.append(this.superClassName);
        }
        return buf.toString();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.setClassFields(name, superName, interfaces, access, null);
    }

    public FieldVisitor visitField(int access, String name, String description, String signature, Object value) {
        this.fields.add(new FieldInfo(access, name, description, signature, value));
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String description, String signature, String[] exceptions) {
        this.methods.add(new MethodInfo(access, name, description, signature, exceptions));
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (visible) {
            AnnotationNode ann = new AnnotationNode(desc);
            this.annotations.add(ann);
            return ann;
        }
        return null;
    }

    private String translateInternalClassName(String internalName) {
        return internalName.replaceAll("/", ".");
    }

    private String translateInternalAnnotationClassName(String internalName) {
        return this.translateInternalClassName(internalName).replaceAll("^L", "").replaceAll(";$", "");
    }

    private void setClassFields(String name, String superClassName, String[] interfaces, int asmAccessMask, File location) {
        this.className = this.translateInternalClassName(name);
        this.locationFound = location;
        if (superClassName != null && !superClassName.equals("java/lang/Object")) {
            this.superClassName = this.translateInternalClassName(superClassName);
        }
        if (interfaces != null) {
            this.implementedInterfaces = (String[])Arrays.stream(interfaces).map(this::translateInternalClassName).toArray(String[]::new);
        }
        this.modifier = this.convertAccessMaskToModifierMask(asmAccessMask);
    }

    private int convertAccessMaskToModifierMask(int asmAccessMask) {
        int modifier = 0;
        if ((asmAccessMask & 0x10) != 0) {
            modifier |= 0x10;
        }
        if ((asmAccessMask & 0x100) != 0) {
            modifier |= 0x100;
        }
        if ((asmAccessMask & 0x200) != 0) {
            modifier |= 0x200;
        }
        if ((asmAccessMask & 0x400) != 0) {
            modifier |= 0x400;
        }
        if ((asmAccessMask & 2) != 0) {
            modifier |= 2;
        }
        if ((asmAccessMask & 4) != 0) {
            modifier |= 4;
        }
        if ((asmAccessMask & 1) != 0) {
            modifier |= 1;
        }
        if ((asmAccessMask & 8) != 0) {
            modifier |= 8;
        }
        if ((asmAccessMask & 0x800) != 0) {
            modifier |= 0x800;
        }
        if ((asmAccessMask & 0x20) != 0) {
            modifier |= 0x20;
        }
        if ((asmAccessMask & 0x80) != 0) {
            modifier |= 0x80;
        }
        if ((asmAccessMask & 0x40) != 0) {
            modifier |= 0x40;
        }
        return modifier;
    }
}

