/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.OutputConverter;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CollectionOutputConverter
implements OutputConverter {
    public Object convertOutput(Object original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        if (GenericTypeReflector.isSuperType(Collection.class, (Type)type.getType())) {
            return this.processCollection((Collection)original, (AnnotatedParameterizedType)type, resolutionEnvironment);
        }
        return this.processMap((Map)original, (AnnotatedParameterizedType)type, resolutionEnvironment);
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return GenericTypeReflector.isSuperType(Collection.class, (Type)type.getType()) || GenericTypeReflector.isSuperType(Map.class, (Type)type.getType());
    }

    private List<?> processCollection(Collection<?> collection, AnnotatedParameterizedType type, ResolutionEnvironment resolutionEnvironment) {
        return collection.stream().map(e -> resolutionEnvironment.convertOutput(e, type.getAnnotatedActualTypeArguments()[0])).collect(Collectors.toList());
    }

    private Map<?, ?> processMap(Map<?, ?> map, AnnotatedParameterizedType type, ResolutionEnvironment resolutionEnvironment) {
        LinkedHashMap processed = new LinkedHashMap();
        map.forEach((k, v) -> processed.put(resolutionEnvironment.convertOutput(k, type.getAnnotatedActualTypeArguments()[0]), resolutionEnvironment.convertOutput(v, type.getAnnotatedActualTypeArguments()[1])));
        return processed;
    }
}

